/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.BooleanType;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.Util;
import soot.HjToJimple.jimple.HjAbstractArrayOper;
import soot.HjToJimple.jimple.HjArrayOper;
import soot.HjToJimple.util.Dist;
import soot.HjToJimple.util.HjValueBox;
import soot.Immediate;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayConstructor
extends HjAbstractArrayOper
implements HjArrayOper {
    protected Dist dist;
    protected SootClass pointwise;
    protected List localBoxesList;
    protected SootClass arrayClass;

    public HjArrayConstructor(Dist dist) {
        this.dist = dist;
    }

    public HjArrayConstructor(Dist dist, SootClass pointwise) {
        this.dist = dist;
        this.pointwise = pointwise;
    }

    public HjArrayConstructor(Dist dist, SootClass pointwise, List localsList, SootClass arrayClass) {
        this.dist = dist;
        this.pointwise = pointwise;
        if (localsList != null && localsList.size() > 0) {
            this.localBoxesList = new ArrayList();
            Iterator localIter = localsList.iterator();
            while (localIter.hasNext()) {
                this.localBoxesList.add(new HjValueBox((Local)localIter.next()));
            }
        }
        this.arrayClass = arrayClass;
    }

    public SootClass getPointWise() {
        return this.pointwise;
    }

    public void setPointWise(SootClass pointwise) {
        this.pointwise = pointwise;
    }

    @Override
    public Object clone() {
        return new HjArrayConstructor(this.dist, this.pointwise);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxesList = new ArrayList<ValueBox>();
        if (this.dist != null) {
            ValueBox distVB = this.dist.getLocalValueBox();
            List valUseBoxes = distVB.getValue().getUseBoxes();
            if (valUseBoxes.size() == 0) {
                useBoxesList.add(distVB);
            } else {
                useBoxesList.addAll(valUseBoxes);
            }
        }
        if (this.localBoxesList != null) {
            useBoxesList.addAll(this.localBoxesList);
        }
        return useBoxesList;
    }

    @Override
    public List getDefBoxes() {
        return Collections.emptyList();
    }

    @Override
    public Stmt generateStmt() {
        return this.generateStmt(null);
    }

    public Stmt generateStmt(Local retLocal) {
        return null;
    }

    @Override
    public List<Stmt> generateStmts(HabLocalGenerator lg) {
        return this.generateStmts(null, lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, HabLocalGenerator lg) {
        Local distLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        ArrayList paramList = new ArrayList();
        ArrayList<Type> typeList = new ArrayList<Type>();
        if (this.localBoxesList != null) {
            Iterator localBoxIter = this.localBoxesList.iterator();
            while (localBoxIter.hasNext()) {
                Value value = ((ValueBox)localBoxIter.next()).getValue();
                paramList.add(value);
                typeList.add(value.getType());
            }
        }
        SootClass pointwise = this.pointwise;
        Local objectLocal = null;
        if (pointwise != null) {
            SootMethod initMethod = pointwise.getMethodFromCH("<init>", typeList, VoidType.v());
            objectLocal = lg.generateLocal("$", pointwise.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(objectLocal, Jimple.v().newNewExpr(pointwise.getType()));
            stmts.add(assignStmt);
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(objectLocal, initMethod.makeRef(), paramList));
            stmts.add(invokeStmt);
        }
        SootClass arrayFactory = Scene.v().getSootClass("hj.array.sharedmemory.SpecializedArrayFactory");
        Local factoryLocal = lg.generateLocal("$", arrayFactory.getType());
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(Scene.v().makeFieldRef(arrayFactory, "factory", arrayFactory.getType(), true));
        stmts.add(Jimple.v().newAssignStmt(factoryLocal, fieldRef));
        Value distValue = this.dist.getDistValue();
        if (!(distValue instanceof Local)) {
            distLocal = lg.generateLocal("$", distValue.getType());
            stmts.add(Jimple.v().newAssignStmt(distLocal, distValue));
        } else {
            distLocal = (Local)distValue;
        }
        typeList = new ArrayList();
        typeList.add(distLocal.getType());
        typeList.add(Scene.v().getSootClass("hj.array.Operator$Pointwise").getType());
        typeList.add(BooleanType.v());
        typeList.add(BooleanType.v());
        typeList.add(BooleanType.v());
        paramList = this.getParamList(distLocal, objectLocal, this.arrayClass);
        RefType retType = this.arrayClass.getType();
        SootMethod arrayMethod = this.getArrayMethod(arrayFactory, typeList, retType);
        Local arrayLocal = lg.generateLocal("$", this.arrayClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(arrayLocal, Jimple.v().newVirtualInvokeExpr(factoryLocal, arrayMethod.makeRef(), paramList));
        stmts.add(assignStmt);
        if (retValue != null) {
            stmts.add(Jimple.v().newAssignStmt(retValue, arrayLocal));
        }
        return stmts;
    }

    protected SootMethod getArrayMethod(SootClass factoryClass, ArrayList typeList, Type retType) {
        SootClass retClass = ((RefType)retType).getSootClass();
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.DoubleReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.doubleArray"))) {
            return factoryClass.getMethodFromCH("DoubleArray", typeList, Scene.v().getSootClass("hj.lang.DoubleReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.GenericReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.genericArray"))) {
            return factoryClass.getMethodFromCH("GenericArray", typeList, Scene.v().getSootClass("hj.lang.GenericReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.IntReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.intArray"))) {
            return factoryClass.getMethodFromCH("IntArray", typeList, Scene.v().getSootClass("hj.lang.IntReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.LongReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.longArray"))) {
            return factoryClass.getMethodFromCH("LongArray", typeList, Scene.v().getSootClass("hj.lang.LongReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.FloatReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.floatArray"))) {
            return factoryClass.getMethodFromCH("FloatArray", typeList, Scene.v().getSootClass("hj.lang.FloatReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.ShortReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.shortArray"))) {
            return factoryClass.getMethodFromCH("ShortArray", typeList, Scene.v().getSootClass("hj.lang.ShortReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.BooleanReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.booleanArray"))) {
            return factoryClass.getMethodFromCH("BooleanArray", typeList, Scene.v().getSootClass("hj.lang.BooleanReferenceArray").getType());
        }
        if (Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.ByteReferenceArray")) || Util.isInstance(retClass, Scene.v().getSootClass("hj.lang.byteArray"))) {
            return factoryClass.getMethodFromCH("ByteArray", typeList, Scene.v().getSootClass("hj.lang.ByteReferenceArray").getType());
        }
        throw new RuntimeException("No supported return array type " + retType);
    }

    protected ArrayList getParamList(Local distLocal, Local pwLocal, SootClass arrayClass) {
        ArrayList<Immediate> paramList = new ArrayList<Immediate>();
        paramList.add(distLocal);
        if (this.pointwise != null) {
            paramList.add(pwLocal);
            paramList.add(IntConstant.v(1));
            paramList.add(IntConstant.v(0));
        } else {
            paramList.add(NullConstant.v());
            paramList.add(IntConstant.v(1));
            paramList.add(IntConstant.v(1));
        }
        paramList.add(IntConstant.v(0));
        return paramList;
    }

    @Override
    public String toString() {
        String str = "HjArrayConstructor pointwise: " + this.pointwise + " distribution: " + this.dist;
        str = str + " locals: ";
        if (this.localBoxesList != null) {
            Iterator localBoxIter = this.localBoxesList.iterator();
            while (localBoxIter.hasNext()) {
                str = str + ((ValueBox)localBoxIter.next()).getValue() + " ";
            }
        }
        return str;
    }
}

