/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.HjRegionEntry;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.util.Clock;
import soot.HjToJimple.util.Place;
import soot.RefType;
import soot.Type;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjAsyncRegionExpr
extends HjRegionEntry
implements AsyncRegionExpr {
    protected List<Clock> clocks;
    protected List<Place> places;

    public HjAsyncRegionExpr() {
        this.clocks = new ArrayList<Clock>();
        this.places = new ArrayList<Place>();
    }

    public HjAsyncRegionExpr(List<Clock> clocks, List<Place> places) {
        this.clocks = clocks;
        this.places = places;
    }

    public HjAsyncRegionExpr(List<Clock> clocks, List<Place> places, RegionExit regionExit) {
        this.clocks = clocks;
        this.places = places;
        this.regionExit = regionExit;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void setClocks(List<Clock> clockList) {
        this.clocks = clockList;
    }

    @Override
    public List<Clock> getClocks() {
        return this.clocks;
    }

    @Override
    public boolean addClock(Clock clock) {
        if (this.clocks.contains(clock)) {
            return false;
        }
        this.clocks.add(clock);
        return true;
    }

    @Override
    public void addClocks(List<Clock> clockList) {
        this.clocks.addAll(clockList);
    }

    @Override
    public boolean removeClock(Clock clock) {
        if (!this.clocks.contains(clock)) {
            return false;
        }
        this.clocks.remove(clock);
        return true;
    }

    @Override
    public boolean hasClock(Clock clock) {
        return this.clocks.contains(clock);
    }

    @Override
    public void setPlaces(List<Place> places) {
        this.places = places;
    }

    @Override
    public List<Place> getPlaces() {
        return this.places;
    }

    @Override
    public Place getPlace() {
        if (this.places != null) {
            if (this.places.size() == 1) {
                return this.places.get(0);
            }
            if (this.places.size() != 0) {
                throw new RuntimeException("More than one place for one activity " + this.places.size());
            }
        }
        return null;
    }

    @Override
    public boolean addPlace(Place place) {
        if (place == null || this.places.contains(place)) {
            return false;
        }
        this.places.add(place);
        return true;
    }

    @Override
    public void addPlaces(List<Place> placeList) {
        this.places.addAll(placeList);
    }

    @Override
    public boolean removePlace(Place place) {
        if (!this.places.contains(place)) {
            return false;
        }
        this.places.remove(place);
        return true;
    }

    @Override
    public boolean hasPlace(Place place) {
        return this.places.contains(place);
    }

    @Override
    public List getUseBoxes() {
        ArrayList useBoxesList = new ArrayList();
        Iterator<Clock> clockIter = this.clocks.iterator();
        while (clockIter.hasNext()) {
            useBoxesList.addAll(clockIter.next().getUseBoxes());
        }
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            useBoxesList.addAll(placeIter.next().getUseBoxes());
        }
        return useBoxesList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjAsyncRegionExpr(this.clocks, this.places, this.regionExit);
    }

    @Override
    public String toString() {
        return this.entryType() + "Region Entry";
    }

    @Override
    public String entryType() {
        return "Async";
    }
}

