/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.HjToJimple.jimple.ForLoopRegionExpr;
import soot.HjToJimple.jimple.HjRegionEntry;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.util.Clock;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.LoopDomain;
import soot.HjToJimple.util.Place;
import soot.Local;
import soot.RefType;
import soot.Type;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.internal.StmtBox;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjForLoopRegionExpr
extends HjRegionEntry
implements ForLoopRegionExpr {
    protected List<Local> locals;
    protected List<Clock> clocks;
    protected List<Place> places;
    protected LoopDomain domains;
    protected StmtBox entryStmtBox;
    protected List<Stmt> exitStmts;
    protected List<Stmt> backEdgeStmts;
    protected List<StmtBox> exitStmtBoxes;
    protected List<StmtBox> backEdgeStmtBoxes;
    protected boolean hasBranch;

    public HjForLoopRegionExpr() {
        this.locals = new ArrayList<Local>();
        this.clocks = new ArrayList<Clock>();
        this.places = new ArrayList<Place>();
        this.exitStmts = new ArrayList<Stmt>();
        this.exitStmtBoxes = new ArrayList<StmtBox>();
        this.backEdgeStmts = new ArrayList<Stmt>();
        this.backEdgeStmtBoxes = new ArrayList<StmtBox>();
    }

    public HjForLoopRegionExpr(List<Local> locals, List<Clock> clocks, List<Place> places, LoopDomain domains) {
        this.locals = locals;
        this.clocks = clocks;
        this.places = places;
        this.domains = domains;
        this.exitStmts = new ArrayList<Stmt>();
        this.exitStmtBoxes = new ArrayList<StmtBox>();
        this.backEdgeStmts = new ArrayList<Stmt>();
        this.backEdgeStmtBoxes = new ArrayList<StmtBox>();
    }

    public HjForLoopRegionExpr(Stmt entryStmt, List<Stmt> exitStmts, List<Stmt> backEdgeStmts) {
        this.entryStmtBox = (StmtBox)Jimple.v().newStmtBox(entryStmt);
        this.exitStmts = exitStmts;
        this.exitStmtBoxes = new ArrayList<StmtBox>();
        Iterator<Stmt> exitIter = exitStmts.iterator();
        while (exitIter.hasNext()) {
            this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(exitIter.next()));
        }
        this.backEdgeStmts = backEdgeStmts;
        this.backEdgeStmtBoxes = new ArrayList<StmtBox>();
        Iterator<Stmt> backEdgeIter = backEdgeStmts.iterator();
        while (backEdgeIter.hasNext()) {
            this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(backEdgeIter.next()));
        }
    }

    public HjForLoopRegionExpr(Stmt entryStmt, List<Stmt> exitStmts, List<Stmt> backEdgeStmts, RegionExit regionExit) {
        this(entryStmt, exitStmts, backEdgeStmts);
        this.regionExit = regionExit;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void addLocal(Local local) {
        this.locals.add(local);
    }

    @Override
    public List<Local> getLocals() {
        return this.locals;
    }

    @Override
    public void addLocals(List<Local> localList) {
        this.locals.addAll(localList);
    }

    @Override
    public void setLocals(List<Local> localList) {
        this.locals = localList;
    }

    @Override
    public void setClocks(List<Clock> clockList) {
        this.clocks = clockList;
    }

    @Override
    public List<Clock> getClocks() {
        return this.clocks;
    }

    @Override
    public void setDomains(LoopDomain domains) {
        this.domains = domains;
    }

    @Override
    public LoopDomain getDomains() {
        return this.domains;
    }

    @Override
    public boolean addClock(Clock clock) {
        if (this.clocks.contains(clock)) {
            return false;
        }
        this.clocks.add(clock);
        return true;
    }

    @Override
    public void addClocks(List<Clock> clockList) {
        this.clocks.addAll(clockList);
    }

    @Override
    public boolean removeClock(Clock clock) {
        if (!this.clocks.contains(clock)) {
            return false;
        }
        this.clocks.remove(clock);
        return true;
    }

    @Override
    public boolean hasClock(Clock clock) {
        return this.clocks.contains(clock);
    }

    @Override
    public void setPlaces(List<Place> places) {
        this.places = places;
    }

    @Override
    public List<Place> getPlaces() {
        return this.places;
    }

    @Override
    public boolean addPlace(Place place) {
        if (place == null || this.places.contains(place)) {
            return false;
        }
        this.places.add(place);
        return true;
    }

    @Override
    public void addPlaces(List<Place> placeList) {
        this.places.addAll(placeList);
    }

    @Override
    public boolean removePlace(Place place) {
        if (!this.places.contains(place)) {
            return false;
        }
        this.places.remove(place);
        return true;
    }

    @Override
    public boolean hasPlace(Place place) {
        return this.places.contains(place);
    }

    @Override
    public Stmt getLoopEntry() {
        return (Stmt)this.entryStmtBox.getUnit();
    }

    @Override
    public void setLoopEntry(Stmt entryStmt) {
        if (this.entryStmtBox == null) {
            this.entryStmtBox = (StmtBox)Jimple.v().newStmtBox(entryStmt);
        } else {
            this.entryStmtBox.setUnit(entryStmt);
        }
    }

    @Override
    public List<Stmt> getLoopExits() {
        ArrayList<Stmt> exitList = new ArrayList<Stmt>();
        Iterator<StmtBox> exitBoxIter = this.exitStmtBoxes.iterator();
        while (exitBoxIter.hasNext()) {
            exitList.add((Stmt)exitBoxIter.next().getUnit());
        }
        return exitList;
    }

    @Override
    public void addLoopExit(Stmt exitStmt) {
        this.exitStmts.add(exitStmt);
        this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(exitStmt));
    }

    @Override
    public void setLoopExits(List<Stmt> exitList) {
        this.exitStmts = exitList;
        this.exitStmtBoxes.clear();
        Iterator<Stmt> exitIter = this.exitStmts.iterator();
        while (exitIter.hasNext()) {
            this.exitStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(exitIter.next()));
        }
    }

    @Override
    public List<Stmt> getBackEdges() {
        ArrayList<Stmt> backEdgeList = new ArrayList<Stmt>();
        Iterator<StmtBox> backEdgeBoxIter = this.backEdgeStmtBoxes.iterator();
        while (backEdgeBoxIter.hasNext()) {
            backEdgeList.add((Stmt)backEdgeBoxIter.next().getUnit());
        }
        return backEdgeList;
    }

    @Override
    public void addBackEdge(Stmt backEdgeStmt) {
        this.backEdgeStmts.add(backEdgeStmt);
        this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(backEdgeStmt));
    }

    @Override
    public void setBackEdges(List<Stmt> backEdgeStmts) {
        this.backEdgeStmts = backEdgeStmts;
        this.backEdgeStmtBoxes.clear();
        Iterator<Stmt> backEdgeIter = backEdgeStmts.iterator();
        while (backEdgeIter.hasNext()) {
            this.backEdgeStmtBoxes.add((StmtBox)Jimple.v().newStmtBox(backEdgeIter.next()));
        }
    }

    @Override
    public boolean hasBranch() {
        return this.hasBranch;
    }

    @Override
    public void hasBranch(boolean value) {
        this.hasBranch = value;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<HjValueBox> useBoxesList = new ArrayList<HjValueBox>();
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            useBoxesList.addAll(placeIter.next().getUseBoxes());
        }
        Iterator<Clock> clockIter = this.clocks.iterator();
        while (clockIter.hasNext()) {
            useBoxesList.addAll(clockIter.next().getUseBoxes());
        }
        useBoxesList.addAll(this.domains.getUseBoxes());
        Iterator<Local> localIter = this.locals.iterator();
        while (localIter.hasNext()) {
            useBoxesList.add(new HjValueBox(localIter.next()));
        }
        return useBoxesList;
    }

    @Override
    public Type getType() {
        return RefType.v();
    }

    @Override
    public Object clone() {
        return new HjForLoopRegionExpr((Stmt)this.entryStmtBox.getUnit(), this.exitStmts, this.backEdgeStmts, this.regionExit);
    }

    @Override
    public String toString() {
        String str = this.entryType() + "Region Entry Locals: ";
        Iterator<Local> localIter = this.locals.iterator();
        while (localIter.hasNext()) {
            str = str + localIter.next() + " ";
        }
        str = str + "\n Region Loop Domains: " + this.domains;
        str = str + "\n Region Places: ";
        Iterator<Place> placeIter = this.places.iterator();
        while (placeIter.hasNext()) {
            str = str + placeIter.next() + " ";
        }
        str = str + "\n Region Clocks: ";
        Iterator<Clock> clockIter = this.clocks.iterator();
        while (clockIter.hasNext()) {
            str = str + clockIter.next() + " ";
        }
        return str;
    }

    @Override
    public String entryType() {
        return "ForLoop";
    }
}

