/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.jimple.AccessMethods;
import soot.HjToJimple.jimple.ActivityClassBuilder;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.AtomicRegionExpr;
import soot.HjToJimple.jimple.FinishRegionExpr;
import soot.HjToJimple.jimple.IsolatedRegionExpr;
import soot.HjToJimple.jimple.LoopRegionExpr;
import soot.HjToJimple.jimple.Region;
import soot.HjToJimple.jimple.Region1TStmt;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.jimple.TargetedHjRuntime;
import soot.HjToJimple.jimple.factory.HjClassFactory;
import soot.HjToJimple.jimple.factory.HjStmtFactory;
import soot.HjToJimple.util.HjObject;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.options.Options;
import soot.tagkit.EnclosingTag;
import soot.tagkit.SyntheticTag;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjRuntimeTranslator
extends BodyTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected Body origBody;
    protected Local origThisLocal;
    protected int innerClassCounter = 0;
    public static final String JAVALANGOBJECT_CLASSNAME = "java.lang.Object";
    public static final String JAVALANGNOTIFYALL_METHODNAME = "notifyAll";

    public HjRuntimeTranslator(Singletons.Global g) {
    }

    public static HjRuntimeTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjRuntimeTranslator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.extraClasses.clear();
        if (Options.v().hjVerbose()) {
            G.v().out.println("MPIR: " + body);
        }
        if (method.isStatic() && method.isPublic() && method.getName().startsWith("main") && method.getName().length() == 4) {
            if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                this.createHabMainClass(body);
            } else {
                this.createMainClass(body);
            }
        }
        this.origBody = body;
        if (!body.getMethod().isStatic()) {
            this.origThisLocal = body.getThisLocal();
        }
        this.hjRuntimeTransform(body, phaseName, opts, null);
        this.nopElimination(this.extraClasses.iterator());
        Scene.v().extraClasses.addAll(this.extraClasses);
    }

    protected void nopElimination(Iterator<SootClass> classIter) {
        ArrayList<Stmt> nopsList = new ArrayList<Stmt>();
        while (classIter.hasNext()) {
            Iterator<SootMethod> methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                Body methodBody = methodIter.next().retrieveActiveBody();
                StmtBody stmtBody = (StmtBody)methodBody;
                PatchingChain<Unit> units = stmtBody.getUnits();
                HashMap rtStmtMap = new HashMap();
                ArrayList removeStmts = new ArrayList();
                ArrayList rtTraps = new ArrayList();
                for (Stmt stmt : units) {
                    if (!(stmt instanceof NopStmt)) continue;
                    nopsList.add(stmt);
                }
                Iterator iterator = nopsList.iterator();
                while (iterator.hasNext()) {
                    methodBody.getUnits().remove(iterator.next());
                }
                nopsList.clear();
            }
        }
    }

    protected void checkAll(Iterator<SootClass> classIter) {
        ArrayList nopsList = new ArrayList();
        while (classIter.hasNext()) {
            Iterator<SootMethod> methodIter = classIter.next().methodIterator();
            while (methodIter.hasNext()) {
                if (!Options.v().hjVerbose()) continue;
                G.v().out.println("Method Body: " + methodIter.next().retrieveActiveBody());
            }
        }
    }

    protected void createMainClass(Body body) {
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        SootClass mainClass = new SootClass(bodyClass.getName() + "$" + "Main", 9);
        mainClass.setOuterClass(bodyClass);
        mainClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wsh.Activity"));
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        Iterator typeIter = body.getMethod().getParameterTypes().iterator();
        Type formFieldType = (Type)typeIter.next();
        SootField formField = new SootField("form", formFieldType, 18);
        formField.addTag(new SyntheticTag());
        mainClass.addField(formField);
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = new SootMethod("runHjTask", new ArrayList(), VoidType.v(), 1);
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody(methodBody);
        taskMethod.setDeclaringClass(mainClass);
        mainClass.addMethod(taskMethod);
        Local thisLocal = Jimple.v().newLocal("tl", mainClass.getType());
        methodBody.getLocals().add(thisLocal);
        methodBody.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(mainClass.getType())));
        Local formLocal = Jimple.v().newLocal("form", formField.getType());
        methodBody.getLocals().add(formLocal);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, formField.makeRef());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(formLocal, fieldRef);
        methodBody.getUnits().add(assignStmt);
        ArrayList<Local> mainParams = new ArrayList<Local>();
        mainParams.add(formLocal);
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(body.getMethod().makeRef(), mainParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(staticInvoke);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        this.createStatusMethod(mainClass);
        classParams.put(formLocal, formField);
        this.createInitMethod(mainClass, classParams);
        this.extraClasses.add(mainClass);
    }

    protected void createHabMainClass(Body body) {
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        SootClass mainClass = new SootClass(bodyClass.getName() + "$" + "Main", 1);
        mainClass.setOuterClass(bodyClass);
        mainClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wsh.Activity"));
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        Iterator typeIter = body.getMethod().getParameterTypes().iterator();
        Type formFieldType = (Type)typeIter.next();
        SootField formField = new SootField("form", formFieldType, 18);
        formField.addTag(new SyntheticTag());
        mainClass.addField(formField);
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = new SootMethod("runHjTask", new ArrayList(), VoidType.v(), 1);
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody(methodBody);
        taskMethod.setDeclaringClass(mainClass);
        mainClass.addMethod(taskMethod);
        Local thisLocal = Jimple.v().newLocal("tl", mainClass.getType());
        methodBody.getLocals().add(thisLocal);
        methodBody.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(mainClass.getType())));
        Local formLocal = Jimple.v().newLocal("form", formField.getType());
        methodBody.getLocals().add(formLocal);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, formField.makeRef());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(formLocal, fieldRef);
        methodBody.getUnits().add(assignStmt);
        ArrayList<Local> mainParams = new ArrayList<Local>();
        mainParams.add(formLocal);
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(body.getMethod().makeRef(), mainParams);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(staticInvoke);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        this.createStatusMethod(mainClass);
        classParams.put(formLocal, formField);
        this.createInitMethod(mainClass, classParams);
        this.extraClasses.add(mainClass);
    }

    protected void hjRuntimeTransform(Body body, String phaseName, Map opts, ArrayList outerBranchItems) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain<Unit> units = stmtBody.getUnits();
        HashMap<Stmt, ArrayList<Stmt>> rtStmtMap = new HashMap<Stmt, ArrayList<Stmt>>();
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        ArrayList<Trap> rtTraps = new ArrayList<Trap>();
        ArrayList branchItems = outerBranchItems != null ? outerBranchItems : new ArrayList();
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!(stmt instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                    this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof AtomicRegionExpr) {
                this.handleAtomicRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems, false);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        }
        for (Stmt stmt : rtStmtMap.keySet()) {
            ArrayList rtStmts = (ArrayList)rtStmtMap.get(stmt);
            for (Stmt rtStmt : rtStmts) {
                body.getUnits().insertBefore(rtStmt, (Unit)stmt);
            }
        }
        Iterator trapIter = rtTraps.iterator();
        while (trapIter.hasNext()) {
            body.getTraps().add((Trap)trapIter.next());
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().remove(stmtIter.next());
        }
        if (outerBranchItems == null) {
            Iterator branchItemIter = branchItems.iterator();
            while (branchItemIter.hasNext()) {
                Object branchItem = branchItemIter.next();
                if (!(branchItem instanceof Trap)) continue;
                Trap trap = (Trap)branchItem;
                trap.setBeginUnit((Unit)branchItemIter.next());
                trap.setEndUnit((Unit)branchItemIter.next());
                trap.setHandlerUnit((Unit)branchItemIter.next());
            }
        }
    }

    protected void checkUses(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] uses = s.getUseBoxes().toArray();
        for (int i = 0; i < uses.length; ++i) {
            Value v = ((ValueBox)uses[i]).getValue();
            if (methodLocals.contains(v) || !outerMethodLocals.contains(v)) continue;
            methodLocals.add((Local)v);
            classParams.put((Local)v, this.createField((Local)v));
        }
    }

    protected void checkDefs(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] defs = s.getDefBoxes().toArray();
        for (int i = 0; i < defs.length; ++i) {
            Value v = ((ValueBox)defs[i]).getValue();
            if (methodLocals.contains(v) || !outerMethodLocals.contains(v)) continue;
            methodLocals.add((Local)v);
            outerMethodLocals.remove(v);
        }
    }

    protected void handleAsyncRegion(RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        Body taskMethodBody;
        if (Options.v().hjVerbose()) {
            G.v().out.println("HjToJimple handle async region");
        }
        AsyncRegionExpr asyncRegion = (AsyncRegionExpr)asyncRegionStmt.getRegionExpr();
        ArrayList<Stmt> runtimeStmts = new ArrayList<Stmt>();
        SootClass bodyClass = body.getMethod().getDeclaringClass();
        SootClass activityClass = new SootClass(bodyClass.getName() + "$" + this.innerClassCounter++);
        activityClass.setOuterClass(bodyClass);
        activityClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wsh.Activity"));
        HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
        if (asyncRegionStmt instanceof Region1TStmt) {
            RegionStmt statusLabel = ((Region1TStmt)asyncRegionStmt).getLabel();
            ActivityClassBuilder.v().createStatusMethod(activityClass, asyncRegionStmt, statusLabel, body, stmtIt, classParams, removeStmts, this.origThisLocal);
            taskMethodBody = this.createTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
        } else {
            taskMethodBody = this.createTaskMethod(activityClass, asyncRegionStmt, body, stmtIt, classParams, removeStmts, branchItems);
            this.createStatusMethod(activityClass);
        }
        Local outerThisLocal = body.getMethod().isStatic() ? null : body.getThisLocal();
        ArrayList linkedClassParams = new ArrayList();
        SootClass linkedListClass = ActivityClassBuilder.v().handleClocks(asyncRegion.getClocks(), body, runtimeStmts, outerThisLocal, linkedClassParams, this.innerClassCounter++);
        if (linkedListClass != null) {
            this.extraClasses.add(linkedListClass);
        }
        ActivityClassBuilder.v().createInitMethod(activityClass, classParams, linkedListClass);
        this.extraClasses.add(activityClass);
        ActivityClassBuilder.v().createRuntimeStmts(activityClass, linkedListClass, linkedClassParams, body, classParams, asyncRegion.getPlace(), runtimeStmts);
        rtStmtMap.put(asyncRegionStmt, runtimeStmts);
        removeStmts.add(asyncRegionStmt);
        this.hjRuntimeTransform(taskMethodBody, null, null, branchItems);
    }

    protected void checkTraps(Body body, Body methodBody, Chain<Trap> traps, Stmt regionEntryStmt, Stmt regionExitStmt, HashMap<Stmt, Stmt> branchMap, ArrayList branchItems) {
        for (Trap trap : traps) {
            Stmt beginStmt = (Stmt)trap.getBeginUnit();
            if (body.getUnits().contains(beginStmt) && (!body.getUnits().follows(beginStmt, regionEntryStmt) || !body.getUnits().follows(regionExitStmt, beginStmt))) continue;
            methodBody.getTraps().add(trap);
            branchItems.add(trap);
            Unit unit = trap.getBeginUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            unit = trap.getEndUnit();
            if (branchMap.containsKey((Stmt)unit)) {
                unit = branchMap.get((Stmt)unit);
            }
            branchItems.add(unit);
            branchItems.add(trap.getHandlerUnit());
        }
        Iterator<Trap> trapIter = methodBody.getTraps().iterator();
        while (trapIter.hasNext()) {
            body.getTraps().remove(trapIter.next());
        }
    }

    protected Body createTaskMethod(SootClass activityClass, RegionStmt asyncRegionStmt, Body body, Iterator stmtIt, HashMap<Local, SootField> classParams, ArrayList<Stmt> removeStmts, ArrayList branchItems) {
        SootField field;
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod taskMethod = new SootMethod("runHjTask", new ArrayList(), VoidType.v(), 1);
        methodBody.setMethod(taskMethod);
        taskMethod.setActiveBody(methodBody);
        taskMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(taskMethod);
        Local thisLocal = Jimple.v().newLocal("tl", activityClass.getType());
        methodBody.getLocals().add(thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        Local newThisLocal = null;
        if (this.origThisLocal != null) {
            newThisLocal = Jimple.v().newLocal("tl", activityClass.getType());
            methodBody.getLocals().add(newThisLocal);
        }
        RegionExit regionExitExpr = ((AsyncRegionExpr)asyncRegionStmt.getRegionExpr()).getExit();
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        Stmt exitStmt = null;
        HashMap<Stmt, Stmt> branchMap = new HashMap<Stmt, Stmt>();
        while (stmtIt.hasNext()) {
            NopStmt nopLabel;
            Stmt target;
            ArrayList<Unit> targetList;
            Iterator targetIter;
            NopStmt nopLabel2;
            Stmt target2;
            Stmt stmt = (Stmt)stmtIt.next();
            Stmt newStmt = null;
            if (branchMap.containsKey(stmt)) {
                methodBody.getUnits().add((Unit)branchMap.get(stmt));
            }
            if (stmt instanceof RegionStmt) {
                if (((RegionStmt)stmt).getRegionExpr() == regionExitExpr) {
                    exitStmt = stmt;
                    removeStmts.add(stmt);
                    break;
                }
                NopStmt nopLabel3 = Jimple.v().newNopStmt();
                methodBody.getUnits().add(nopLabel3);
                branchMap.put(stmt, nopLabel3);
            } else if (stmt instanceof GotoStmt) {
                target2 = (Stmt)((GotoStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((GotoStmt)stmt).setTargetBox((Unit)branchMap.get(target2));
                } else if (methodBody.getUnits().contains(target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget(nopLabel2);
                    methodBody.getUnits().insertBefore(nopLabel2, (Unit)target2);
                    branchMap.put(target2, nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((GotoStmt)stmt).setTarget(nopLabel2);
                    branchMap.put(target2, nopLabel2);
                }
            } else if (stmt instanceof IfStmt) {
                target2 = ((IfStmt)stmt).getTarget();
                if (branchMap.containsKey(target2)) {
                    ((IfStmt)stmt).setTarget((Unit)branchMap.get(target2));
                } else if (methodBody.getUnits().contains(target2)) {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget(nopLabel2);
                    methodBody.getUnits().insertBefore(nopLabel2, (Unit)target2);
                    branchMap.put(target2, nopLabel2);
                } else {
                    nopLabel2 = Jimple.v().newNopStmt();
                    ((IfStmt)stmt).setTarget(nopLabel2);
                    branchMap.put(target2, nopLabel2);
                }
            } else if (stmt instanceof TableSwitchStmt) {
                targetIter = ((TableSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList<Unit>();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains(target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                        branchMap.put(target, nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, nopLabel);
                }
                ((TableSwitchStmt)stmt).setTargets(targetList);
                target = (Stmt)((TableSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((TableSwitchStmt)stmt).setDefaultTarget(branchMap.get(target));
                } else if (methodBody.getUnits().contains(target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                    branchMap.put(target, nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((TableSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    branchMap.put(target, nopLabel);
                }
            } else if (stmt instanceof LookupSwitchStmt) {
                targetIter = ((LookupSwitchStmt)stmt).getTargets().iterator();
                targetList = new ArrayList();
                while (targetIter.hasNext()) {
                    target = (Stmt)targetIter.next();
                    if (branchMap.containsKey(target)) {
                        targetList.add(branchMap.get(target));
                        continue;
                    }
                    if (methodBody.getUnits().contains(target)) {
                        nopLabel = Jimple.v().newNopStmt();
                        targetList.add(nopLabel);
                        methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                        branchMap.put(target, nopLabel);
                        continue;
                    }
                    nopLabel = Jimple.v().newNopStmt();
                    targetList.add(nopLabel);
                    branchMap.put(target, nopLabel);
                }
                ((LookupSwitchStmt)stmt).setTargets((Unit[])targetList.toArray());
                target = (Stmt)((LookupSwitchStmt)stmt).getDefaultTarget();
                if (branchMap.containsKey(target)) {
                    ((LookupSwitchStmt)stmt).setDefaultTarget(branchMap.get(target));
                } else if (methodBody.getUnits().contains(target)) {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    methodBody.getUnits().insertBefore(nopLabel, (Unit)target);
                    branchMap.put(target, nopLabel);
                } else {
                    nopLabel = Jimple.v().newNopStmt();
                    ((LookupSwitchStmt)stmt).setDefaultTarget(nopLabel);
                    branchMap.put(target, nopLabel);
                }
            } else if (stmt instanceof InvokeStmt) {
                newStmt = AccessMethods.v().checkInvoke(this.origBody, (InvokeStmt)stmt, this.origThisLocal, newThisLocal);
            } else if (stmt instanceof AssignStmt) {
                newStmt = AccessMethods.v().checkAssign(this.origBody, (AssignStmt)stmt, this.origThisLocal, newThisLocal);
            }
            if (newStmt != null) {
                stmt.redirectJumpsToThisTo(newStmt);
                methodBody.getUnits().add(newStmt);
            } else {
                methodBody.getUnits().add(stmt);
            }
            this.checkUses(stmt, outerMethodLocals, methodLocals, classParams);
            this.checkDefs(stmt, outerMethodLocals, methodLocals, classParams);
            removeStmts.add(stmt);
        }
        this.createFields(activityClass, classParams);
        for (Local local : classParams.keySet()) {
            field = classParams.get(local);
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(local, fieldRef);
            methodBody.getUnits().addFirst(assignStmt);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        methodBody.getUnits().addLast(Jimple.v().newReturnVoidStmt());
        this.checkTraps(body, methodBody, body.getTraps(), asyncRegionStmt, exitStmt, branchMap, branchItems);
        SootMethod bodyMethod = body.getMethod();
        if (!bodyMethod.isStatic() && !classParams.containsKey(outerThisLocal)) {
            field = this.createField(outerThisLocal);
            classParams.put(outerThisLocal, field);
            activityClass.addField(field);
        }
        return methodBody;
    }

    protected ArrayList<Stmt> createRuntimeStmts(SootClass activityClass, Body body, HashMap<Local, SootField> classParams, ArrayList<Stmt> runtimeStmts) {
        HabLocalGenerator lg = new HabLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjRTPlaceClass = Scene.v().getSootClass("hj.runtime.wsh.Place");
        SootClass hjLPlaceClass = Scene.v().getSootClass("hj.lang.place");
        SootMethod hereMethod = hjRTClass.getMethod("here", new ArrayList(), hjRTPlaceClass.getType());
        ArrayList<RefType> asPlaceTypeList = new ArrayList<RefType>();
        asPlaceTypeList.add(hjLPlaceClass.getType());
        SootMethod asPlaceMethod = hjRTClass.getMethod("asPlace", asPlaceTypeList, hjLPlaceClass.getType());
        Local hjRTPlaceLocal = lg.generateLocal(hjRTPlaceClass.getType());
        Local hjLPlaceLocal = lg.generateLocal(hjLPlaceClass.getType());
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), new ArrayList());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(hjRTPlaceLocal, staticInvoke);
        runtimeStmts.add(assignStmt);
        ArrayList<Local> asPlaceParamList = new ArrayList<Local>();
        asPlaceParamList.add(hjRTPlaceLocal);
        staticInvoke = Jimple.v().newStaticInvokeExpr(asPlaceMethod.makeRef(), asPlaceParamList);
        assignStmt = Jimple.v().newAssignStmt(hjLPlaceLocal, staticInvoke);
        runtimeStmts.add(assignStmt);
        Local activityLocal = lg.generateLocal(activityClass.getType());
        NewExpr newExpr = Jimple.v().newNewExpr(activityClass.getType());
        assignStmt = Jimple.v().newAssignStmt(activityLocal, newExpr);
        runtimeStmts.add(assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        SootMethodRef initInvoke = Scene.v().makeMethodRef(activityClass, "<init>", activityTypeList, VoidType.v(), false);
        SpecialInvokeExpr specInvokeExpr = Jimple.v().newSpecialInvokeExpr(activityLocal, initInvoke, activityParamList);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(specInvokeExpr);
        runtimeStmts.add(invokeStmt);
        ArrayList<RefType> runAsyncTypeList = new ArrayList<RefType>();
        ArrayList<Local> runAsyncParamList = new ArrayList<Local>();
        runAsyncTypeList.add(Scene.v().getSootClass("hj.runtime.wsh.Activity").getType());
        runAsyncParamList.add(activityLocal);
        SootMethod runAsyncMethod = hjLPlaceClass.getMethod("runAsync", runAsyncTypeList, VoidType.v());
        VirtualInvokeExpr runAsyncInvoke = Jimple.v().newVirtualInvokeExpr(hjLPlaceLocal, runAsyncMethod.makeRef(), runAsyncParamList);
        invokeStmt = Jimple.v().newInvokeStmt(runAsyncInvoke);
        runtimeStmts.add(invokeStmt);
        return runtimeStmts;
    }

    protected void createFieldInit(SootClass activityClass, JimpleBody methodBody, SootField field, HabLocalGenerator lg, Local thisLocal, int paramCounter) {
        ParameterRef paramRef = Jimple.v().newParameterRef(field.getType(), paramCounter);
        Local tmpLocal = lg.generateLocal(field.getType());
        DefinitionStmt assignStmt = Jimple.v().newIdentityStmt(tmpLocal, paramRef);
        assignStmt.addTag(new EnclosingTag());
        methodBody.getUnits().addFirst(assignStmt);
        InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
        assignStmt = Jimple.v().newAssignStmt(fieldRef, tmpLocal);
        methodBody.getUnits().addLast(assignStmt);
    }

    protected void createInitMethod(SootClass activityClass, HashMap<Local, SootField> classParams) {
        JimpleBody methodBody = Jimple.v().newBody();
        HabLocalGenerator lg = new HabLocalGenerator(methodBody);
        Local thisLocal = lg.generateLocal(activityClass.getType());
        ArrayList<Type> typeList = new ArrayList<Type>();
        Iterator<Local> params = classParams.keySet().iterator();
        int paramCounter = 0;
        while (params.hasNext()) {
            Local local = params.next();
            Type paramType = local.getType();
            typeList.add(paramType);
            this.createFieldInit(activityClass, methodBody, classParams.get(local), lg, thisLocal, paramCounter++);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        SootMethod initMethod = new SootMethod("<init>", typeList, VoidType.v(), 1);
        methodBody.setMethod(initMethod);
        initMethod.setActiveBody(methodBody);
        initMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(initMethod);
        SootMethodRef initInvoke = Scene.v().makeMethodRef(Scene.v().getSootClass("hj.runtime.wsh.Activity"), "<init>", new ArrayList<Type>(), VoidType.v(), false);
        SpecialInvokeExpr invokeExpr = Jimple.v().newSpecialInvokeExpr(thisLocal, initInvoke, new ArrayList());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(invokeExpr);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    protected SootField createField(Local l) {
        SootField field = new SootField("val$" + l.getName(), l.getType(), 18);
        field.addTag(new SyntheticTag());
        return field;
    }

    protected void createFields_(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Iterator<SootField> fields = classParams.values().iterator();
        while (fields.hasNext()) {
            activityClass.addField(fields.next());
        }
    }

    protected void createFields(SootClass activityClass, HashMap<Local, SootField> classParams) {
        Object[] locals = classParams.keySet().toArray();
        for (int i = 0; i < locals.length; ++i) {
            SootField field = classParams.get((Local)locals[i]);
            try {
                SootField oldField = activityClass.getField(field.getName(), field.getType());
                classParams.put((Local)locals[i], oldField);
                continue;
            }
            catch (Exception e) {
                activityClass.addField(field);
            }
        }
    }

    protected void createStatusMethod(SootClass activityClass) {
        JimpleBody statusMethodBody = Jimple.v().newBody();
        SootMethod statusMethod = new SootMethod("isHjTaskReady", new ArrayList(), BooleanType.v(), 1);
        statusMethodBody.setMethod(statusMethod);
        statusMethod.setActiveBody(statusMethodBody);
        statusMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(statusMethod);
        statusMethodBody.getUnits().add(Jimple.v().newReturnStmt(IntConstant.v(1)));
    }

    protected void handleFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succRTStmts = new ArrayList<Stmt>();
        HabLocalGenerator lg = new HabLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjActivityClass = Scene.v().getSootClass("hj.runtime.wsh.Activity");
        SootClass hjLangActivityClass = Scene.v().getSootClass("hj.lang.activity");
        SootMethod startFinishMethod = hjActivityClass.getMethod("startFinish", new ArrayList(), VoidType.v());
        SootMethod stopFinishMethod = hjActivityClass.getMethod("stopFinish", new ArrayList(), VoidType.v());
        ArrayList<RefType> pushExceptionTypeList = new ArrayList<RefType>();
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        pushExceptionTypeList.add(throwableClass.getType());
        SootMethod pushExceptionMethod = hjActivityClass.getMethod("pushException", pushExceptionTypeList, VoidType.v());
        Object nopLabel0 = null;
        Object nopLabel1 = null;
        Object nopLabel2 = null;
        Object nopLabel3 = null;
        Object nopLabel4 = null;
        Object nopLabel5 = null;
        Object nopLabel6 = null;
        Object nopLabel7 = null;
        Object nopLabel8 = null;
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof AtomicRegionExpr) {
                this.handleAtomicRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems, false);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        ActivityClassBuilder.v().createFinishRTStmts(prevRTStmts, succRTStmts, rtTraps, lg);
        rtStmtMap.put(finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add(finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleHabFinishRegion(RegionStmt finishRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        FinishRegionExpr finishRegion = (FinishRegionExpr)finishRegionStmt.getRegionExpr();
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succRTStmts = new ArrayList<Stmt>();
        HabLocalGenerator lg = new HabLocalGenerator(body);
        SootClass hjActivityClass = Scene.v().getSootClass("hj.runtime.wsh.Activity");
        SootMethod startFinishMethod = hjActivityClass.getMethod("startFinish", new ArrayList(), VoidType.v());
        SootMethod stopFinishMethod = hjActivityClass.getMethod("stopFinish", new ArrayList(), VoidType.v());
        ArrayList<RefType> pushExceptionTypeList = new ArrayList<RefType>();
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        pushExceptionTypeList.add(throwableClass.getType());
        SootMethod pushExceptionMethod = hjActivityClass.getMethod("pushException", pushExceptionTypeList, VoidType.v());
        RegionExit regionExitExpr = finishRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof AsyncRegionExpr) {
                this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                continue;
            }
            if (regionExpr instanceof FinishRegionExpr) {
                this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (regionExpr instanceof AtomicRegionExpr) {
                this.handleAtomicRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems, false);
                continue;
            }
            if (regionExpr instanceof IsolatedRegionExpr) {
                this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            this.handleLoopRegion((RegionStmt)stmt, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        Local langActivityLocal = lg.generateLocal(HjClassFactory.hjLangActivity().getType());
        Local activityLocal = lg.generateLocal(hjActivityClass.getType());
        Stmt langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        prevRTStmts.add(langAssignStmt);
        Stmt assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        prevRTStmts.add(assignStmt);
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, startFinishMethod.makeRef(), new ArrayList());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        prevRTStmts.add(invokeStmt);
        langActivityLocal = lg.generateLocal(HjClassFactory.hjLangActivity().getType());
        activityLocal = lg.generateLocal(hjActivityClass.getType());
        langAssignStmt = HjStmtFactory.getCurrentActivity_HjLangActivity(langActivityLocal);
        succRTStmts.add(langAssignStmt);
        assignStmt = HjStmtFactory.assignLangActivityToActivityWsh(activityLocal, langActivityLocal);
        succRTStmts.add(assignStmt);
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(activityLocal, stopFinishMethod.makeRef(), new ArrayList());
        invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        succRTStmts.add(invokeStmt);
        rtStmtMap.put(finishRegionStmt, prevRTStmts);
        rtStmtMap.put(regionExitStmt, succRTStmts);
        removeStmts.add(finishRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected ArrayList<Stmt> createRetStmts(Stmt startStmt, Stmt returnStmt, Local placeLocal, Stmt handler0Stmt, Stmt handler1Stmt, HabLocalGenerator lg, SootClass hjRTPlaceClass, SootClass throwableClass, SootMethod hereMethod, SootMethod notifyAllMethod, ArrayList<Trap> rtTraps) {
        ArrayList<Stmt> retStmts = new ArrayList<Stmt>();
        NopStmt startNopLabel = Jimple.v().newNopStmt();
        retStmts.add(startNopLabel);
        Local notifyPlcLocal = lg.generateLocal(hjRTPlaceClass.getType());
        StaticInvokeExpr staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), new ArrayList());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(notifyPlcLocal, staticInvoke);
        retStmts.add(assignStmt);
        AssignStmt retNopLabel1 = assignStmt;
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(notifyPlcLocal, notifyAllMethod.makeRef(), new ArrayList());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        retStmts.add(invokeStmt);
        ExitMonitorStmt exitMonStmt = Jimple.v().newExitMonitorStmt(placeLocal);
        retStmts.add(exitMonStmt);
        NopStmt retNopLabel2 = Jimple.v().newNopStmt();
        retStmts.add(retNopLabel2);
        if (returnStmt != null) {
            retStmts.add(Jimple.v().newGotoStmt(returnStmt));
        }
        rtTraps.add(Jimple.v().newTrap(throwableClass, startNopLabel, retNopLabel1, handler0Stmt));
        rtTraps.add(Jimple.v().newTrap(throwableClass, startNopLabel, retNopLabel2, handler1Stmt));
        return retStmts;
    }

    protected void handleAtomicRegion(RegionStmt atomicRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems, boolean isIsolated) {
        ArrayList<Object> succRTStmts;
        StaticInvokeExpr staticInvoke;
        if (isIsolated) {
            throw new RuntimeException("The isolation does not using place[0] lock!!");
        }
        HabLocalGenerator lg = new HabLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass javaObjClass = Scene.v().getSootClass(JAVALANGOBJECT_CLASSNAME);
        SootClass hjRTPlaceClass = Scene.v().getSootClass("hj.runtime.wsh.Place");
        SootMethod hereMethod = hjRTClass.getMethod("here", new ArrayList(), hjRTPlaceClass.getType());
        SootMethod notifyAllMethod = javaObjClass.getMethod(JAVALANGNOTIFYALL_METHODNAME, new ArrayList(), VoidType.v());
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        ArrayList<Stmt> prevRTStmts = new ArrayList<Stmt>();
        Local placeLocal = lg.generateLocal(hjRTPlaceClass.getType());
        if (isIsolated) {
            SootMethod place0Method = hjRTClass.getMethod("place0", new ArrayList(), hjRTPlaceClass.getType());
            staticInvoke = Jimple.v().newStaticInvokeExpr(place0Method.makeRef(), new ArrayList());
        } else {
            staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), new ArrayList());
        }
        AssignStmt assignStmt = Jimple.v().newAssignStmt(placeLocal, staticInvoke);
        prevRTStmts.add(assignStmt);
        EnterMonitorStmt enterMonStmt = Jimple.v().newEnterMonitorStmt(placeLocal);
        prevRTStmts.add(enterMonStmt);
        rtStmtMap.put(atomicRegionStmt, prevRTStmts);
        CaughtExceptionRef exceptRef = Jimple.v().newCaughtExceptionRef();
        Local except0Local = lg.generateLocal(throwableClass.getType());
        IdentityStmt handler0Stmt = Jimple.v().newIdentityStmt(except0Local, exceptRef);
        exceptRef = Jimple.v().newCaughtExceptionRef();
        Local except1Local = lg.generateLocal(throwableClass.getType());
        IdentityStmt handler1Stmt = Jimple.v().newIdentityStmt(except1Local, exceptRef);
        Stmt regionExitStmt = atomicRegionStmt.getConnect();
        Stmt startStmt = null;
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (startStmt == null) {
                startStmt = stmt;
            }
            if (stmt == regionExitStmt) break;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                        this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                        continue;
                    }
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof AtomicRegionExpr) {
                    this.handleAtomicRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems, false);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
            if (Options.v().hjVerbose()) {
                G.v().out.println("ADD TRAP BEGIN: " + startStmt);
            }
            ArrayList<Stmt> retStmts = this.createRetStmts(startStmt, null, placeLocal, handler0Stmt, handler1Stmt, lg, hjRTPlaceClass, throwableClass, hereMethod, notifyAllMethod, rtTraps);
            rtStmtMap.put(stmt, retStmts);
            startStmt = null;
        }
        NopStmt exitLabel = Jimple.v().newNopStmt();
        if (startStmt != regionExitStmt) {
            succRTStmts = this.createRetStmts(startStmt, exitLabel, placeLocal, handler0Stmt, handler1Stmt, lg, hjRTPlaceClass, throwableClass, hereMethod, notifyAllMethod, rtTraps);
            if (Options.v().hjVerbose()) {
                G.v().out.println("ADD TRAP BEGIN: " + startStmt);
            }
        } else {
            succRTStmts = new ArrayList<IdentityStmt>();
        }
        rtStmtMap.put(regionExitStmt, succRTStmts);
        succRTStmts.add(handler0Stmt);
        Local throwLocal = lg.generateLocal(throwableClass.getType());
        assignStmt = Jimple.v().newAssignStmt(throwLocal, except0Local);
        succRTStmts.add(assignStmt);
        AssignStmt handlerLabel0 = assignStmt;
        staticInvoke = Jimple.v().newStaticInvokeExpr(hereMethod.makeRef(), new ArrayList());
        assignStmt = Jimple.v().newAssignStmt(placeLocal, staticInvoke);
        succRTStmts.add(assignStmt);
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(placeLocal, notifyAllMethod.makeRef(), new ArrayList());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(virtualInvoke);
        succRTStmts.add(invokeStmt);
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(throwLocal);
        succRTStmts.add(throwStmt);
        AssignStmt handlerLabel1 = assignStmt;
        succRTStmts.add(handler1Stmt);
        throwLocal = lg.generateLocal(throwableClass.getType());
        assignStmt = Jimple.v().newAssignStmt(throwLocal, except1Local);
        succRTStmts.add(assignStmt);
        succRTStmts.add(Jimple.v().newExitMonitorStmt(placeLocal));
        AssignStmt handlerLabel2 = assignStmt;
        throwStmt = Jimple.v().newThrowStmt(throwLocal);
        succRTStmts.add(throwStmt);
        ThrowStmt handlerLabel3 = throwStmt;
        succRTStmts.add(exitLabel);
        Trap trap = Jimple.v().newTrap(throwableClass, handlerLabel0, handlerLabel1, handler0Stmt);
        rtTraps.add(trap);
        trap = Jimple.v().newTrap(throwableClass, handlerLabel0, handlerLabel3, handler1Stmt);
        rtTraps.add(trap);
        removeStmts.add(atomicRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleIsolatedRegion(RegionStmt isolatedRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts, ArrayList<Trap> rtTraps, ArrayList branchItems) {
        AssignStmt assignStmt;
        SootMethod startIsolationMethod;
        ArrayList<Value> paramList;
        ArrayList<RefType> typeList;
        HabLocalGenerator lg = new HabLocalGenerator(body);
        SootClass hjRTClass = Scene.v().getSootClass("hj.lang.Runtime");
        SootClass hjObjectClass = Scene.v().getSootClass("hj.lang.Object");
        SootClass hjRTPlaceClass = Scene.v().getSootClass("hj.runtime.wsh.Place");
        SootClass throwableClass = Scene.v().getSootClass("java.lang.Throwable");
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        IsolatedRegionExpr isolatedRegionExpr = (IsolatedRegionExpr)isolatedRegionStmt.getRegionExpr();
        List objectList = isolatedRegionExpr.getObjects();
        ArrayType intArrayType = ArrayType.v(IntType.v(), 1);
        Local placeID = null;
        Local placeIDs = null;
        if (objectList == null || objectList.size() == 0) {
            SootMethod startIsolationMethod2 = hjRTClass.getMethod("startIsolation", new ArrayList(), VoidType.v());
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(startIsolationMethod2.makeRef(), new ArrayList()));
            predStmts.add(invokeStmt);
        } else if (objectList.size() == 1) {
            typeList = new ArrayList<RefType>();
            paramList = new ArrayList<Value>();
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, IntType.v());
            placeID = lg.generateLocal(IntType.v());
            assignStmt = Jimple.v().newAssignStmt(placeID, Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else if (objectList.size() == 2) {
            typeList = new ArrayList();
            paramList = new ArrayList();
            typeList.add(hjObjectClass.getType());
            typeList.add(hjObjectClass.getType());
            paramList.add(((HjObject)objectList.get(0)).getLocalValue());
            paramList.add(((HjObject)objectList.get(1)).getLocalValue());
            startIsolationMethod = hjRTClass.getMethod("startIsolation", typeList, intArrayType);
            placeIDs = lg.generateLocal(intArrayType);
            assignStmt = Jimple.v().newAssignStmt(placeIDs, Jimple.v().newStaticInvokeExpr(startIsolationMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        } else {
            ArrayType hjObjsType = ArrayType.v(hjObjectClass.getType(), 1);
            Local objsLocal = lg.generateLocal(hjObjsType);
            AssignStmt assignStmt2 = Jimple.v().newAssignStmt(objsLocal, Jimple.v().newNewArrayExpr(hjObjectClass.getType(), IntConstant.v(objectList.size())));
            predStmts.add(assignStmt2);
            for (int i = 0; i < objectList.size(); ++i) {
                HjObject hjObj = (HjObject)objectList.get(i);
                Value objValue = hjObj.getLocalValue();
                AssignStmt arrayStmt = Jimple.v().newAssignStmt(Jimple.v().newArrayRef(objsLocal, IntConstant.v(i)), objValue);
            }
            ArrayList<ArrayType> typeList2 = new ArrayList<ArrayType>();
            ArrayList<Local> paramList2 = new ArrayList<Local>();
            typeList2.add(hjObjsType);
            paramList2.add(objsLocal);
            SootMethod startIsolationMethod3 = hjRTClass.getMethod("startIsolation", typeList2, intArrayType);
            assignStmt2 = Jimple.v().newAssignStmt(placeIDs, Jimple.v().newStaticInvokeExpr(startIsolationMethod3.makeRef(), paramList2));
            predStmts.add(assignStmt2);
        }
        Stmt regionExitStmt = isolatedRegionStmt.getConnect();
        Stmt startStmt = null;
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (startStmt == null) {
                startStmt = stmt;
            }
            if (stmt == regionExitStmt) break;
            if (stmt instanceof RegionStmt) {
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (regionExpr instanceof AsyncRegionExpr) {
                    this.handleAsyncRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, branchItems);
                    continue;
                }
                if (regionExpr instanceof FinishRegionExpr) {
                    if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
                        this.handleHabFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                        continue;
                    }
                    this.handleFinishRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (regionExpr instanceof AtomicRegionExpr) {
                    this.handleAtomicRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems, false);
                    continue;
                }
                if (regionExpr instanceof IsolatedRegionExpr) {
                    this.handleIsolatedRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts, rtTraps, branchItems);
                    continue;
                }
                if (!(regionExpr instanceof LoopRegionExpr)) continue;
                this.handleLoopRegion((RegionStmt)stmt, removeStmts);
                continue;
            }
            if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt)) continue;
        }
        NopStmt endStmt = Jimple.v().newNopStmt();
        Stmt label0 = (Stmt)body.getUnits().getPredOf(isolatedRegionStmt);
        Stmt label1 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label1);
        succStmts.add(Jimple.v().newGotoStmt(endStmt));
        Local excpLocal = lg.generateLocal(throwableClass.getType());
        IdentityStmt label2 = Jimple.v().newIdentityStmt(excpLocal, Jimple.v().newCaughtExceptionRef());
        succStmts.add(label2);
        Stmt label3 = ActivityClassBuilder.v().createStopIsolation(placeID, placeIDs, hjRTClass);
        succStmts.add(label3);
        ThrowStmt label4 = Jimple.v().newThrowStmt(excpLocal);
        succStmts.add(label4);
        succStmts.add(endStmt);
        rtTraps.add(Jimple.v().newTrap(throwableClass, label0, label1, label2));
        rtTraps.add(Jimple.v().newTrap(throwableClass, label3, label4, label2));
        rtStmtMap.put(isolatedRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add(isolatedRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleLoopRegion(RegionStmt loopRegionStmt, ArrayList<Stmt> removeStmts) {
        removeStmts.add(loopRegionStmt);
        RegionStmt regionExitStmt = (RegionStmt)loopRegionStmt.getConnect();
        if (!(regionExitStmt.getRegionExpr() instanceof RegionExit)) {
            throw new Error("Can not find the exit of loop region");
        }
        removeStmts.add(regionExitStmt);
    }
}

