/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public class CallSiteMap {
    private final Map<CallSiteReference, SSAInvokeInstruction> map = HashMapFactory.make();

    public CallSiteMap(IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitInvoke(SSAInvokeInstruction instruction) {
                CallSiteReference site = instruction.getCallSite();
                CallSiteMap.this.map.put(site, instruction);
            }
        };
        SSAInstruction[] instructions = ir.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] != null) {
                instructions[i].visit(v);
            }
            ++i;
        }
    }

    public SSAInvokeInstruction getInstructionForSite(CallSiteReference site) {
        SSAInvokeInstruction result = this.map.get(site);
        return result;
    }
}

