/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextUtil;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneInterpreter
implements SSAContextInterpreter {
    public static final Atom cloneAtom = Atom.findOrCreateUnicodeAtom("clone");
    private static final Descriptor cloneDesc = Descriptor.findOrCreateUTF8("()Ljava/lang/Object;");
    public static final MethodReference CLONE = MethodReference.findOrCreate(TypeReference.JavaLangObject, cloneAtom, cloneDesc);
    private static final TypeReference SYNTHETIC_SYSTEM = TypeReference.findOrCreate(ClassLoaderReference.Primordial, TypeName.string2TypeName("Lcom/ibm/wala/model/java/lang/System"));
    private static final Atom arraycopyAtom = Atom.findOrCreateUnicodeAtom("arraycopy");
    private static final Descriptor arraycopyDesc = Descriptor.findOrCreateUTF8("(Ljava/lang/Object;Ljava/lang/Object;)V");
    private static final MethodReference SYNTHETIC_ARRAYCOPY = MethodReference.findOrCreate(SYNTHETIC_SYSTEM, arraycopyAtom, arraycopyDesc);
    private static final int ARRAYCOPY_PC = 3;
    private static final CallSiteReference ARRAYCOPY_SITE = CallSiteReference.make(3, SYNTHETIC_ARRAYCOPY, IInvokeInstruction.Dispatch.STATIC);
    private static final int NEW_PC = 0;
    private final Map<TypeReference, IR> IRCache = HashMapFactory.make();

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        Assertions._assert(this.understands(node));
        IClass cls = ContextUtil.getConcreteClassFromContext(node.getContext());
        IR result = this.IRCache.get(cls.getReference());
        if (result == null) {
            result = this.makeIR(node.getMethod(), node.getContext(), cls);
            this.IRCache.put(cls.getReference(), result);
        }
        return result;
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        Assertions._assert(this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return node.getMethod().getReference().equals(CLONE) && ContextUtil.getConcreteClassFromContext(node.getContext()) != null;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        Assertions._assert(this.understands(node));
        IClass cls = ContextUtil.getConcreteClassFromContext(node.getContext());
        return new NonNullSingletonIterator<NewSiteReference>(NewSiteReference.make(0, cls.getReference()));
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        Assertions._assert(this.understands(node));
        return new NonNullSingletonIterator<CallSiteReference>(ARRAYCOPY_SITE);
    }

    private SSAInstruction[] makeStatements(IClass klass) {
        Assertions._assert(klass != null);
        ArrayList<SSAInstruction> statements = new ArrayList<SSAInstruction>();
        int nextLocal = 2;
        int retValue = nextLocal++;
        NewSiteReference ref = NewSiteReference.make(0, klass.getReference());
        SSANewInstruction N = null;
        if (klass.isArrayClass()) {
            int length = nextLocal++;
            statements.add(new SSAArrayLengthInstruction(length, 1));
            int[] sizes = new int[klass.getReference().getDimensionality()];
            Arrays.fill(sizes, length);
            N = new SSANewInstruction(retValue, ref, sizes);
        } else {
            N = new SSANewInstruction(retValue, ref);
        }
        statements.add(N);
        int exceptionValue = nextLocal++;
        if (klass.getReference().isArrayType()) {
            int[] params = new int[]{1, retValue};
            SSAInvokeInstruction S = new SSAInvokeInstruction(params, exceptionValue, ARRAYCOPY_SITE);
            statements.add(S);
        } else {
            IClass k = klass;
            while (k != null) {
                for (IField f : klass.getDeclaredInstanceFields()) {
                    int tempValue = nextLocal++;
                    SSAGetInstruction G = new SSAGetInstruction(tempValue, 1, f.getReference());
                    statements.add(G);
                    SSAPutInstruction P = new SSAPutInstruction(retValue, tempValue, f.getReference());
                    statements.add(P);
                }
                try {
                    k = k.getSuperclass();
                }
                catch (ClassHierarchyException e) {
                    Assertions.UNREACHABLE();
                }
            }
        }
        SSAReturnInstruction R = new SSAReturnInstruction(retValue, false);
        statements.add(R);
        SSAInstruction[] result = new SSAInstruction[statements.size()];
        Iterator it = statements.iterator();
        int i = 0;
        while (i < result.length) {
            result[i] = (SSAInstruction)it.next();
            ++i;
        }
        return result;
    }

    private IR makeIR(IMethod method, Context context, IClass klass) {
        Assertions._assert(klass != null);
        SSAInstruction[] instrs = this.makeStatements(klass);
        return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), null);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.getFieldsRead(statements).iterator();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.getFieldsWritten(statements).iterator();
    }

    public Set getCaughtExceptions(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.getCaughtExceptions(statements);
    }

    public boolean hasObjectArrayLoad(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.hasObjectArrayLoad(statements);
    }

    public boolean hasObjectArrayStore(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.hasObjectArrayStore(statements);
    }

    public Iterator iterateCastTypes(CGNode node) {
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.iterateCastTypes(statements);
    }

    @Override
    public ControlFlowGraph<ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        return new DefUse(this.getIR(node));
    }
}

