/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.SetType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ReflectionSpecification;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.callgraph.propagation.rta.RTAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.ReflectionSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.ipa.summaries.XMLReflectionReader;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBypassInterpreter
implements RTAContextInterpreter,
SSAContextInterpreter {
    private static final boolean DEBUG = false;
    private static final int CONE_BOUND = 10;
    private int indexLocal = 100;
    private final Map<TypeReference, Integer> typeIndexMap = HashMapFactory.make();
    private final Map<Context, Set<TypeReference>> map = HashMapFactory.make();
    private final Map<Context, SpecializedFactoryMethod> syntheticMethodCache = HashMapFactory.make();
    private final AnalysisOptions options;
    private final AnalysisCache cache;
    private final ReflectionSpecification userSpec;

    public FactoryBypassInterpreter(AnalysisOptions options, AnalysisCache cache, ReflectionSpecification userSpec) {
        this.options = options;
        this.userSpec = userSpec;
        this.cache = cache;
    }

    private int getLocalForType(TypeReference T) {
        Integer I = this.typeIndexMap.get(T);
        if (I == null) {
            I = new Integer(this.indexLocal += 2);
            this.typeIndexMap.put(T, I);
        }
        return I;
    }

    private int getExceptionsForType(TypeReference T) {
        return this.getLocalForType(T) + 1;
    }

    private int getCallSiteForType(TypeReference T) {
        return this.getLocalForType(T);
    }

    private int getNewSiteForType(TypeReference T) {
        return this.getLocalForType(T) + 1;
    }

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return this.cache.getSSACache().findOrCreateIR(m, node.getContext(), this.options.getSSAOptions());
    }

    private Set getTypesForContext(Context context) {
        Set types;
        CallerSiteContext site;
        MethodReference m;
        ReflectionSummary summary;
        XMLReflectionReader spec = (XMLReflectionReader)this.userSpec;
        if (spec != null && context instanceof CallerSiteContext && (summary = spec.getSummary(m = (site = (CallerSiteContext)context).getCaller().getMethod().getReference())) != null && (types = summary.getTypesForProgramLocation(site.getCallSite().getProgramCounter())) != null) {
            return types;
        }
        Set<TypeReference> types2 = this.map.get(context);
        return types2;
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return m.allInstructions.size();
    }

    @Override
    public boolean understands(CGNode node) {
        SyntheticMethod s;
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (node.getMethod().isSynthetic() && (s = (SyntheticMethod)node.getMethod()).isFactoryMethod()) {
            return this.getTypesForContext(node.getContext()) != null;
        }
        return false;
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        HashSet result = HashSetFactory.make(5);
        for (SSANewInstruction sSANewInstruction : m.getAllocationStatements()) {
            result.add(sSANewInstruction.getNewSite());
        }
        return result.iterator();
    }

    public Iterator<SSAInstruction> getInvokeStatements(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return m.getInvokeStatements().iterator();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        final Iterator<SSAInstruction> I = this.getInvokeStatements(node);
        return new Iterator<CallSiteReference>(){

            @Override
            public boolean hasNext() {
                return I.hasNext();
            }

            @Override
            public CallSiteReference next() {
                SSAInvokeInstruction s = (SSAInvokeInstruction)I.next();
                return s.getCallSite();
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public boolean recordType(IClassHierarchy cha, Context context, TypeReference type) {
        Set types = this.map.get(context);
        if (types == null) {
            types = HashSetFactory.make(2);
            this.map.put(context, types);
        }
        if (types.contains(type)) {
            return false;
        }
        types.add(type);
        SpecializedFactoryMethod m = this.syntheticMethodCache.get(context);
        if (m != null) {
            TypeAbstraction T = this.typeRef2TypeAbstraction(cha, type);
            m.addStatementsForTypeAbstraction(T);
            this.cache.getSSACache().invalidate(m, context);
        }
        return true;
    }

    private TypeAbstraction typeRef2TypeAbstraction(IClassHierarchy cha, TypeReference type) {
        IClass klass = cha.lookupClass(type);
        if (klass != null) {
            return new ConeType(klass);
        }
        Assertions.UNREACHABLE(type.toString());
        return null;
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        return this.recordType(node.getMethod().getClassHierarchy(), node.getContext(), klass.getReference());
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getFieldsRead(m).iterator();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getFieldsWritten(m).iterator();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private SpecializedFactoryMethod findOrCreateSpecializedFactoryMethod(CGNode node) {
        SpecializedFactoryMethod m = this.syntheticMethodCache.get(node.getContext());
        if (m == null) {
            Set types = this.getTypesForContext(node.getContext());
            m = new SpecializedFactoryMethod((SummarizedMethod)node.getMethod(), node.getContext(), types);
            this.syntheticMethodCache.put(node.getContext(), m);
        }
        return m;
    }

    public Set getCaughtExceptions(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.getCaughtExceptions(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public boolean hasObjectArrayLoad(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.hasObjectArrayLoad(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public boolean hasObjectArrayStore(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.hasObjectArrayStore(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    public Iterator iterateCastTypes(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        try {
            return CodeScanner.iterateCastTypes(m);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public ControlFlowGraph<ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        SpecializedFactoryMethod m = this.findOrCreateSpecializedFactoryMethod(node);
        return this.cache.getSSACache().findOrCreateDU(m, node.getContext(), this.options.getSSAOptions());
    }

    private static class IgnoreSerializableWarning
    extends Warning {
        private static final IgnoreSerializableWarning instance = new IgnoreSerializableWarning();

        private IgnoreSerializableWarning() {
        }

        public String getMsg() {
            return this.getClass().toString();
        }

        public static IgnoreSerializableWarning create() {
            return instance;
        }
    }

    private static class ManySubtypesWarning
    extends Warning {
        final int nImplementors;
        final TypeAbstraction T;

        ManySubtypesWarning(TypeAbstraction T, int nImplementors) {
            super((byte)1);
            this.T = T;
            this.nImplementors = nImplementors;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T + " " + this.nImplementors;
        }

        public static ManySubtypesWarning create(TypeAbstraction T, int n) {
            return new ManySubtypesWarning(T, n);
        }
    }

    private static class NoSubtypesWarning
    extends Warning {
        final TypeAbstraction T;

        NoSubtypesWarning(TypeAbstraction T) {
            super((byte)2);
            this.T = T;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T;
        }

        public static NoSubtypesWarning create(TypeAbstraction T) {
            return new NoSubtypesWarning(T);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecializedFactoryMethod
    extends SyntheticMethod {
        private final ArrayList<SSAInstruction> allocations;
        private final ArrayList<SSAInstruction> calls;
        private final ArrayList<SSAInstruction> allInstructions;
        private final IMethod method;
        private final Context context;
        private int nextLocal;
        private int valueNumberForConstantOne;
        private final HashSet<TypeReference> types;

        private void initValueNumberForConstantOne() {
            if (this.valueNumberForConstantOne == -1) {
                this.valueNumberForConstantOne = this.nextLocal++;
            }
        }

        private SpecializedFactoryMethod(SummarizedMethod m, Context context, Set S) {
            super(m, m.getDeclaringClass(), m.isStatic(), true);
            this.allocations = new ArrayList();
            this.calls = new ArrayList();
            this.allInstructions = new ArrayList();
            this.valueNumberForConstantOne = -1;
            this.types = HashSetFactory.make(5);
            this.context = context;
            this.method = m;
            Assertions._assert(S != null);
            Assertions._assert(m.getDeclaringClass() != null, "null declaring class for " + m);
            this.nextLocal = this.addOriginalStatements(m);
            for (TypeReference type : S) {
                TypeAbstraction T = FactoryBypassInterpreter.this.typeRef2TypeAbstraction(m.getClassHierarchy(), type);
                this.addStatementsForTypeAbstraction(T);
            }
        }

        private void addStatementsForTypeAbstraction(TypeAbstraction T) {
            if ((T = this.interceptType(T)) == null) {
                return;
            }
            if (T instanceof PointType || T instanceof ConeType) {
                TypeReference ref = T.getType().getReference();
                NewSiteReference site = NewSiteReference.make(0, ref);
                IClass klass = FactoryBypassInterpreter.this.options.getClassTargetSelector().getAllocatedTarget(null, site);
                if (T instanceof PointType) {
                    this.addStatementsForConcreteType(ref);
                } else if (T instanceof ConeType) {
                    if (((ConeType)T).isInterface()) {
                        Set<IClass> implementors = T.getType().getClassHierarchy().getImplementors(ref);
                        if (implementors.isEmpty()) {
                            Warnings.add(NoSubtypesWarning.create(T));
                        }
                        if (implementors.size() > 10) {
                            Warnings.add(ManySubtypesWarning.create(T, implementors.size()));
                        }
                        this.addStatementsForSetOfTypes(implementors.iterator());
                    } else {
                        Collection<IClass> subclasses = T.getType().getClassHierarchy().computeSubClasses(ref);
                        if (subclasses.isEmpty()) {
                            Warnings.add(NoSubtypesWarning.create(T));
                        }
                        if (subclasses.size() > 10) {
                            Warnings.add(ManySubtypesWarning.create(T, subclasses.size()));
                        }
                        this.addStatementsForSetOfTypes(subclasses.iterator());
                    }
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + T.getClass());
                }
            } else if (T instanceof SetType) {
                this.addStatementsForSetOfTypes(((SetType)T).iteratePoints());
            } else {
                Assertions.UNREACHABLE("Unexpected type " + T.getClass());
            }
        }

        private TypeAbstraction interceptType(TypeAbstraction T) {
            TypeReference type = T.getType().getReference();
            if (type.equals(TypeReference.JavaIoSerializable)) {
                Warnings.add(IgnoreSerializableWarning.create());
                return null;
            }
            return T;
        }

        private void addStatementsForConcreteType(TypeReference T) {
            if (this.types.contains(T)) {
                return;
            }
            this.types.add(T);
            NewSiteReference ref = NewSiteReference.make(FactoryBypassInterpreter.this.getNewSiteForType(T), T);
            int alloc = FactoryBypassInterpreter.this.getLocalForType(T);
            SSANewInstruction a = new SSANewInstruction(alloc, ref);
            this.allocations.add(a);
            this.allInstructions.add(a);
            SSAReturnInstruction r = new SSAReturnInstruction(alloc, false);
            this.allInstructions.add(r);
            if (T.isArrayType()) {
                MethodReference init = MethodReference.findOrCreate(T, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference site = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(T), init, IInvokeInstruction.Dispatch.SPECIAL);
                int[] params = new int[]{alloc};
                int exc = FactoryBypassInterpreter.this.getExceptionsForType(T);
                SSAInvokeInstruction s = new SSAInvokeInstruction(params, exc, site);
                this.calls.add(s);
                this.allInstructions.add(s);
            }
        }

        private int addOriginalStatements(SummarizedMethod m) {
            SSAInstruction[] original = m.getStatements(FactoryBypassInterpreter.this.options.getSSAOptions());
            int nextLocal = 2;
            int i = 0;
            while (i < original.length) {
                SSAInstruction s = original[i];
                this.allInstructions.add(s);
                if (s instanceof SSAInvokeInstruction) {
                    this.calls.add(s);
                }
                if (s instanceof SSANewInstruction) {
                    this.allocations.add(s);
                }
                int j = 0;
                while (j < s.getNumberOfDefs()) {
                    int def = s.getDef(j);
                    if (def >= nextLocal) {
                        nextLocal = def + 1;
                    }
                    ++j;
                }
                j = 0;
                while (j < s.getNumberOfUses()) {
                    int use = s.getUse(j);
                    if (use >= nextLocal) {
                        nextLocal = use + 1;
                    }
                    ++j;
                }
                ++i;
            }
            return nextLocal;
        }

        private void addStatementsForSetOfTypes(Iterator it) {
            if (!it.hasNext()) {
                SSAReturnInstruction r = new SSAReturnInstruction(this.nextLocal, false);
                this.allInstructions.add(r);
            }
            while (it.hasNext()) {
                IClass klass = (IClass)it.next();
                TypeReference T = klass.getReference();
                if (klass.isAbstract() || this.types.contains(T)) continue;
                this.types.add(T);
                int i = FactoryBypassInterpreter.this.getLocalForType(T);
                NewSiteReference ref = NewSiteReference.make(FactoryBypassInterpreter.this.getNewSiteForType(T), T);
                SSANewInstruction a = null;
                if (T.isArrayType()) {
                    int[] sizes = new int[T.getDimensionality()];
                    this.initValueNumberForConstantOne();
                    Arrays.fill(sizes, this.valueNumberForConstantOne);
                    a = new SSANewInstruction(i, ref, sizes);
                } else {
                    a = new SSANewInstruction(i, ref);
                }
                this.allocations.add(a);
                this.allInstructions.add(a);
                SSAReturnInstruction r = new SSAReturnInstruction(i, false);
                this.allInstructions.add(r);
                MethodReference init = MethodReference.findOrCreate(T, MethodReference.initAtom, MethodReference.defaultInitDesc);
                CallSiteReference site = CallSiteReference.make(FactoryBypassInterpreter.this.getCallSiteForType(T), init, IInvokeInstruction.Dispatch.SPECIAL);
                int[] params = new int[]{i};
                SSAInvokeInstruction s = new SSAInvokeInstruction(params, FactoryBypassInterpreter.this.getExceptionsForType(T), site);
                this.calls.add(s);
                this.allInstructions.add(s);
            }
        }

        public List<SSAInstruction> getAllocationStatements() {
            return this.allocations;
        }

        public List<SSAInstruction> getInvokeStatements() {
            return this.calls;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public SSAInstruction[] getStatements() {
            SSAInstruction[] result = new SSAInstruction[this.allInstructions.size()];
            int i = 0;
            Iterator<SSAInstruction> it = this.allInstructions.iterator();
            while (it.hasNext()) {
                result[i++] = it.next();
            }
            return result;
        }

        @Override
        public IClass getDeclaringClass() {
            if (this.method.getDeclaringClass() == null) {
                Assertions._assert(this.method.getDeclaringClass() != null, "null declaring class for original method " + this.method);
            }
            return this.method.getDeclaringClass();
        }

        @Override
        public int getNumberOfParameters() {
            return this.method.getNumberOfParameters();
        }

        @Override
        public TypeReference getParameterType(int i) {
            return this.method.getParameterType(i);
        }

        @Override
        public IR makeIR(SSAOptions options) {
            SSAInstruction[] instrs = this.getStatements();
            Map constants = null;
            if (this.valueNumberForConstantOne > -1) {
                constants = HashMapFactory.make(1);
                constants.put(new Integer(this.valueNumberForConstantOne), new ConstantValue(new Integer(1)));
            }
            return new SyntheticIR(this, this.context, new InducedCFG(instrs, this, this.context), instrs, options, constants);
        }
    }
}

