/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;

public class FactoryContextSelector
implements ContextSelector {
    private final MethodTargetSelector methodTargetSelector;
    private final IClassHierarchy cha;

    public FactoryContextSelector(IClassHierarchy cha, MethodTargetSelector methodTargetSelector) {
        this.cha = cha;
        this.methodTargetSelector = methodTargetSelector;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey receiver) {
        SyntheticMethod s;
        if (callee == null) {
            throw new IllegalArgumentException("callee is null");
        }
        if (callee.isSynthetic() && (s = (SyntheticMethod)callee).isFactoryMethod()) {
            return new CallerSiteContext(caller, site);
        }
        return null;
    }

    public boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey instance) {
        SyntheticMethod s;
        if (targetMethod == null) {
            throw new IllegalArgumentException("targetMethod is null");
        }
        return targetMethod.isSynthetic() && (s = (SyntheticMethod)targetMethod).isFactoryMethod();
    }

    public int getBoundOnNumberOfTargets(CGNode caller, CallSiteReference site, IMethod callee) {
        SyntheticMethod s;
        if (callee == null) {
            throw new IllegalArgumentException("callee is null");
        }
        if (callee.isSynthetic() && (s = (SyntheticMethod)callee).isFactoryMethod()) {
            return 1;
        }
        return -1;
    }

    public boolean contextIsIrrelevant(CGNode node, CallSiteReference site) {
        boolean result = this.methodTargetSelector.mightReturnSyntheticMethod(node, site);
        if (result) {
            IMethod callee = this.methodTargetSelector.getCalleeTarget(node, site, null);
            if (callee != null && callee.isSynthetic()) {
                SyntheticMethod s = (SyntheticMethod)callee;
                return !s.isFactoryMethod();
            }
            return true;
        }
        return true;
    }

    public boolean allSitesDispatchIdentically(CGNode node, CallSiteReference site) {
        boolean result = this.methodTargetSelector.mightReturnSyntheticMethod(node, site);
        if (result) {
            IClass recv = this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass());
            if (recv == null) {
                return false;
            }
            IMethod callee = this.methodTargetSelector.getCalleeTarget(node, site, recv);
            if (callee != null && callee.isSynthetic()) {
                SyntheticMethod s = (SyntheticMethod)callee;
                return !s.isFactoryMethod();
            }
            return true;
        }
        return true;
    }
}

