/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.util.debug.Assertions;

public class JavaTypeContext
implements Context {
    private final TypeAbstraction type;

    public JavaTypeContext(TypeAbstraction type) {
        Assertions._assert(type != null);
        this.type = type;
    }

    public ContextItem get(ContextKey name) {
        if (name == ContextKey.RECEIVER) {
            return this.type;
        }
        if (name == ContextKey.FILTER) {
            if (this.type instanceof PointType) {
                IClass cls = ((PointType)this.type).getIClass();
                return new FilteredPointerKey.SingleClassFilter(cls);
            }
            return null;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        return "JavaTypeContext<" + this.type + ">";
    }

    public int hashCode() {
        return 6367 * this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            JavaTypeContext other = (JavaTypeContext)obj;
            return this.type.equals(other.type);
        }
        return false;
    }
}

