/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.stackMachine;

import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.AbstractStatement;
import com.ibm.wala.fixedpoint.impl.AbstractVariable;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ShrikeUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

public abstract class AbstractIntStackMachine
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    public static final int UNANALYZED = -3;
    public static final int IGNORE = -4;
    private DataflowSolver solver;
    private final ShrikeCFG cfg;
    private final int maxStackHeight;
    protected final int maxLocals;
    public static final boolean OPTIMISTIC = true;

    protected AbstractIntStackMachine(ShrikeCFG G) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.maxStackHeight = G.getMaxStackHeight();
        this.maxLocals = G.getMaxLocals();
        this.cfg = G;
    }

    protected void init(Meeter meeter, final FlowProvider flow) {
        final MeetOperator meet = new MeetOperator(meeter);
        ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState> xferFunctions = new ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState>(){

            @Override
            public boolean hasNodeTransferFunctions() {
                return flow.needsNodeFlow();
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return flow.needsEdgeFlow();
            }

            @Override
            public UnaryOperator<MachineState> getNodeTransferFunction(final ShrikeCFG.BasicBlock node) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, node);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "NODE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * node.hashCode();
                    }

                    @Override
                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            @Override
            public UnaryOperator<MachineState> getEdgeTransferFunction(final ShrikeCFG.BasicBlock from, final ShrikeCFG.BasicBlock to) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, from, to);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "EDGE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * (from.hashCode() ^ to.hashCode());
                    }

                    @Override
                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            @Override
            public AbstractMeetOperator<MachineState> getMeetOperator() {
                return meet;
            }
        };
        BasicFramework<ShrikeCFG.BasicBlock, MachineState> problem = new BasicFramework<ShrikeCFG.BasicBlock, MachineState>(this.cfg, xferFunctions);
        this.solver = new DataflowSolver<ShrikeCFG.BasicBlock, MachineState>(problem){
            private MachineState entry;

            @Override
            protected MachineState makeNodeVariable(ShrikeCFG.BasicBlock n, boolean IN) {
                Assertions._assert(n != null);
                MachineState result = new MachineState(71167 * n.hashCode() + (IN ? 0 : 1), n);
                if (IN && n.equals(AbstractIntStackMachine.this.cfg.entry())) {
                    this.entry = result;
                }
                return result;
            }

            @Override
            protected MachineState makeEdgeVariable(ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
                Assertions._assert(from != null);
                Assertions._assert(to != null);
                MachineState result = new MachineState(71167 * (from.hashCode() + to.hashCode()), from);
                return result;
            }

            @Override
            protected void initializeWorkList() {
                super.buildEquations(false, false);
                Iterator it = this.getFixedPointSystem().getStatementsThatUse(this.entry);
                while (it.hasNext()) {
                    AbstractStatement s = (AbstractStatement)it.next();
                    this.addToWorkList(s);
                }
            }

            @Override
            protected void initializeVariables() {
                super.initializeVariables();
                AbstractIntStackMachine.this.initializeVariables();
            }
        };
    }

    public boolean solve() {
        return this.solver.solve();
    }

    protected void initializeVariables() {
    }

    public MachineState getEntryState() {
        return (MachineState)this.solver.getIn(this.cfg.entry());
    }

    public MachineState getIn(ShrikeCFG.BasicBlock bb) {
        return (MachineState)this.solver.getIn(bb);
    }

    private boolean meet(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = this.meetStacks(lhs, rhs, bb, meeter);
        return changed |= this.meetLocals(lhs, rhs, bb, meeter);
    }

    private boolean meetForCatchBlock(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = this.meetStacksAtCatchBlock(lhs, bb, meeter);
        return changed |= this.meetLocals(lhs, rhs, bb, meeter);
    }

    private boolean meetStacksAtCatchBlock(IVariable lhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        if (L.stack == null) {
            L.allocateStack();
            L.stackHeight = 1;
        }
        int meet = meeter.meetStackAtCatchBlock(bb);
        if (L.stack[0] == -1) {
            if (meet != -1) {
                changed = true;
                ((MachineState)L).stack[0] = meet;
            }
        } else if (meet != L.stack[0]) {
            changed = true;
            ((MachineState)L).stack[0] = meet;
        }
        return changed;
    }

    private boolean meetStacks(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        int height = AbstractIntStackMachine.computeMeetStackHeight(rhs);
        if (height > -1 && L.stack == null) {
            L.allocateStack();
            L.stackHeight = height;
            changed = true;
        }
        int i = 0;
        while (i < height) {
            int[] R = new int[rhs.length];
            int j = 0;
            while (j < R.length) {
                MachineState m = (MachineState)rhs[j];
                if (m.stack == null) {
                    R[j] = -1;
                } else {
                    R[j] = m.stack[i];
                    if (R[j] == 0) {
                        R[j] = -1;
                    }
                }
                ++j;
            }
            int meet = meeter.meetStack(i, R, bb);
            if (L.stack[i] == -1) {
                if (meet != -1) {
                    changed = true;
                    ((MachineState)L).stack[i] = meet;
                }
            } else if (meet != L.stack[i]) {
                changed = true;
                ((MachineState)L).stack[i] = meet;
            }
            ++i;
        }
        return changed;
    }

    private boolean meetLocals(IVariable lhs, IVariable[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        MachineState L = (MachineState)lhs;
        int nLocals = AbstractIntStackMachine.computeMeetNLocals(rhs);
        if (nLocals > -1 && L.locals == null) {
            L.allocateLocals();
        }
        int i = 0;
        while (i < nLocals) {
            int[] R = new int[rhs.length];
            int j = 0;
            while (j < rhs.length) {
                R[j] = ((MachineState)rhs[j]).getLocal(i);
                ++j;
            }
            int meet = meeter.meetLocal(i, R, bb);
            if (L.locals[i] == -1) {
                if (meet != -1) {
                    changed = true;
                    ((MachineState)L).locals[i] = meet;
                }
            } else if (meet != L.locals[i]) {
                changed = true;
                ((MachineState)L).locals[i] = meet;
            }
            ++i;
        }
        return changed;
    }

    private static int computeMeetNLocals(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int nLocals = -1;
        if (lhs.locals != null) {
            nLocals = lhs.locals.length;
        } else {
            int i = 1;
            while (i < operands.length) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.locals != null) {
                    nLocals = rhs.locals.length;
                    break;
                }
                ++i;
            }
        }
        return nLocals;
    }

    private static int computeMeetStackHeight(IVariable[] operands) {
        MachineState lhs = (MachineState)operands[0];
        int height = -1;
        if (lhs.stack != null) {
            height = lhs.stackHeight;
        } else {
            int i = 1;
            while (i < operands.length) {
                MachineState rhs = (MachineState)operands[i];
                if (rhs.stack != null) {
                    height = rhs.stackHeight;
                    break;
                }
                ++i;
            }
        }
        return height;
    }

    public int[] allocateNewLocalsArray() {
        int[] result = new int[this.maxLocals];
        int i = 0;
        while (i < this.maxLocals) {
            result[i] = -1;
            ++i;
        }
        return result;
    }

    protected static abstract class BasicStackFlowProvider
    implements FlowProvider,
    Constants {
        private final ShrikeCFG cfg;
        protected MachineState workingState;
        private BasicStackMachineVisitor visitor;
        private Instruction.Visitor edgeVisitor;
        private int currentInstructionIndex = 0;
        private ShrikeCFG.BasicBlock currentBlock;
        private ShrikeCFG.BasicBlock currentSuccessorBlock;

        protected BasicStackFlowProvider(ShrikeCFG cfg) {
            this.cfg = cfg;
        }

        protected void init(BasicStackMachineVisitor v, Instruction.Visitor ev) {
            this.visitor = v;
            this.edgeVisitor = ev;
        }

        public boolean needsNodeFlow() {
            return true;
        }

        public boolean needsEdgeFlow() {
            return false;
        }

        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock basicBlock) {
            this.workingState = entry.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = null;
            Instruction[] instructions = this.getInstructions();
            int i = basicBlock.getFirstInstructionIndex();
            while (i <= basicBlock.getLastInstructionIndex()) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.visitor);
                ++i;
            }
            return this.workingState;
        }

        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
            this.workingState = entry.duplicate();
            this.currentBlock = from;
            this.currentSuccessorBlock = to;
            Instruction[] instructions = this.getInstructions();
            int i = from.getFirstInstructionIndex();
            while (i <= from.getLastInstructionIndex()) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.edgeVisitor);
                ++i;
            }
            return this.workingState;
        }

        protected int getCurrentInstructionIndex() {
            return this.currentInstructionIndex;
        }

        protected int getCurrentProgramCounter() {
            return this.cfg.getProgramCounter(this.currentInstructionIndex);
        }

        protected ShrikeCFG.BasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        protected ShrikeCFG.BasicBlock getCurrentSuccessor() {
            return this.currentSuccessorBlock;
        }

        public abstract Instruction[] getInstructions();

        protected class BasicStackMachineVisitor
        extends Instruction.Visitor {
            protected BasicStackMachineVisitor() {
            }

            public void visitArrayLength(ArrayLengthInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayLoad(ArrayLoadInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitArrayStore(ArrayStoreInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitBinaryOp(BinaryOpInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitComparison(ComparisonInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConditionalBranch(ConditionalBranchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitConstant(ConstantInstruction instruction) {
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitConversion(ConversionInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitDup(DupInstruction instruction) {
                int v4;
                int size = instruction.getSize();
                int delta = instruction.getDelta();
                Assertions._assert(size == 1 || size == 2);
                Assertions._assert(delta == 0 || delta == 1 || delta == 2);
                int toPop = size + delta;
                int v1 = BasicStackFlowProvider.this.workingState.pop();
                int v2 = toPop > 1 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int v3 = toPop > 2 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int n = v4 = toPop > 3 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                if (size > 1) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
                if (v4 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v4);
                }
                if (v3 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v3);
                }
                if (v2 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
            }

            public void visitGet(GetInstruction instruction) {
                this.popN(instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            protected void popN(Instruction instruction) {
                int i = 0;
                while (i < instruction.getPoppedCount()) {
                    BasicStackFlowProvider.this.workingState.pop();
                    ++i;
                }
            }

            public void visitInstanceof(InstanceofInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitInvoke(InvokeInstruction instruction) {
                this.popN(instruction);
                ClassLoaderReference loader = BasicStackFlowProvider.this.cfg.getMethod().getDeclaringClass().getClassLoader().getReference();
                TypeReference returnType = ShrikeUtil.makeTypeReference(loader, Util.getReturnType(instruction.getMethodSignature()));
                if (!returnType.equals(TypeReference.Void)) {
                    BasicStackFlowProvider.this.workingState.push(-3);
                }
            }

            public void visitMonitor(MonitorInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitLocalLoad(LoadInstruction instruction) {
                int t = BasicStackFlowProvider.this.workingState.getLocal(instruction.getVarIndex());
                BasicStackFlowProvider.this.workingState.push(t);
            }

            public void visitLocalStore(StoreInstruction instruction) {
                int index = instruction.getVarIndex();
                BasicStackFlowProvider.this.workingState.setLocal(index, BasicStackFlowProvider.this.workingState.pop());
            }

            public void visitNew(NewInstruction instruction) {
                this.popN(instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            public void visitPop(PopInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitPut(PutInstruction instruction) {
                this.popN(instruction);
            }

            public void visitShift(ShiftInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitSwap(SwapInstruction instruction) {
                BasicStackFlowProvider.this.workingState.swap();
            }

            public void visitSwitch(SwitchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            public void visitThrow(ThrowInstruction instruction) {
                int exceptionType = BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.clearStack();
                BasicStackFlowProvider.this.workingState.push(exceptionType);
            }

            public void visitUnaryOp(UnaryOpInstruction instruction) {
            }
        }
    }

    public static interface FlowProvider {
        public boolean needsNodeFlow();

        public boolean needsEdgeFlow();

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2);

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2, ShrikeCFG.BasicBlock var3);
    }

    public class MachineState
    extends AbstractVariable {
        private int[] stack;
        private int[] locals;
        private int stackHeight;
        private final int hash;
        private final ShrikeCFG.BasicBlock bb;

        public MachineState duplicate() {
            MachineState result = new MachineState(this.hash, this.bb);
            result.copyState(this);
            return result;
        }

        public MachineState(int hashCode, ShrikeCFG.BasicBlock bb) {
            this.setTOP();
            this.hash = hashCode;
            this.bb = bb;
        }

        public ShrikeCFG.BasicBlock getBasicBlock() {
            return this.bb;
        }

        void setTOP() {
            this.stackHeight = -1;
        }

        boolean isTOP() {
            return this.stackHeight == -1;
        }

        public void push(int i) {
            if (this.stack == null) {
                this.allocateStack();
            }
            this.stack[this.stackHeight++] = i;
        }

        public int pop() {
            if (this.stackHeight <= 0) {
                Assertions._assert(this.stackHeight > 0, "can't pop stack of height " + this.stackHeight);
            }
            --this.stackHeight;
            return this.stack[this.stackHeight];
        }

        public int peek() {
            return this.stack[this.stackHeight - 1];
        }

        public void swap() {
            int temp = this.stack[this.stackHeight - 1];
            this.stack[this.stackHeight - 1] = this.stack[this.stackHeight - 2];
            this.stack[this.stackHeight - 2] = temp;
        }

        private void allocateStack() {
            this.stack = new int[AbstractIntStackMachine.this.maxStackHeight + 1];
            this.stackHeight = 0;
        }

        private void allocateLocals() {
            this.locals = AbstractIntStackMachine.this.allocateNewLocalsArray();
        }

        public void clearStack() {
            this.stackHeight = 0;
        }

        public void setLocal(int i, int j) {
            if (this.locals == null) {
                if (j == -1) {
                    return;
                }
                this.allocateLocals();
            }
            this.locals[i] = j;
        }

        public int getLocal(int i) {
            if (this.locals == null) {
                return -1;
            }
            return this.locals[i];
        }

        public void replaceValue(int from, int to) {
            int i;
            if (this.stack != null) {
                i = 0;
                while (i < this.stackHeight) {
                    if (this.stack[i] == from) {
                        this.stack[i] = to;
                    }
                    ++i;
                }
            }
            if (this.locals != null) {
                i = 0;
                while (i < AbstractIntStackMachine.this.maxLocals) {
                    if (this.locals[i] == from) {
                        this.locals[i] = to;
                    }
                    ++i;
                }
            }
        }

        public boolean hasValue(int val) {
            int i;
            if (this.stack != null) {
                i = 0;
                while (i < this.stackHeight) {
                    if (this.stack[i] == val) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.locals != null) {
                i = 0;
                while (i < AbstractIntStackMachine.this.maxLocals) {
                    if (this.locals[i] == val) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String toString() {
            if (this.isTOP()) {
                return "<TOP>@" + System.identityHashCode(this);
            }
            StringBuffer result = new StringBuffer("<");
            result.append("S");
            if (this.stackHeight == 0) {
                result.append("[empty]");
            } else {
                result.append(this.array2StringBuffer(this.stack, this.stackHeight));
            }
            result.append("L");
            result.append(this.array2StringBuffer(this.locals, AbstractIntStackMachine.this.maxLocals));
            result.append(">");
            return result.toString();
        }

        private StringBuffer array2StringBuffer(int[] array, int n) {
            StringBuffer result = new StringBuffer("[");
            if (array == null) {
                result.append("TOP");
            } else {
                int i = 0;
                while (i < n - 1) {
                    result.append(array[i]).append(",");
                    ++i;
                }
                result.append(array[n - 1]);
            }
            result.append("]");
            return result;
        }

        public void copyState(IVariable v) {
            MachineState other = (MachineState)v;
            if (other.stack == null) {
                this.stack = null;
            } else {
                this.stack = new int[other.stack.length];
                System.arraycopy(other.stack, 0, this.stack, 0, other.stack.length);
            }
            if (other.locals == null) {
                this.locals = null;
            } else {
                this.locals = new int[other.locals.length];
                System.arraycopy(other.locals, 0, this.locals, 0, other.locals.length);
            }
            this.stackHeight = other.stackHeight;
        }

        boolean stateEquals(MachineState exit) {
            if (this.stackHeight != exit.stackHeight) {
                return false;
            }
            if (this.locals == null) {
                if (exit.locals != null) {
                    return false;
                }
            } else {
                if (exit.locals == null) {
                    return false;
                }
                if (this.locals.length != exit.locals.length) {
                    return false;
                }
            }
            int i = 0;
            while (i < this.stackHeight) {
                if (this.stack[i] != exit.stack[i]) {
                    return false;
                }
                ++i;
            }
            if (this.locals != null) {
                i = 0;
                while (i < this.locals.length) {
                    if (this.locals[i] == -1 && exit.locals[i] != -1) {
                        return false;
                    }
                    if (this.locals[i] != exit.locals[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public int hashCode() {
            return this.hash;
        }

        public int[] getLocals() {
            return this.locals;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeetOperator
    extends AbstractMeetOperator<MachineState> {
        private final Meeter meeter;

        MeetOperator(Meeter meeter) {
            this.meeter = meeter;
        }

        @Override
        public boolean isUnaryNoOp() {
            return false;
        }

        @Override
        public byte evaluate(MachineState lhs, IVariable[] rhs) {
            ShrikeCFG.BasicBlock bb = lhs.getBasicBlock();
            if (!bb.isCatchBlock()) {
                return AbstractIntStackMachine.this.meet(lhs, rhs, bb, this.meeter) ? (byte)1 : 0;
            }
            return AbstractIntStackMachine.this.meetForCatchBlock(lhs, rhs, bb, this.meeter) ? (byte)1 : 0;
        }

        @Override
        public int hashCode() {
            return 72223 * this.meeter.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MeetOperator) {
                MeetOperator other = (MeetOperator)o;
                return this.meeter.equals(other.meeter);
            }
            return false;
        }

        @Override
        public String toString() {
            return "MEETER";
        }
    }

    protected static interface Meeter {
        public int meetStack(int var1, int[] var2, ShrikeCFG.BasicBlock var3);

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock var1);

        public int meetLocal(int var1, int[] var2, ShrikeCFG.BasicBlock var3);
    }
}

