/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

public class ConeType
extends TypeAbstraction {
    private final IClass type;

    public ConeType(IClass type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Assertions._assert(type.getReference().isReferenceType());
        this.type = type;
    }

    public TypeAbstraction meet(TypeAbstraction rhs) {
        if (rhs == TOP) {
            return this;
        }
        if (rhs instanceof ConeType) {
            ConeType other = (ConeType)rhs;
            if (this.type.equals(other.type)) {
                return this;
            }
            if (this.type.isArrayClass() || other.type.isArrayClass()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            return new ConeType(this.type.getClassHierarchy().getLeastCommonSuperclass(this.type, other.type));
        }
        if (rhs instanceof PointType) {
            return rhs.meet(this);
        }
        if (rhs instanceof PrimitiveType) {
            return TOP;
        }
        Assertions.UNREACHABLE("unexpected type " + rhs.getClass());
        return null;
    }

    public String toString() {
        return "cone:" + this.type.toString();
    }

    public IClass getType() {
        return this.type;
    }

    public TypeReference getTypeReference() {
        return this.type.getReference();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConeType)) {
            return false;
        }
        ConeType other = (ConeType)obj;
        if (other == TOP) {
            return false;
        }
        if (!this.type.getClassHierarchy().equals(other.type.getClassHierarchy())) {
            Assertions.UNREACHABLE("different chas " + this + " " + other);
        }
        return this.type.equals(other.type);
    }

    public int hashCode() {
        return 39 * this.type.hashCode();
    }

    public boolean isArrayType() {
        return this.getType().isArrayClass();
    }

    public boolean isInterface() {
        return this.getType().isInterface();
    }

    public Iterator iterateImplementors() {
        return this.type.getClassHierarchy().getImplementors(this.getType().getReference()).iterator();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.type.getClassHierarchy();
    }
}

