/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;
import java.util.Map;

public class PrimitiveType
extends TypeAbstraction {
    private static final Map<TypeReference, PrimitiveType> refernceToType = HashMapFactory.make();
    public static final PrimitiveType BOOLEAN = PrimitiveType.makePrimitive(TypeReference.Boolean, 1);
    public static final PrimitiveType CHAR = PrimitiveType.makePrimitive(TypeReference.Char, 16);
    public static final PrimitiveType BYTE = PrimitiveType.makePrimitive(TypeReference.Byte, 8);
    public static final PrimitiveType SHORT = PrimitiveType.makePrimitive(TypeReference.Short, 16);
    public static final PrimitiveType INT = PrimitiveType.makePrimitive(TypeReference.Int, 32);
    public static final PrimitiveType LONG = PrimitiveType.makePrimitive(TypeReference.Long, 64);
    public static final PrimitiveType FLOAT = PrimitiveType.makePrimitive(TypeReference.Float, 32);
    public static final PrimitiveType DOUBLE = PrimitiveType.makePrimitive(TypeReference.Double, 64);
    private static final HashMap<String, String> primitiveNameMap = HashMapFactory.make(9);
    private final TypeReference reference;
    private final int size;

    static {
        primitiveNameMap.put("I", "int");
        primitiveNameMap.put("J", "long");
        primitiveNameMap.put("S", "short");
        primitiveNameMap.put("B", "byte");
        primitiveNameMap.put("C", "char");
        primitiveNameMap.put("D", "double");
        primitiveNameMap.put("F", "float");
        primitiveNameMap.put("Z", "boolean");
        primitiveNameMap.put("V", "void");
    }

    private PrimitiveType(TypeReference reference, int size) {
        this.reference = reference;
        this.size = size;
    }

    public TypeAbstraction meet(TypeAbstraction rhs) {
        if (rhs == TOP) {
            return this;
        }
        if (rhs == this) {
            return this;
        }
        if (rhs instanceof PrimitiveType) {
            if (this.size() < ((PrimitiveType)rhs).size()) {
                return this;
            }
            return rhs;
        }
        return TOP;
    }

    public int size() {
        return this.size;
    }

    public int hashCode() {
        return this.reference.hashCode();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public IClass getType() {
        return null;
    }

    public TypeReference getTypeReference() {
        return this.reference;
    }

    public static PrimitiveType getPrimitive(TypeReference reference) {
        return refernceToType.get(reference);
    }

    private static PrimitiveType makePrimitive(TypeReference reference, int size) {
        PrimitiveType newType = new PrimitiveType(reference, size);
        refernceToType.put(reference, newType);
        return newType;
    }

    public String toString() {
        String result = primitiveNameMap.get(this.reference.getName().toString());
        return result != null ? result : "PrimitiveType";
    }
}

