/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ReceiverTypeInference;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Map;

public class ReceiverTypeInferenceCache {
    private final AnalysisCache analysisCache;
    private final Map<CGNode, Object> typeInferenceMap = HashMapFactory.make();

    public ReceiverTypeInferenceCache(AnalysisCache cache) {
        this.analysisCache = cache;
    }

    public ReceiverTypeInference findOrCreate(CGNode n) {
        Object ref = this.typeInferenceMap.get(n);
        ReceiverTypeInference result = (ReceiverTypeInference)CacheReference.get(ref);
        try {
            if (result == null) {
                SSAOptions options = SSAOptions.defaultOptions();
                IR ir = this.analysisCache.getSSACache().findOrCreateIR(n.getMethod(), n.getContext(), options);
                TypeInference T = TypeInference.make(ir, false);
                result = new ReceiverTypeInference(T);
                ref = CacheReference.make(result);
                this.typeInferenceMap.put(n, ref);
            }
            return result;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

