/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.HashSet;
import java.util.Iterator;

public class SetType
extends TypeAbstraction {
    private final HashSet<TypeReference> types;
    private final int hashCode;

    public SetType(PointType[] points) {
        if (points == null) {
            throw new IllegalArgumentException("points is null");
        }
        Assertions._assert(points.length > 0);
        this.types = HashSetFactory.make(points.length);
        int h = 0;
        int i = 0;
        while (i < points.length) {
            TypeReference T = points[i].getType().getReference();
            h ^= T.hashCode();
            this.types.add(T);
            ++i;
        }
        this.hashCode = h;
    }

    public TypeReference getTypeReference() {
        Iterator<TypeReference> ti = this.types.iterator();
        TypeAbstraction T = (TypeAbstraction)((Object)ti.next());
        while (ti.hasNext()) {
            T = T.meet((TypeAbstraction)((Object)ti.next()));
        }
        return T.getTypeReference();
    }

    public TypeAbstraction meet(TypeAbstraction rhs) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetType) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            SetType other = (SetType)obj;
            return this.types.equals(other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Iterator iteratePoints() {
        return this.types.iterator();
    }
}

