/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInference
extends SSAInference<TypeVariable>
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    protected final IR ir;
    protected final IClassHierarchy cha;
    private static final AbstractOperator<TypeVariable> phiOp = new PhiOperator();
    private static final AbstractOperator<TypeVariable> primitivePropagateOp = new PrimitivePropagateOperator();
    protected final TypeAbstraction BOTTOM;
    private static final PiOperator piOp = new PiOperator();
    protected final boolean doPrimitives;
    private boolean solved = false;

    public static TypeInference make(IR ir, boolean doPrimitives) {
        return new TypeInference(ir, doPrimitives);
    }

    protected TypeInference(IR ir, boolean doPrimitives) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.cha = ir.getMethod().getDeclaringClass().getClassHierarchy();
        this.ir = ir;
        this.doPrimitives = doPrimitives;
        this.BOTTOM = new ConeType(this.cha.getRootClass());
        this.initialize();
        this.solve();
    }

    @Override
    public boolean solve() {
        if (this.solved) {
            return false;
        }
        boolean result = super.solve();
        this.solved = true;
        return result;
    }

    protected void initialize() {
        this.init(this.ir, new TypeVarFactory(), new TypeOperatorFactory());
    }

    @Override
    protected void initializeVariables() {
        int[] parameterValueNumbers = this.ir.getParameterValueNumbers();
        int i = 0;
        while (i < parameterValueNumbers.length) {
            TypeVariable v = (TypeVariable)this.getVariable(parameterValueNumbers[i]);
            TypeReference t = this.ir.getParameterType(i);
            if (t.isReferenceType()) {
                IClass klass = this.cha.lookupClass(t);
                if (klass != null) {
                    v.setType(new ConeType(klass));
                } else {
                    v.setType(this.BOTTOM);
                }
            } else if (this.doPrimitives) {
                v.setType(PrimitiveType.getPrimitive(t));
            }
            ++i;
        }
        SymbolTable st = this.ir.getSymbolTable();
        if (st != null) {
            int i2 = 0;
            while (i2 <= st.getMaxValueNumber()) {
                if (st.isConstant(i2)) {
                    TypeVariable v = (TypeVariable)this.getVariable(i2);
                    v.setType(this.getConstantType(i2));
                }
                ++i2;
            }
        }
        Iterator<SSAInstruction> it = this.ir.iterateNormalInstructions();
        while (it.hasNext()) {
            SSAInstruction s = it.next();
            if (!(s instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)s;
            TypeVariable v = (TypeVariable)this.getVariable(call.getException());
            Collection<TypeReference> defaultExceptions = call.getExceptionTypes();
            if (defaultExceptions.size() == 0) continue;
            Assertions._assert(defaultExceptions.size() == 1);
            TypeReference t = defaultExceptions.iterator().next();
            IClass klass = this.cha.lookupClass(t);
            Assertions._assert(klass != null);
            v.setType(new PointType(klass));
            IMethod m = this.cha.resolveMethod(call.getDeclaredTarget());
            if (m == null) continue;
            TypeReference[] x = null;
            try {
                x = m.getDeclaredExceptions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            if (x == null) continue;
            int i3 = 0;
            while (i3 < x.length) {
                TypeReference tx = x[i3];
                IClass tc = this.cha.lookupClass(tx);
                if (tc != null) {
                    v.setType(v.getType().meet(new ConeType(tc)));
                }
                ++i3;
            }
        }
    }

    @Override
    protected void initializeWorkList() {
        this.addAllStatementsToWorkList();
    }

    public IR getIR() {
        return this.ir;
    }

    public TypeAbstraction getType(int valueNumber) {
        if (valueNumber < 0) {
            throw new IllegalArgumentException("bad value number " + valueNumber);
        }
        if (this.getVariable(valueNumber) == null) {
            Assertions._assert(this.getVariable(valueNumber) != null, "null variable for value number " + valueNumber);
        }
        return ((TypeVariable)this.getVariable(valueNumber)).getType();
    }

    public TypeAbstraction getConstantType(int valueNumber) {
        if (this.ir.getSymbolTable().isStringConstant(valueNumber)) {
            return new PointType(this.cha.lookupClass(TypeReference.JavaLangString));
        }
        return this.getConstantPrimitiveType(valueNumber);
    }

    public TypeAbstraction getConstantPrimitiveType(int valueNumber) {
        SymbolTable st = this.ir.getSymbolTable();
        if (!st.isConstant(valueNumber)) {
            return TypeAbstraction.TOP;
        }
        if (st.isIntegerConstant(valueNumber)) {
            return PrimitiveType.INT;
        }
        if (st.isFloatConstant(valueNumber)) {
            return PrimitiveType.FLOAT;
        }
        if (st.isDoubleConstant(valueNumber)) {
            return PrimitiveType.DOUBLE;
        }
        return TypeAbstraction.TOP;
    }

    public boolean isUndefined(int valueNumber) {
        if (this.getVariable(valueNumber) == null) {
            return true;
        }
        TypeAbstraction ta = ((TypeVariable)this.getVariable(valueNumber)).getType();
        return ta == this.BOTTOM || ta.getType() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class DeclaredTypeOperator
    extends NullaryOperator<TypeVariable> {
        private final TypeAbstraction type;

        public DeclaredTypeOperator(TypeAbstraction type) {
            this.type = type;
        }

        @Override
        public byte evaluate(TypeVariable lhs) {
            if (lhs.type.equals(this.type)) {
                return 2;
            }
            lhs.setType(this.type);
            return 3;
        }

        @Override
        public String toString() {
            return "delared type := " + this.type;
        }

        public boolean isNullary() {
            return true;
        }

        @Override
        public int hashCode() {
            return 9931 * this.type.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DeclaredTypeOperator) {
                DeclaredTypeOperator d = (DeclaredTypeOperator)o;
                return this.type.equals(d.type);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetElementType
    extends AbstractOperator<TypeVariable> {
        private final SSAArrayLoadInstruction load;

        GetElementType(SSAArrayLoadInstruction load) {
            this.load = load;
        }

        @Override
        public byte evaluate(TypeVariable lhs, IVariable[] rhs) {
            TypeAbstraction arrayType = TypeInference.this.getType(this.load.getArrayRef());
            if (arrayType.equals(TypeAbstraction.TOP)) {
                return 0;
            }
            TypeReference elementType = null;
            if (arrayType instanceof PointType) {
                elementType = ((PointType)arrayType).getType().getReference().getArrayElementType();
            } else if (arrayType instanceof ConeType) {
                elementType = ((ConeType)arrayType).getType().getReference().getArrayElementType();
            } else {
                Assertions.UNREACHABLE("Unexpected type " + arrayType.getClass());
            }
            if (elementType.isPrimitiveType()) {
                if (TypeInference.this.doPrimitives && lhs.getType() == TypeAbstraction.TOP) {
                    lhs.setType(PrimitiveType.getPrimitive(elementType));
                    return 1;
                }
                return 0;
            }
            if (lhs.getType() != TypeAbstraction.TOP) {
                TypeReference tType = null;
                if (lhs.getType() instanceof PointType) {
                    tType = ((PointType)lhs.getType()).getType().getReference();
                } else if (lhs.getType() instanceof ConeType) {
                    tType = ((ConeType)lhs.getType()).getType().getReference();
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + lhs.getType().getClass());
                }
                if (tType.equals(elementType)) {
                    return 0;
                }
                IClass klass = TypeInference.this.cha.lookupClass(elementType);
                Assertions._assert(klass != null);
                lhs.setType(new ConeType(klass));
                return 1;
            }
            IClass klass = TypeInference.this.cha.lookupClass(elementType);
            if (klass != null) {
                lhs.setType(new ConeType(klass));
            } else {
                lhs.setType(TypeAbstraction.TOP);
            }
            return 1;
        }

        @Override
        public String toString() {
            return "getElementType " + this.load;
        }

        @Override
        public int hashCode() {
            return 9923 * this.load.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof GetElementType) {
                GetElementType other = (GetElementType)o;
                return this.load.equals(other.load);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PhiOperator
    extends AbstractOperator<TypeVariable> {
        private PhiOperator() {
        }

        @Override
        public byte evaluate(TypeVariable lhs, IVariable[] rhs) {
            TypeAbstraction lhsType = lhs.getType();
            TypeAbstraction meet = TypeAbstraction.TOP;
            int i = 0;
            while (i < rhs.length) {
                if (rhs[i] != null) {
                    TypeVariable r = (TypeVariable)rhs[i];
                    meet = meet.meet(r.getType());
                }
                ++i;
            }
            if (lhsType.equals(meet)) {
                return 0;
            }
            lhs.setType(meet);
            return 1;
        }

        @Override
        public String toString() {
            return "phi meet";
        }

        @Override
        public int hashCode() {
            return 9929;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PhiOperator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PiOperator
    extends AbstractOperator<TypeVariable> {
        private PiOperator() {
        }

        @Override
        public byte evaluate(TypeVariable lhs, IVariable[] rhsOperands) {
            TypeVariable rhs;
            TypeAbstraction rhsType;
            TypeAbstraction lhsType = lhs.getType();
            if (lhsType.equals(rhsType = (rhs = (TypeVariable)rhsOperands[0]).getType())) {
                return 0;
            }
            lhs.setType(rhsType);
            return 1;
        }

        @Override
        public String toString() {
            return "pi";
        }

        @Override
        public int hashCode() {
            return 129077;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PiOperator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PrimitivePropagateOperator
    extends AbstractOperator<TypeVariable> {
        protected PrimitivePropagateOperator() {
        }

        @Override
        public byte evaluate(TypeVariable lhs, IVariable[] rhs) {
            TypeAbstraction lhsType = lhs.getType();
            TypeAbstraction meet = TypeAbstraction.TOP;
            int i = 0;
            while (i < rhs.length) {
                if (rhs[i] != null) {
                    TypeVariable r = (TypeVariable)rhs[i];
                    meet = meet.meet(r.getType());
                }
                ++i;
            }
            if (lhsType.equals(meet)) {
                return 0;
            }
            lhs.setType(meet);
            return 1;
        }

        @Override
        public String toString() {
            return "propagate";
        }

        @Override
        public int hashCode() {
            return 99292;
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass().equals(this.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TypeOperatorFactory
    extends SSAInstruction.Visitor
    implements SSAInference.OperatorFactory<TypeVariable> {
        protected AbstractOperator<TypeVariable> result = null;

        protected TypeOperatorFactory() {
        }

        @Override
        public AbstractOperator<TypeVariable> get(SSAInstruction instruction) {
            instruction.visit(this);
            AbstractOperator<TypeVariable> temp = this.result;
            this.result = null;
            return temp;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.result = new GetElementType(instruction);
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.result = !TypeInference.this.doPrimitives ? null : new DeclaredTypeOperator(PrimitiveType.INT);
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            IClass klass;
            TypeReference type = instruction.getDeclaredFieldType();
            this.result = TypeInference.this.doPrimitives && type.isPrimitiveType() ? new DeclaredTypeOperator(PrimitiveType.getPrimitive(type)) : ((klass = TypeInference.this.cha.lookupClass(type)) == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(klass)));
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            IClass klass;
            TypeReference type = instruction.getDeclaredResultType();
            this.result = type.isReferenceType() ? ((klass = TypeInference.this.cha.lookupClass(type)) == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(klass))) : (TypeInference.this.doPrimitives && type.isPrimitiveType() ? new DeclaredTypeOperator(PrimitiveType.getPrimitive(type)) : null);
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            TypeReference type = instruction.getConcreteType();
            IClass klass = TypeInference.this.cha.lookupClass(type);
            this.result = klass == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new PointType(klass));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            TypeReference type = instruction.getDeclaredResultType();
            IClass klass = TypeInference.this.cha.lookupClass(type);
            this.result = klass == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(klass));
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(PrimitiveType.getPrimitive(instruction.getToType()));
            }
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(PrimitiveType.BOOLEAN);
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            TypeAbstraction type = this.meetDeclaredExceptionTypes(instruction);
            this.result = new DeclaredTypeOperator(type);
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            this.result = phiOp;
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            this.result = piOp;
        }

        private TypeAbstraction meetDeclaredExceptionTypes(SSAGetCaughtExceptionInstruction s) {
            SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)TypeInference.this.ir.getControlFlowGraph().getNode(s.getBasicBlockNumber());
            Iterator<TypeReference> it = bb.getCaughtExceptionTypes();
            TypeReference t = it.next();
            IClass klass = TypeInference.this.cha.lookupClass(t);
            TypeAbstraction result = null;
            result = klass == null ? TypeInference.this.BOTTOM : new ConeType(klass);
            while (it.hasNext()) {
                t = it.next();
                IClass tClass = TypeInference.this.cha.lookupClass(t);
                result = tClass == null ? TypeInference.this.BOTTOM : result.meet(new ConeType(tClass));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeVarFactory
    implements SSAInference.VariableFactory {
        @Override
        public IVariable makeVariable(int valueNumber) {
            SymbolTable st = TypeInference.this.ir.getSymbolTable();
            if (TypeInference.this.doPrimitives && st.isConstant(valueNumber) && st.isBooleanConstant(valueNumber)) {
                return new TypeVariable(PrimitiveType.BOOLEAN, 797 * valueNumber);
            }
            return new TypeVariable(TypeAbstraction.TOP, 797 * valueNumber);
        }
    }
}

