/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.util.CompoundIterator;
import com.ibm.wala.util.IteratorPlusOne;
import com.ibm.wala.util.IteratorPlusTwo;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.DelegatingNumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.FixedSizeBitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SimpleIntVector;
import com.ibm.wala.util.intset.SimpleVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCFG<T extends IBasicBlock>
implements ControlFlowGraph<T>,
Constants {
    private final IMethod method;
    private final DelegatingNumberedNodeManager<T> nodeManager = new DelegatingNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> normalEdgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, 2, 0);
    private final SparseNumberedEdgeManager<T> exceptionalEdgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, 0, 0);
    private final SimpleVector<SimpleIntVector> exceptionalSuccessors = new SimpleVector();
    private FixedSizeBitVector normalToExit;
    private FixedSizeBitVector exceptionalToExit;
    private FixedSizeBitVector fallThru;
    private final BitVector catchBlocks;
    private T exit;

    protected AbstractCFG(IMethod method) {
        this.method = method;
        this.catchBlocks = new BitVector(10);
    }

    protected void init() {
        this.normalToExit = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.exceptionalToExit = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.fallThru = new FixedSizeBitVector(this.getMaxNumber() + 1);
        this.exit = this.getNode(this.getMaxNumber());
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public T entry() {
        return (T)this.getNode(0);
    }

    @Override
    public T exit() {
        return this.exit;
    }

    @Override
    public int getPredNodeCount(T N) {
        boolean exceptionalIn;
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exit())) {
            FixedSizeBitVector x = FixedSizeBitVector.or(this.normalToExit, this.exceptionalToExit);
            return x.populationCount();
        }
        boolean normalIn = this.getNumberOfNormalIn(N) > 0;
        boolean bl = exceptionalIn = this.getNumberOfExceptionalIn(N) > 0;
        if (normalIn) {
            if (exceptionalIn) {
                return Iterator2Collection.toCollection(this.getPredNodes(N)).size();
            }
            return this.getNumberOfNormalIn(N);
        }
        return this.getNumberOfExceptionalIn(N);
    }

    public int getNumberOfNormalIn(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        Assertions._assert(!N.equals(this.exit()));
        int number = this.getNumber(N);
        int xtra = 0;
        if (number > 0 && this.fallThru.get(number - 1)) {
            ++xtra;
        }
        return this.normalEdgeManager.getPredNodeCount(N) + xtra;
    }

    public int getNumberOfExceptionalIn(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        Assertions._assert(!N.equals(this.exit()));
        return this.exceptionalEdgeManager.getPredNodeCount(N);
    }

    boolean hasAnyNormalOut(int number) {
        return this.fallThru.get(number) || this.normalEdgeManager.getSuccNodeCount(number) > 0 || this.normalToExit.get(number);
    }

    private int getNumberOfNormalOut(int number) {
        int xtra = 0;
        if (this.fallThru.get(number)) {
            ++xtra;
        }
        if (this.normalToExit.get(number)) {
            ++xtra;
        }
        return this.normalEdgeManager.getSuccNodeCount(number) + xtra;
    }

    public int getNumberOfExceptionalOut(int number) {
        int xtra = 0;
        if (this.exceptionalToExit.get(number)) {
            ++xtra;
        }
        return this.exceptionalEdgeManager.getSuccNodeCount(number) + xtra;
    }

    public int getNumberOfNormalOut(T N) {
        return this.getNumberOfNormalOut(this.getNumber(N));
    }

    public int getNumberOfExceptionalOut(T N) {
        return this.getNumberOfExceptionalOut(this.getNumber(N));
    }

    @Override
    public Iterator<T> getPredNodes(T N) {
        boolean exceptionalIn;
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exit())) {
            return new FilterIterator(this.iterator(), new Filter<T>(){

                @Override
                public boolean accepts(T o) {
                    int i = AbstractCFG.this.getNumber(o);
                    return AbstractCFG.this.normalToExit.get(i) || AbstractCFG.this.exceptionalToExit.get(i);
                }
            });
        }
        int number = this.getNumber(N);
        boolean normalIn = this.getNumberOfNormalIn(N) > 0;
        boolean bl = exceptionalIn = this.getNumberOfExceptionalIn(N) > 0;
        if (normalIn) {
            if (exceptionalIn) {
                HashSet result = HashSetFactory.make(this.getNumberOfNormalIn(N) + this.getNumberOfExceptionalIn(N));
                result.addAll(Iterator2Collection.toCollection(this.normalEdgeManager.getPredNodes(N)));
                result.addAll(Iterator2Collection.toCollection(this.exceptionalEdgeManager.getPredNodes(N)));
                if (this.fallThru.get(number - 1)) {
                    result.add(this.getNode(number - 1));
                }
                return result.iterator();
            }
            if (number > 0 && this.fallThru.get(number - 1)) {
                return IteratorPlusOne.make(this.normalEdgeManager.getPredNodes(N), this.getNode(number - 1));
            }
            return this.normalEdgeManager.getPredNodes(N);
        }
        if (exceptionalIn) {
            return this.exceptionalEdgeManager.getPredNodes(N);
        }
        return EmptyIterator.instance();
    }

    @Override
    public int getSuccNodeCount(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        if (N.equals(this.exit())) {
            return 0;
        }
        int nNormal = this.getNumberOfNormalOut(N);
        int nExc = this.getNumberOfExceptionalOut(N);
        if (nNormal > 0) {
            if (nExc > 0) {
                if (nExc == 1) {
                    int number = this.getNumber(N);
                    if (this.exceptionalToExit.get(number)) {
                        if (this.normalToExit.get(number)) {
                            return nNormal + nExc - 1;
                        }
                        return nNormal + nExc;
                    }
                    return this.slowCountSuccNodes(N);
                }
                return this.slowCountSuccNodes(N);
            }
            return nNormal;
        }
        return nExc;
    }

    private int slowCountSuccNodes(T N) {
        return Iterator2Collection.toCollection(this.getSuccNodes(N)).size();
    }

    @Override
    public Iterator<T> getSuccNodes(T N) {
        int number = this.getNumber(N);
        if (this.normalToExit.get(number) && this.exceptionalToExit.get(number)) {
            return new CompoundIterator<T>(this.iterateNormalSuccessorsWithoutExit(number), this.iterateExceptionalSuccessors(number));
        }
        return new CompoundIterator<T>(this.iterateNormalSuccessors(number), this.iterateExceptionalSuccessors(number));
    }

    private Iterator<T> iterateExceptionalSuccessors(int number) {
        if (this.exceptionalEdgeManager.hasAnySuccessor(number)) {
            ArrayList<Object> result = new ArrayList<Object>();
            SimpleIntVector v = this.exceptionalSuccessors.get(number);
            int i = 0;
            while (i <= v.getMaxIndex()) {
                result.add(this.getNode(v.get(i)));
                ++i;
            }
            if (this.exceptionalToExit.get(number)) {
                result.add(this.exit);
            }
            return result.iterator();
        }
        if (this.exceptionalToExit.get(number)) {
            return new NonNullSingletonIterator<T>(this.exit());
        }
        return EmptyIterator.instance();
    }

    Iterator<T> iterateExceptionalPredecessors(T N) {
        if (N.equals(this.exit())) {
            return new FilterIterator(this.iterator(), new Filter<T>(){

                @Override
                public boolean accepts(T o) {
                    int i = AbstractCFG.this.getNumber(o);
                    return AbstractCFG.this.exceptionalToExit.get(i);
                }
            });
        }
        return this.exceptionalEdgeManager.getPredNodes(N);
    }

    Iterator<T> iterateNormalPredecessors(T N) {
        if (N.equals(this.exit())) {
            return new FilterIterator(this.iterator(), new Filter<T>(){

                @Override
                public boolean accepts(T o) {
                    int i = AbstractCFG.this.getNumber(o);
                    return AbstractCFG.this.normalToExit.get(i);
                }
            });
        }
        int number = this.getNumber(N);
        if (number > 0 && this.fallThru.get(number - 1)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getPredNodes(N), this.getNode(number - 1));
        }
        return this.normalEdgeManager.getPredNodes(N);
    }

    private Iterator<T> iterateNormalSuccessors(int number) {
        if (this.fallThru.get(number)) {
            if (this.normalToExit.get(number)) {
                return new IteratorPlusTwo<Object>(this.normalEdgeManager.getSuccNodes(number), this.getNode(number + 1), this.exit());
            }
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(number), this.getNode(number + 1));
        }
        if (this.normalToExit.get(number)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(number), this.exit());
        }
        return this.normalEdgeManager.getSuccNodes(number);
    }

    private Iterator<T> iterateNormalSuccessorsWithoutExit(int number) {
        if (this.fallThru.get(number)) {
            return IteratorPlusOne.make(this.normalEdgeManager.getSuccNodes(number), this.getNode(number + 1));
        }
        return this.normalEdgeManager.getSuccNodes(number);
    }

    @Override
    public void addNode(T n) {
        this.nodeManager.addNode(n);
    }

    @Override
    public int getMaxNumber() {
        return this.nodeManager.getMaxNumber();
    }

    @Override
    public T getNode(int number) {
        return (T)((IBasicBlock)this.nodeManager.getNode(number));
    }

    @Override
    public int getNumber(T N) {
        return this.nodeManager.getNumber(N);
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeManager.getNumberOfNodes();
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodeManager.iterator();
    }

    @Override
    public void addEdge(T src, T dst) throws UnimplementedError {
        Assertions.UNREACHABLE("Don't call me .. use addNormalEdge or addExceptionalEdge");
    }

    @Override
    public void removeEdge(T src, T dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int x = this.getNumber(src);
        if (dst.equals(this.exit())) {
            return this.normalToExit.get(x) || this.exceptionalToExit.get(x);
        }
        if (this.getNumber(dst) == x + 1 && this.fallThru.get(x)) {
            return true;
        }
        return this.normalEdgeManager.hasEdge(src, dst) || this.exceptionalEdgeManager.hasEdge(src, dst);
    }

    public boolean hasExceptionalEdge(T src, T dst) {
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int x = this.getNumber(src);
        if (dst.equals(this.exit())) {
            return this.exceptionalToExit.get(x);
        }
        return this.exceptionalEdgeManager.hasEdge(src, dst);
    }

    public boolean hasNormalEdge(T src, T dst) {
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        int x = this.getNumber(src);
        if (dst.equals(this.exit())) {
            return this.normalToExit.get(x);
        }
        if (this.getNumber(dst) == x + 1 && this.fallThru.get(x)) {
            return true;
        }
        return this.normalEdgeManager.hasEdge(src, dst);
    }

    public void addNormalEdge(T src, T dst) {
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (dst.equals(this.exit())) {
            this.normalToExit.set(this.getNumber(src));
        } else if (this.getNumber(dst) == this.getNumber(src) + 1) {
            this.fallThru.set(this.getNumber(src));
        } else {
            this.normalEdgeManager.addEdge(src, dst);
        }
    }

    public void addExceptionalEdge(T src, T dst) {
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (dst.equals(this.exit())) {
            this.exceptionalToExit.set(this.getNumber(src));
        } else {
            this.exceptionalEdgeManager.addEdge(src, dst);
            SimpleIntVector v = this.exceptionalSuccessors.get(this.getNumber(src));
            if (v == null) {
                v = new SimpleIntVector(-1);
                this.exceptionalSuccessors.set(this.getNumber(src), v);
                v.set(0, this.getNumber(dst));
                return;
            }
            if (v.get(v.getMaxIndex()) != this.getNumber(dst)) {
                v.set(v.getMaxIndex() + 1, this.getNumber(dst));
            }
        }
    }

    @Override
    public void removeNodeAndEdges(T N) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeNode(T n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean containsNode(T N) {
        return this.nodeManager.containsNode(N);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (IBasicBlock bb : this) {
            s.append("BB").append(this.getNumber((T)bb)).append("\n");
            Iterator<IBasicBlock> succNodes = this.getSuccNodes((T)bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber((T)succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    protected void setCatchBlock(int i) {
        this.catchBlocks.set(i);
    }

    public boolean isCatchBlock(int i) {
        return this.catchBlocks.get(i);
    }

    @Override
    public BitVector getCatchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    @Override
    public void removeAllIncidentEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public List<T> getExceptionalSuccessors(T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        ArrayList<IBasicBlock> result = new ArrayList<IBasicBlock>();
        Iterator<T> it = this.iterateExceptionalSuccessors(b.getNumber());
        while (it.hasNext()) {
            result.add((IBasicBlock)it.next());
        }
        return result;
    }

    @Override
    public Collection<T> getNormalSuccessors(T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toCollection(this.iterateNormalSuccessors(b.getNumber()));
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, this);
    }

    @Override
    public void removeIncomingEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    public FixedSizeBitVector getExceptionalToExit() {
        return this.exceptionalToExit;
    }

    public FixedSizeBitVector getNormalToExit() {
        return this.normalToExit;
    }

    @Override
    public Collection<T> getExceptionalPredecessors(T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toCollection(this.iterateExceptionalPredecessors(b));
    }

    @Override
    public Collection<T> getNormalPredecessors(T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Iterator2Collection.toCollection(this.iterateNormalPredecessors(b));
    }

    @Override
    public IntSet getPredNodeNumbers(T node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) {
        int number = this.getNumber(node);
        IntSet s = this.normalEdgeManager.getSuccNodeNumbers(node);
        MutableSparseIntSet result = s == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make(s);
        s = this.exceptionalEdgeManager.getSuccNodeNumbers(node);
        if (s != null) {
            result.addAll(s);
        }
        if (this.normalToExit.get(number) || this.exceptionalToExit.get(number)) {
            result.add(this.exit.getNumber());
        }
        if (this.fallThru.get(number)) {
            result.add(number + 1);
        }
        return result;
    }
}

