/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGCache {
    private static final int RESET_INTERVAL = 10000;
    private HashMap<Object, Object> dictionary = HashMapFactory.make();
    private int resetCount = 0;
    private final IRFactory<IMethod> factory;

    public CFGCache(IRFactory<IMethod> factory) {
        this.factory = factory;
    }

    public synchronized ControlFlowGraph findOrCreate(IMethod m, Context C) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        this.processResetLogic();
        Pair<IMethod, Context> p = Pair.make(m, C);
        Object ref = this.dictionary.get(p);
        if (ref == null || CacheReference.get(ref) == null) {
            ControlFlowGraph cfg = this.factory.makeCFG(m, C);
            ref = CacheReference.make(cfg);
            this.dictionary.put(p, ref);
            return cfg;
        }
        ControlFlowGraph cfg = (ControlFlowGraph)CacheReference.get(ref);
        return cfg == null ? this.findOrCreate(m, C) : cfg;
    }

    private void processResetLogic() {
        ++this.resetCount;
        if (this.resetCount == 10000) {
            this.reset();
        }
    }

    public void wipe() {
        this.dictionary = HashMapFactory.make();
    }

    private void reset() {
        this.resetCount = 0;
        HashMap<Object, Object> oldDictionary = this.dictionary;
        this.dictionary = HashMapFactory.make();
        for (Map.Entry e : oldDictionary.entrySet()) {
            Object key = e.getKey();
            Object val = e.getValue();
            if (CacheReference.get(val) == null) continue;
            this.dictionary.put(key, val);
        }
    }

    public void invalidate(IMethod method, Context C) {
        this.dictionary.remove(Pair.make(method, C));
    }
}

