/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InducedCFG
extends AbstractCFG<BasicBlock> {
    private static final boolean DEBUG = false;
    private final BasicBlock[] i2block;
    private final Context context;
    private final IInstruction[] instructions;

    public InducedCFG(SSAInstruction[] instructions, IMethod method, Context context) {
        super(method);
        if (instructions == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        this.context = context;
        this.instructions = instructions;
        this.i2block = new BasicBlock[instructions.length];
        if (instructions.length == 0) {
            this.makeEmptyBlocks();
        } else {
            this.makeBasicBlocks();
        }
        this.init();
        this.computeEdges();
    }

    @Override
    public int hashCode() {
        return this.context.hashCode() ^ this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof InducedCFG && this.getMethod().equals(((InducedCFG)o).getMethod()) && this.context.equals(((InducedCFG)o).context);
    }

    @Override
    public IInstruction[] getInstructions() {
        return this.instructions;
    }

    private void computeEdges() {
        for (BasicBlock b : this) {
            if (b.equals(this.exit())) continue;
            b.computeOutgoingEdges();
        }
    }

    private void makeEmptyBlocks() {
        BasicBlock b = new BasicBlock(-1);
        this.addNode(b);
    }

    protected BranchVisitor makeBranchVisitor(boolean[] r) {
        return new BranchVisitor(r);
    }

    protected PEIVisitor makePEIVisitor(boolean[] r) {
        return new PEIVisitor(r);
    }

    private void makeBasicBlocks() {
        SSAInstruction[] instructions = (SSAInstruction[])this.getInstructions();
        boolean[] r = new boolean[instructions.length];
        r[0] = true;
        BranchVisitor branchVisitor = this.makeBranchVisitor(r);
        PEIVisitor peiVisitor = this.makePEIVisitor(r);
        int i = 0;
        while (i < instructions.length) {
            if (instructions[i] != null) {
                branchVisitor.setIndex(i);
                instructions[i].visit(branchVisitor);
                peiVisitor.setIndex(i);
                instructions[i].visit(peiVisitor);
            }
            ++i;
        }
        BasicBlock b = null;
        int i2 = 0;
        while (i2 < r.length) {
            if (r[i2]) {
                b = new BasicBlock(i2);
                this.addNode(b);
            }
            this.i2block[i2] = b;
            ++i2;
        }
        BasicBlock exit = new BasicBlock(-1);
        this.addNode(exit);
    }

    @Override
    public BasicBlock getBlockForInstruction(int index) {
        if (this.i2block[index] == null) {
            Assertions.productionAssertion(false, "unexpected null for " + index);
        }
        return this.i2block[index];
    }

    public Set getExceptionHandlers() {
        return Collections.EMPTY_SET;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (BasicBlock bb : this) {
            s.append("BB").append(this.getNumber(bb)).append("\n");
            int j = bb.getFirstInstructionIndex();
            while (j <= bb.getLastInstructionIndex()) {
                s.append("  ").append(j).append("  ").append(this.getInstructions()[j]).append("\n");
                ++j;
            }
            Iterator<BasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber(succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    @Override
    public int getProgramCounter(int index) {
        if (this.getInstructions()[index] instanceof SSAInvokeInstruction) {
            return ((SSAInvokeInstruction)this.getInstructions()[index]).getCallSite().getProgramCounter();
        }
        return index;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock {
        private final int start;

        public boolean equals(Object arg0) {
            if (this.getClass().equals(arg0.getClass())) {
                BasicBlock other = (BasicBlock)arg0;
                return this.start == other.start && this.getMethod().equals(other.getMethod());
            }
            return false;
        }

        BasicBlock(int start) {
            this.start = start;
        }

        private void addExceptionalEdges(SSAInstruction last) {
            if (last.isPEI()) {
                this.addExceptionalEdgeTo((BasicBlock)InducedCFG.this.exit());
            }
        }

        private void addNormalEdgeTo(BasicBlock b) {
            InducedCFG.this.addNormalEdge(this, b);
        }

        private void addExceptionalEdgeTo(BasicBlock b) {
            InducedCFG.this.addExceptionalEdge(this, b);
        }

        private void computeOutgoingEdges() {
            SSAInstruction last = (SSAInstruction)InducedCFG.this.getInstructions()[this.getLastInstructionIndex()];
            this.addExceptionalEdges(last);
            this.addNormalEdgeTo((BasicBlock)InducedCFG.this.getNode(this.getGraphNodeId() + 1));
            if (last instanceof SSAReturnInstruction) {
                BasicBlock exit = (BasicBlock)InducedCFG.this.exit();
                this.addNormalEdgeTo(exit);
            }
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.start;
        }

        @Override
        public int getLastInstructionIndex() {
            int exitNumber = InducedCFG.this.getNumber((BasicBlock)InducedCFG.this.exit());
            if (this.getGraphNodeId() == exitNumber) {
                return -2;
            }
            if (this.getGraphNodeId() == exitNumber - 1) {
                return InducedCFG.this.getInstructions().length - 1;
            }
            BasicBlock next = (BasicBlock)InducedCFG.this.getNode(this.getGraphNodeId() + 1);
            return next.getFirstInstructionIndex() - 1;
        }

        @Override
        public boolean isCatchBlock() {
            return false;
        }

        public int hashCode() {
            return 1153 * this.getGraphNodeId() + this.getMethod().hashCode();
        }

        public String toString() {
            return "BB[Induced]" + this.getNumber() + " - " + this.getMethod().getSignature();
        }

        @Override
        public boolean isExitBlock() {
            return this.getLastInstructionIndex() == -2;
        }

        @Override
        public boolean isEntryBlock() {
            return this.getNumber() == 0;
        }

        @Override
        public IMethod getMethod() {
            return InducedCFG.this.getMethod();
        }

        public boolean endsInPEI() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()].isPEI();
        }

        public boolean endsInReturn() {
            return InducedCFG.this.getInstructions()[this.getLastInstructionIndex()] instanceof SSAReturnInstruction;
        }

        @Override
        public int getNumber() {
            return InducedCFG.this.getNumber(this);
        }

        @Override
        public Iterator<IInstruction> iterator() {
            return new ArrayIterator<IInstruction>(InducedCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }

    public class BranchVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected BranchVisitor(boolean[] r) {
            this.r = r;
        }

        void setIndex(int i) {
            this.index = i;
        }

        public void visitGoto(SSAGotoInstruction instruction) {
            Assertions.UNREACHABLE("haven't implemented logic for goto yet.");
            this.breakBasicBlock();
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            Assertions.UNREACHABLE("haven't implemented logic for cbranch yet.");
            this.breakBasicBlock();
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
            Assertions.UNREACHABLE("haven't implemented logic for switch yet.");
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitThrow(SSAThrowInstruction instruction) {
            this.breakBasicBlock();
        }

        protected void breakBasicBlock() {
            if (this.index + 1 < InducedCFG.this.getInstructions().length && !this.r[this.index + 1]) {
                this.r[this.index + 1] = true;
            }
        }
    }

    public class PEIVisitor
    extends SSAInstruction.Visitor {
        private final boolean[] r;
        int index = 0;

        protected PEIVisitor(boolean[] r) {
            this.r = r;
        }

        void setIndex(int i) {
            this.index = i;
        }

        protected void breakBasicBlock() {
            if (this.index + 1 < InducedCFG.this.getInstructions().length && !this.r[this.index + 1]) {
                this.r[this.index + 1] = true;
            }
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitMonitor(SSAMonitorInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitNew(SSANewInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitPut(SSAPutInstruction instruction) {
            this.breakBasicBlock();
        }

        public void visitThrow(SSAThrowInstruction instruction) {
            this.breakBasicBlock();
        }
    }
}

