/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.ShrikeUtil;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrikeCFG
extends AbstractCFG<BasicBlock> {
    private static final boolean DEBUG = false;
    private int[] instruction2Block;
    private final ShrikeCTMethod method;
    private final int hashBase;
    private final Set<ExceptionHandler> exceptionHandlers = HashSetFactory.make(10);

    public ShrikeCFG(ShrikeCTMethod method) throws IllegalArgumentException {
        super(method);
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        this.method = method;
        this.hashBase = method.hashCode() * 9967;
        this.makeBasicBlocks();
        this.init();
        this.computeI2BMapping();
        this.computeEdges();
    }

    @Override
    public int hashCode() {
        return 9511 * this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ShrikeCFG && this.getMethod().equals(((ShrikeCFG)o).getMethod());
    }

    @Override
    public IInstruction[] getInstructions() {
        try {
            return this.method.getInstructions();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    private void computeI2BMapping() {
        this.instruction2Block = new int[this.getInstructions().length];
        for (BasicBlock b : this) {
            int j = b.getFirstInstructionIndex();
            while (j <= b.getLastInstructionIndex()) {
                this.instruction2Block[j] = this.getNumber(b);
                ++j;
            }
        }
    }

    private void computeEdges() {
        for (BasicBlock b : this) {
            if (b.equals(this.exit())) continue;
            if (b.equals(this.entry())) {
                this.addNormalEdge(b, this.getBlockForInstruction(0));
                continue;
            }
            b.computeOutgoingEdges();
        }
    }

    private void makeBasicBlocks() {
        ExceptionHandler[][] handlers;
        try {
            handlers = this.method.getHandlers();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            handlers = null;
        }
        boolean[] r = new boolean[this.getInstructions().length];
        boolean[] catchers = new boolean[this.getInstructions().length];
        int blockCount = 2;
        r[0] = true;
        Instruction[] instructions = (Instruction[])this.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            int[] targets = instructions[i].getBranchTargets();
            if (!(targets.length <= 0 && instructions[i].isFallThrough() || i + 1 >= instructions.length || r[i + 1])) {
                r[i + 1] = true;
                ++blockCount;
            }
            int j = 0;
            while (j < targets.length) {
                if (!r[targets[j]]) {
                    r[targets[j]] = true;
                    ++blockCount;
                }
                ++j;
            }
            if (Exceptions.isPEI(instructions[i])) {
                ExceptionHandler[] hs = handlers[i];
                if (i + 1 < instructions.length && !r[i + 1]) {
                    r[i + 1] = true;
                    ++blockCount;
                }
                if (hs != null && hs.length > 0) {
                    int j2 = 0;
                    while (j2 < hs.length) {
                        this.exceptionHandlers.add(hs[j2]);
                        if (!r[hs[j2].getHandler()]) {
                            r[hs[j2].getHandler()] = true;
                            ++blockCount;
                        }
                        catchers[hs[j2].getHandler()] = true;
                        ++j2;
                    }
                }
            }
            ++i;
        }
        BasicBlock entry = new BasicBlock(-1);
        this.addNode(entry);
        int j = 1;
        int i2 = 0;
        while (i2 < r.length) {
            if (r[i2]) {
                BasicBlock b = new BasicBlock(i2);
                this.addNode(b);
                if (catchers[i2]) {
                    this.setCatchBlock(j);
                }
                ++j;
            }
            ++i2;
        }
        BasicBlock exit = new BasicBlock(-1);
        this.addNode(exit);
    }

    @Override
    public BasicBlock getBlockForInstruction(int index) {
        return (BasicBlock)this.getNode(this.instruction2Block[index]);
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (BasicBlock bb : this) {
            s.append("BB").append(this.getNumber(bb)).append("\n");
            int j = bb.getFirstInstructionIndex();
            while (j <= bb.getLastInstructionIndex()) {
                s.append("  ").append(j).append("  ").append(this.getInstructions()[j]).append("\n");
                ++j;
            }
            Iterator<BasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(this.getNumber(succNodes.next())).append("\n");
            }
        }
        return s.toString();
    }

    public int getMaxStackHeight() {
        return this.method.getMaxStackHeight();
    }

    public int getMaxLocals() {
        return this.method.getMaxLocals();
    }

    public Set<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public int getProgramCounter(int index) {
        try {
            return this.method.getBytecodeIndex(index);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock {
        private final int startIndex;

        public BasicBlock(int startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public boolean isCatchBlock() {
            return ShrikeCFG.this.isCatchBlock(this.getNumber());
        }

        private void computeOutgoingEdges() {
            Instruction last = (Instruction)ShrikeCFG.this.getInstructions()[this.getLastInstructionIndex()];
            int[] targets = last.getBranchTargets();
            int i = 0;
            while (i < targets.length) {
                BasicBlock b = ShrikeCFG.this.getBlockForInstruction(targets[i]);
                this.addNormalEdgeTo(b);
                ++i;
            }
            this.addExceptionalEdges(last);
            if (last.isFallThrough()) {
                BasicBlock next = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + 1);
                this.addNormalEdgeTo(next);
            }
            if (last instanceof ReturnInstruction) {
                BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                this.addNormalEdgeTo(exit);
            }
        }

        private void addExceptionalEdges(Instruction last) {
            IClassHierarchy cha = this.getMethod().getClassHierarchy();
            if (Exceptions.isPEI(last)) {
                Collection<TypeReference> exceptionTypes = null;
                boolean goToAllHandlers = false;
                ExceptionHandler[] hs = this.getExceptionHandlers();
                if (last.getOpcode() == 191) {
                    goToAllHandlers = true;
                } else if (hs != null && hs.length > 0) {
                    exceptionTypes = Exceptions.getExceptionTypes(this.getMethod().getDeclaringClass().getReference().getClassLoader(), last, cha);
                }
                if (hs != null && hs.length > 0) {
                    if (!goToAllHandlers) {
                        exceptionTypes = HashSetFactory.make(exceptionTypes);
                    }
                    int j = 0;
                    while (j < hs.length) {
                        BasicBlock b = ShrikeCFG.this.getBlockForInstruction(hs[j].getHandler());
                        if (goToAllHandlers) {
                            this.addExceptionalEdgeTo(b);
                        } else {
                            ClassLoaderReference loader;
                            IClass caughtClass;
                            TypeReference caughtException = null;
                            if (hs[j].getCatchClass() != null && (caughtClass = cha.lookupClass(caughtException = ShrikeUtil.makeTypeReference(loader = ShrikeCFG.this.getMethod().getDeclaringClass().getReference().getClassLoader(), hs[j].getCatchClass()))) == null) {
                                this.addExceptionalEdgeTo(b);
                                Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                caughtException = null;
                            }
                            if (caughtException == null) {
                                this.addExceptionalEdgeTo(b);
                                exceptionTypes.clear();
                            } else {
                                HashSet caught = HashSetFactory.make(exceptionTypes.size());
                                for (TypeReference t : exceptionTypes) {
                                    if (t == null) continue;
                                    IClass klass = cha.lookupClass(t);
                                    if (klass == null) {
                                        Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                        this.addExceptionalEdgeTo(b);
                                        continue;
                                    }
                                    IClass caughtClass2 = cha.lookupClass(caughtException);
                                    if (!cha.isSubclassOf(klass, caughtClass2) && !cha.isSubclassOf(caughtClass2, klass)) continue;
                                    this.addExceptionalEdgeTo(b);
                                    if (!cha.isSubclassOf(klass, caughtClass2)) continue;
                                    caught.add(t);
                                }
                                exceptionTypes.removeAll(caught);
                            }
                        }
                        ++j;
                    }
                    if (exceptionTypes == null || !exceptionTypes.isEmpty()) {
                        BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                        this.addExceptionalEdgeTo(exit);
                    }
                } else {
                    BasicBlock exit = (BasicBlock)ShrikeCFG.this.exit();
                    this.addExceptionalEdgeTo(exit);
                }
            }
        }

        private ExceptionHandler[] getExceptionHandlers() {
            ExceptionHandler[][] handlers;
            try {
                handlers = ShrikeCFG.this.method.getHandlers();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                handlers = null;
            }
            ExceptionHandler[] hs = handlers[this.getLastInstructionIndex()];
            return hs;
        }

        private void addNormalEdgeTo(BasicBlock b) {
            ShrikeCFG.this.addNormalEdge(this, b);
        }

        private void addExceptionalEdgeTo(BasicBlock b) {
            ShrikeCFG.this.addExceptionalEdge(this, b);
        }

        @Override
        public int getLastInstructionIndex() {
            if (this == ShrikeCFG.this.entry() || this == ShrikeCFG.this.exit()) {
                return -2;
            }
            if (this.getNumber() == ShrikeCFG.this.getMaxNumber() - 1) {
                return ShrikeCFG.this.getInstructions().length - 1;
            }
            BasicBlock next = (BasicBlock)ShrikeCFG.this.getNode(this.getNumber() + 1);
            return next.getFirstInstructionIndex() - 1;
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.startIndex;
        }

        public String toString() {
            return "BB[Shrike]" + this.getNumber() + " - " + ShrikeCFG.this.method.getDeclaringClass().getReference().getName() + "." + ShrikeCFG.this.method.getName();
        }

        @Override
        public boolean isExitBlock() {
            return this == ShrikeCFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == ShrikeCFG.this.entry();
        }

        @Override
        public IMethod getMethod() {
            return ShrikeCFG.this.getMethod();
        }

        public int hashCode() {
            return ShrikeCFG.this.hashBase + this.getNumber();
        }

        public boolean equals(Object o) {
            return o instanceof BasicBlock && ((BasicBlock)o).getMethod().equals(this.getMethod()) && ((BasicBlock)o).getNumber() == this.getNumber();
        }

        @Override
        public int getNumber() {
            return this.getGraphNodeId();
        }

        @Override
        public Iterator<IInstruction> iterator() {
            return new ArrayIterator<IInstruction>(ShrikeCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }

    private static class FailedExceptionResolutionWarning
    extends Warning {
        final TypeReference T;

        FailedExceptionResolutionWarning(TypeReference T) {
            super((byte)1);
            this.T = T;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T;
        }

        public static FailedExceptionResolutionWarning create(TypeReference T) {
            return new FailedExceptionResolutionWarning(T);
        }
    }
}

