/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.cdg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.DominanceFrontiers;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.impl.GraphInverter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDependenceGraph<T extends IBasicBlock>
extends AbstractNumberedGraph<T> {
    private final ControlFlowGraph<T> cfg;
    private final EdgeManager<T> edgeManager;
    private Map<Pair, Set<Object>> edgeLabels;

    private Map<T, Set<T>> buildControlDependence(boolean wantEdgeLabels) {
        Map controlDependence = HashMapFactory.make(this.cfg.getNumberOfNodes());
        DominanceFrontiers<IBasicBlock> RDF = new DominanceFrontiers<IBasicBlock>((Graph<IBasicBlock>)GraphInverter.invert(this.cfg), (IBasicBlock)this.cfg.exit());
        if (wantEdgeLabels) {
            this.edgeLabels = HashMapFactory.make();
        }
        Iterator ns = this.cfg.iterator();
        while (ns.hasNext()) {
            HashSet s = HashSetFactory.make(2);
            controlDependence.put((IBasicBlock)ns.next(), s);
        }
        for (IBasicBlock y : this.cfg) {
            Iterator<IBasicBlock> ns2 = RDF.getDominanceFrontier(y);
            while (ns2.hasNext()) {
                IBasicBlock x = ns2.next();
                ((Set)controlDependence.get(x)).add(y);
                if (!wantEdgeLabels) continue;
                Set labels = HashSetFactory.make();
                this.edgeLabels.put(Pair.make(x, y), labels);
                Iterator<IBasicBlock> ss = this.cfg.getSuccNodes(x);
                while (ss.hasNext()) {
                    IBasicBlock s = ss.next();
                    if (!RDF.isDominatedBy(s, y)) continue;
                    labels.add(s);
                }
            }
        }
        return controlDependence;
    }

    private EdgeManager<T> constructGraphEdges(final Map<T, Set<T>> forwardEdges) {
        return new EdgeManager<T>(){
            Map<T, Set<T>> backwardEdges;
            {
                this.backwardEdges = HashMapFactory.make(map.size());
                Iterator x = ControlDependenceGraph.this.cfg.iterator();
                while (x.hasNext()) {
                    Set s = HashSetFactory.make();
                    this.backwardEdges.put((IBasicBlock)x.next(), s);
                }
                for (IBasicBlock p : map.keySet()) {
                    for (Object n : (Set)map.get(p)) {
                        this.backwardEdges.get(n).add(p);
                    }
                }
            }

            @Override
            public Iterator<T> getPredNodes(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public int getPredNodeCount(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).size();
                }
                return 0;
            }

            @Override
            public Iterator<T> getSuccNodes(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public int getSuccNodeCount(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).size();
                }
                return 0;
            }

            @Override
            public boolean hasEdge(T src, T dst) {
                return forwardEdges.containsKey(src) && ((Set)forwardEdges.get(src)).contains(dst);
            }

            @Override
            public void addEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAllIncidentEdges(T node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeIncomingEdges(T node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeOutgoingEdges(T node) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (IBasicBlock n : this) {
            sb.append(n.toString()).append("\n");
            Iterator<IBasicBlock> ss = this.getSuccNodes(n);
            while (ss.hasNext()) {
                IBasicBlock s = ss.next();
                sb.append("  --> ").append(s);
                if (this.edgeLabels != null) {
                    Iterator<Object> labels = this.edgeLabels.get(Pair.make(n, s)).iterator();
                    while (labels.hasNext()) {
                        sb.append("\n   label: ").append(labels.next());
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public ControlDependenceGraph(ControlFlowGraph<T> cfg, boolean wantEdgeLabels) {
        this.cfg = cfg;
        this.edgeManager = this.constructGraphEdges(this.buildControlDependence(wantEdgeLabels));
    }

    public ControlDependenceGraph(ControlFlowGraph<T> cfg) {
        this(cfg, false);
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.cfg;
    }

    public Set<Object> getEdgeLabels(Object from, Object to) {
        return this.edgeLabels.get(Pair.make(from, to));
    }

    @Override
    public NodeManager<T> getNodeManager() {
        return this.cfg;
    }

    @Override
    public EdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public boolean controlEquivalent(T bb1, T bb2) {
        if (this.getPredNodeCount(bb1) != this.getPredNodeCount(bb2)) {
            return false;
        }
        Iterator<T> pbs1 = this.getPredNodes(bb1);
        while (pbs1.hasNext()) {
            if (this.hasEdge((IBasicBlock)pbs1.next(), bb2)) continue;
            return false;
        }
        return true;
    }
}

