/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayClass
implements IClass,
Constants {
    private final IClassHierarchy cha;
    private final TypeReference type;
    private final IClassLoader loader;

    ArrayClass(TypeReference type, IClassLoader loader, IClassHierarchy cha) {
        this.type = type;
        this.loader = loader;
        this.cha = cha;
        TypeReference elementType = type.getInnermostElementType();
        if (!elementType.isPrimitiveType()) {
            IClass klass = loader.lookupClass(elementType.getName());
            if (klass == null) {
                Assertions.UNREACHABLE("caller should not attempt to create an array with type " + type);
            }
        } else {
            Assertions._assert(loader.getReference().equals(ClassLoaderReference.Primordial));
        }
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    public String getQualifiedNameForReflection() {
        return this.type.getName().toString();
    }

    @Override
    public IClass getSuperclass() {
        try {
            IClass elt = this.getElementClass();
            Assertions._assert(this.getReference().getArrayElementType().isPrimitiveType() || elt != null);
            if (elt == null || elt.getReference() == TypeReference.JavaLangObject) {
                return this.loader.lookupClass(TypeReference.JavaLangObject.getName());
            }
            TypeReference eltSuperRef = elt.getSuperclass().getReference();
            TypeReference superRef = TypeReference.findOrCreateArrayOf(eltSuperRef);
            return elt.getSuperclass().getClassLoader().lookupClass(superRef.getName());
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public IMethod getMethod(Selector sig) {
        return this.loader.lookupClass(TypeReference.JavaLangObject.getName()).getMethod(sig);
    }

    @Override
    public IField getField(Atom name) {
        return this.getSuperclass().getField(name);
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        return Collections.emptySet();
    }

    public int getNumberOfDeclaredMethods() {
        return 0;
    }

    @Override
    public TypeReference getReference() {
        return this.type;
    }

    @Override
    public String getSourceFileName() {
        return null;
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    @Override
    public boolean isArrayClass() {
        return true;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public IClass getElementClass() {
        TypeReference elementType = this.getReference().getArrayElementType();
        if (elementType.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(elementType.getName());
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        HashSet<IClass> result = HashSetFactory.make(2);
        result.add(this.loader.lookupClass(TypeReference.array_interfaces[0]));
        result.add(this.loader.lookupClass(TypeReference.array_interfaces[1]));
        return result;
    }

    public Collection<IClass> getAllAncestorInterfaces() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    public int getDimensionality() {
        return this.getReference().getDimensionality();
    }

    public IClass getInnermostElementClass() {
        TypeReference elementType = this.getReference().getInnermostElementType();
        if (elementType.isPrimitiveType()) {
            return null;
        }
        return this.loader.lookupClass(elementType.getName());
    }

    @Override
    public Collection<IClass> getDirectInterfaces() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayClass) {
            ArrayClass other = (ArrayClass)obj;
            return this.loader.equals(other.loader) && this.type.equals(other.type);
        }
        return false;
    }

    @Override
    public Collection<IField> getAllInstanceFields() throws UnimplementedError, ClassHierarchyException {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IField> getAllStaticFields() throws UnimplementedError, ClassHierarchyException {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IMethod> getAllMethods() throws UnimplementedError, ClassHierarchyException {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public Collection<IField> getAllFields() throws UnimplementedError, ClassHierarchyException {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

