/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;

public class ArrayClassLoader {
    private static final boolean DEBUG = false;
    private final HashMap<TypeReference, ArrayClass> arrayClasses = HashMapFactory.make();

    public IClass lookupClass(TypeName className, IClassLoader delegator, IClassHierarchy cha) throws IllegalArgumentException {
        ArrayClass arrayClass;
        if (delegator == null) {
            throw new IllegalArgumentException("delegator must not be null");
        }
        TypeReference type = TypeReference.findOrCreate(delegator.getReference(), className);
        TypeReference elementType = type.getArrayElementType();
        if (elementType.isPrimitiveType()) {
            TypeReference aRef = TypeReference.findOrCreateArrayOf(elementType);
            arrayClass = this.arrayClasses.get(aRef);
            IClassLoader primordial = ArrayClassLoader.getRootClassLoader(delegator);
            if (arrayClass == null) {
                arrayClass = new ArrayClass(aRef, primordial, cha);
                this.arrayClasses.put(aRef, arrayClass);
            }
        } else {
            arrayClass = this.arrayClasses.get(type);
            if (arrayClass == null) {
                IClass elementCls = delegator.lookupClass(elementType.getName());
                if (elementCls == null) {
                    return null;
                }
                TypeReference realType = TypeReference.findOrCreateArrayOf(elementCls.getReference());
                arrayClass = this.arrayClasses.get(realType);
                if (arrayClass == null) {
                    arrayClass = new ArrayClass(realType, elementCls.getClassLoader(), cha);
                }
            }
            this.arrayClasses.put(type, arrayClass);
        }
        return arrayClass;
    }

    private static IClassLoader getRootClassLoader(IClassLoader l) {
        while (l.getParent() != null) {
            l = l.getParent();
        }
        return l;
    }
}

