/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.debug.Assertions;

public abstract class CallSiteReference
extends ProgramCounter
implements BytecodeConstants,
ContextItem {
    private final MethodReference declaredTarget;

    protected CallSiteReference(int programCounter, MethodReference declaredTarget) {
        super(programCounter);
        this.declaredTarget = declaredTarget;
    }

    public static CallSiteReference make(int programCounter, MethodReference declaredTarget, IInvokeInstruction.IDispatch invocationCode) {
        if (invocationCode == IInvokeInstruction.Dispatch.SPECIAL) {
            return new SpecialCall(programCounter, declaredTarget);
        }
        if (invocationCode == IInvokeInstruction.Dispatch.VIRTUAL) {
            return new VirtualCall(programCounter, declaredTarget);
        }
        if (invocationCode == IInvokeInstruction.Dispatch.INTERFACE) {
            return new InterfaceCall(programCounter, declaredTarget);
        }
        if (invocationCode == IInvokeInstruction.Dispatch.STATIC) {
            return new StaticCall(programCounter, declaredTarget);
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public MethodReference getDeclaredTarget() {
        return this.declaredTarget;
    }

    public abstract IInvokeInstruction.IDispatch getInvocationCode();

    public String toString() {
        return "invoke" + this.getInvocationString(this.getInvocationCode()) + " " + this.declaredTarget + "@" + this.getProgramCounter();
    }

    protected String getInvocationString(IInvokeInstruction.IDispatch invocationCode) {
        if (invocationCode == IInvokeInstruction.Dispatch.STATIC) {
            return "static";
        }
        if (invocationCode == IInvokeInstruction.Dispatch.SPECIAL) {
            return "special";
        }
        if (invocationCode == IInvokeInstruction.Dispatch.VIRTUAL) {
            return "virtual";
        }
        if (invocationCode == IInvokeInstruction.Dispatch.INTERFACE) {
            return "interface";
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public String getInvocationString() {
        return this.getInvocationString(this.getInvocationCode());
    }

    public final boolean isInterface() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.INTERFACE;
    }

    public final boolean isVirtual() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.VIRTUAL;
    }

    public final boolean isSpecial() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.SPECIAL;
    }

    public boolean isStatic() {
        return this.getInvocationCode() == IInvokeInstruction.Dispatch.STATIC;
    }

    public boolean isFixed() {
        return this.isStatic() || this.isSpecial();
    }

    public boolean isDispatch() {
        return this.isVirtual() || this.isInterface();
    }

    static class InterfaceCall
    extends CallSiteReference {
        InterfaceCall(int programCounter, MethodReference declaredTarget) {
            super(programCounter, declaredTarget);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.INTERFACE;
        }
    }

    static class SpecialCall
    extends CallSiteReference {
        SpecialCall(int programCounter, MethodReference declaredTarget) {
            super(programCounter, declaredTarget);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.SPECIAL;
        }
    }

    static class StaticCall
    extends CallSiteReference {
        StaticCall(int programCounter, MethodReference declaredTarget) {
            super(programCounter, declaredTarget);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.STATIC;
        }
    }

    static class VirtualCall
    extends CallSiteReference {
        VirtualCall(int programCounter, MethodReference declaredTarget) {
            super(programCounter, declaredTarget);
        }

        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.VIRTUAL;
        }
    }
}

