/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.impl.SetOfClasses;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.ShrikeClassReaderHandle;
import com.ibm.wala.util.collections.HashCodeComparator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.ToStringComparator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderImpl
implements IClassLoader {
    private static final int DEBUG_LEVEL = 0;
    private final SetOfClasses exclusions;
    private final ClassLoaderReference loader;
    protected final Map<TypeName, IClass> loadedClasses = HashMapFactory.make();
    private final Map<TypeName, String> sourceMap = HashMapFactory.make();
    private final IClassLoader parent;
    protected final IClassHierarchy cha;
    private final ArrayClassLoader arrayClassLoader;

    public ClassLoaderImpl(ClassLoaderReference loader, ArrayClassLoader arrayClassLoader, IClassLoader parent, SetOfClasses exclusions, IClassHierarchy cha) {
        this.arrayClassLoader = arrayClassLoader;
        this.parent = parent;
        this.loader = loader;
        this.exclusions = exclusions;
        this.cha = cha;
    }

    private Set<ModuleEntry> getSourceFiles(Module M) throws IOException {
        TreeSet sortedEntries = new TreeSet(HashCodeComparator.instance());
        sortedEntries.addAll((Collection)Iterator2Collection.toCollection(M.getEntries()));
        HashSet<ModuleEntry> result = HashSetFactory.make();
        for (ModuleEntry entry : sortedEntries) {
            if (entry.isSourceFile()) {
                result.add(entry);
                continue;
            }
            if (!entry.isModuleFile()) continue;
            result.addAll(this.getSourceFiles(entry.asModule()));
        }
        return result;
    }

    private Set<ModuleEntry> getClassFiles(Module M) throws IOException {
        TreeSet sortedEntries = new TreeSet(HashCodeComparator.instance());
        sortedEntries.addAll((Collection)Iterator2Collection.toCollection(M.getEntries()));
        HashSet<ModuleEntry> result = HashSetFactory.make();
        for (ModuleEntry entry : sortedEntries) {
            if (entry.isClassFile()) {
                result.add(entry);
                continue;
            }
            if (!entry.isModuleFile()) continue;
            Set<ModuleEntry> s = this.getClassFiles(entry.asModule());
            this.removeClassFiles(s, result);
            result.addAll(s);
        }
        return result;
    }

    private void removeClassFiles(Set<ModuleEntry> s, Set<ModuleEntry> t) {
        Set old = HashSetFactory.make();
        for (ModuleEntry m : t) {
            old.add(m.getClassName());
        }
        HashSet toRemove = HashSetFactory.make();
        for (ModuleEntry m : s) {
            if (!old.contains(m.getClassName())) continue;
            toRemove.add(m);
        }
        s.removeAll(toRemove);
    }

    private Collection<IClass> getAllClasses() {
        Assertions._assert(this.loadedClasses != null);
        return this.loadedClasses.values();
    }

    private void loadAllClasses(Collection<ModuleEntry> moduleEntries) {
        for (ModuleEntry entry : moduleEntries) {
            if (!entry.isClassFile()) continue;
            String className = entry.getClassName().replace('.', '/');
            if (this.exclusions != null && this.exclusions.contains(className)) continue;
            ShrikeClassReaderHandle reader = new ShrikeClassReaderHandle(entry);
            className = "L" + className;
            try {
                TypeName T = TypeName.string2TypeName(className);
                if (this.loadedClasses.get(T) != null) {
                    Warnings.add(MultipleImplementationsWarning.create(className));
                    continue;
                }
                ShrikeClass klass = new ShrikeClass(reader, this, this.cha);
                if (klass.getReference().getName().equals(T)) {
                    this.loadedClasses.put(T, new ShrikeClass(reader, this, this.cha));
                    continue;
                }
                Warnings.add(InvalidClassFile.create(className));
            }
            catch (InvalidClassFileException e) {
                Warnings.add(InvalidClassFile.create(className));
            }
        }
    }

    protected void loadAllSources(Set<ModuleEntry> sourceModules) {
        for (ModuleEntry entry : sourceModules) {
            String className = entry.getClassName().replace('.', '/');
            className = className.replace(File.separatorChar, '/');
            className = "L" + (className.startsWith("/") ? className.substring(1) : className);
            TypeName T = TypeName.string2TypeName(className);
            this.sourceMap.put(T, entry.getName());
        }
    }

    @Override
    public void init(Set<Module> modules) throws IOException {
        if (modules == null) {
            throw new IllegalArgumentException("modules is null");
        }
        TreeSet<Module> archives = new TreeSet<Module>(ToStringComparator.instance());
        for (Module M : modules) {
            archives.add(M);
        }
        Set classModuleEntries = HashSetFactory.make();
        Set sourceModuleEntries = HashSetFactory.make();
        for (Module archive : archives) {
            Set<ModuleEntry> classFiles = this.getClassFiles(archive);
            this.removeClassFiles(classFiles, classModuleEntries);
            for (ModuleEntry file : classFiles) {
                classModuleEntries.add(file);
            }
            Set<ModuleEntry> sourceFiles = this.getSourceFiles(archive);
            for (ModuleEntry file : sourceFiles) {
                sourceModuleEntries.add(file);
            }
        }
        this.loadAllClasses(classModuleEntries);
        this.loadAllSources(sourceModuleEntries);
    }

    @Override
    public ClassLoaderReference getReference() {
        return this.loader;
    }

    @Override
    public Iterator<IClass> iterateAllClasses() {
        return this.getAllClasses().iterator();
    }

    private IClass lookupClassInternal(TypeName className) {
        IClass result;
        ClassLoaderImpl parent = (ClassLoaderImpl)this.getParent();
        if (parent != null && (result = parent.lookupClassInternal(className)) != null) {
            return result;
        }
        return this.loadedClasses.get(className);
    }

    @Override
    public IClass lookupClass(TypeName className) {
        IClass result;
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (className.isArrayType()) {
            return this.arrayClassLoader.lookupClass(className, this, this.cha);
        }
        ClassLoaderImpl parent = (ClassLoaderImpl)this.getParent();
        if (parent != null && (result = parent.lookupClassInternal(className)) != null) {
            return result;
        }
        result = this.loadedClasses.get(className);
        return result;
    }

    @Override
    public IClassLoader getParent() {
        return this.parent;
    }

    @Override
    public Atom getName() {
        return this.loader.getName();
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int getNumberOfClasses() {
        return this.getAllClasses().size();
    }

    @Override
    public int getNumberOfMethods() {
        int result = 0;
        Iterator<IClass> it = this.iterateAllClasses();
        while (it.hasNext()) {
            IClass klass = it.next();
            result += klass.getDeclaredMethods().size();
        }
        return result;
    }

    @Override
    public String getSourceFileName(IClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        return this.sourceMap.get(klass.getName());
    }

    @Override
    public void removeAll(Collection<IClass> toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException("toRemove is null");
        }
        for (IClass klass : toRemove) {
            this.loadedClasses.remove(klass.getName());
            this.sourceMap.remove(klass.getName());
        }
    }

    private static class InvalidClassFile
    extends Warning {
        final String className;

        InvalidClassFile(String className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static InvalidClassFile create(String className) {
            return new InvalidClassFile(className);
        }
    }

    private static class MultipleImplementationsWarning
    extends Warning {
        final String className;

        MultipleImplementationsWarning(String className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static MultipleImplementationsWarning create(String className) {
            return new MultipleImplementationsWarning(className);
        }
    }
}

