/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeScanner {
    public static Collection<CallSiteReference> getCallSites(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.getCallSites(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.getCallSitesFromShrikeBT((ShrikeCTMethod)m);
    }

    public static Collection<FieldReference> getFieldsRead(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.getFieldsRead(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.getFieldsReadFromShrikeBT((ShrikeCTMethod)m);
    }

    public static Collection<FieldReference> getFieldsWritten(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.getFieldsWritten(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.getFieldsWrittenFromShrikeBT((ShrikeCTMethod)m);
    }

    public static Collection<NewSiteReference> getNewSites(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.getNewSites(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.getNewSitesFromShrikeBT((ShrikeCTMethod)m);
    }

    public static boolean hasObjectArrayLoad(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.hasObjectArrayLoad(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.hasShrikeBTObjectArrayLoad((ShrikeCTMethod)m);
    }

    public static boolean hasObjectArrayStore(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.hasObjectArrayStore(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.hasShrikeBTObjectArrayStore((ShrikeCTMethod)m);
    }

    public static Set getCaughtExceptions(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.getCaughtExceptions(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.getShrikeBTCaughtExceptions((ShrikeCTMethod)m);
    }

    public static Iterator iterateCastTypes(IMethod m) throws InvalidClassFileException {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m;
            return CodeScanner.iterateCastTypes(sm.getStatements(SSAOptions.defaultOptions()));
        }
        return CodeScanner.iterateShrikeBTCastTypes((ShrikeCTMethod)m);
    }

    private static Iterator iterateShrikeBTCastTypes(ShrikeCTMethod wrapper) throws InvalidClassFileException {
        return wrapper.getCastTypes();
    }

    private static Set getShrikeBTCaughtExceptions(ShrikeCTMethod method) throws InvalidClassFileException {
        return method.getCaughtExceptionTypes();
    }

    private static boolean hasShrikeBTObjectArrayStore(ShrikeCTMethod M) throws InvalidClassFileException {
        Iterator it = M.getArraysWritten();
        while (it.hasNext()) {
            TypeReference t = (TypeReference)it.next();
            if (!t.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    private static Collection<CallSiteReference> getCallSitesFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        return M.getCallSites();
    }

    private static Collection<NewSiteReference> getNewSitesFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        return M.getNewSites();
    }

    private static List<FieldReference> getFieldsReadFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        Iterator<FieldReference> it = M.getFieldsRead();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private static List<FieldReference> getFieldsWrittenFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        Iterator<FieldReference> it = M.getFieldsWritten();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private static boolean hasShrikeBTObjectArrayLoad(ShrikeCTMethod M) throws InvalidClassFileException {
        Iterator it = M.getArraysRead();
        while (it.hasNext()) {
            TypeReference t = (TypeReference)it.next();
            if (!t.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    public static Set<TypeReference> getCaughtExceptions(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final HashSet<TypeReference> result = HashSetFactory.make(10);
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
                Collection<TypeReference> t = instruction.getExceptionTypes();
                result.addAll(t);
            }
        };
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            ++i;
        }
        return result;
    }

    public static Iterator<TypeReference> iterateCastTypes(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        HashSet result = HashSetFactory.make(10);
        int i = 0;
        while (i < statements.length) {
            if (statements[i] != null && statements[i] instanceof SSACheckCastInstruction) {
                SSACheckCastInstruction c = (SSACheckCastInstruction)statements[i];
                result.add(c.getDeclaredResultType());
            }
            ++i;
        }
        return result.iterator();
    }

    private static List<CallSiteReference> getCallSites(SSAInstruction[] statements) {
        final LinkedList<CallSiteReference> result = new LinkedList<CallSiteReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitInvoke(SSAInvokeInstruction instruction) {
                result.add(instruction.getCallSite());
            }
        };
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            ++i;
        }
        return result;
    }

    private static List<NewSiteReference> getNewSites(SSAInstruction[] statements) {
        final LinkedList<NewSiteReference> result = new LinkedList<NewSiteReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitNew(SSANewInstruction instruction) {
                result.add(instruction.getNewSite());
            }
        };
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            ++i;
        }
        return result;
    }

    public static List<FieldReference> getFieldsRead(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitGet(SSAGetInstruction instruction) {
                result.add(instruction.getDeclaredField());
            }
        };
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            ++i;
        }
        return result;
    }

    public static List<FieldReference> getFieldsWritten(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            public void visitPut(SSAPutInstruction instruction) {
                result.add(instruction.getDeclaredField());
            }
        };
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            ++i;
        }
        return result;
    }

    public static boolean hasObjectArrayLoad(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
                if (!instruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor v = new ScanVisitor();
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            if (v.foundOne) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasObjectArrayStore(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            public void visitArrayStore(SSAArrayStoreInstruction instruction) {
                if (!instruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor v = new ScanVisitor();
        int i = 0;
        while (i < statements.length) {
            SSAInstruction s = statements[i];
            if (s != null) {
                s.visit(v);
            }
            if (v.foundOne) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

