/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Trace;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryTreeModule
implements Module {
    protected final File root;

    DirectoryTreeModule(File root) throws IllegalArgumentException {
        this.root = root;
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root is not a directory " + root);
        }
    }

    protected abstract FileModule makeFile(File var1);

    protected abstract boolean includeFile(File var1);

    private Set<ModuleEntry> getEntriesRecursive(File dir) {
        Set result = HashSetFactory.make();
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    result.addAll(this.getEntriesRecursive(files[i]));
                } else if (this.includeFile(files[i])) {
                    result.add(this.makeFile(files[i]));
                }
                ++i;
            }
        } else {
            Trace.println("Warning: failed to retrieve files in " + dir);
        }
        return result;
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        return this.getEntriesRecursive(this.root).iterator();
    }

    public String getPath() {
        return this.root.getAbsolutePath();
    }

    public String toString() {
        return this.getClass() + ":" + this.getPath();
    }
}

