/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileSuffixes;
import java.io.InputStream;
import java.util.jar.JarFile;

public class JarFileEntry
implements ModuleEntry {
    private final String entryName;
    private final JarFileModule jarFileModule;
    private final JarFile jarFile;

    JarFileEntry(String entryName, JarFileModule jarFile) {
        this.entryName = entryName;
        this.jarFileModule = jarFile;
        this.jarFile = jarFile.getJarFile();
    }

    public String getName() {
        return this.entryName;
    }

    public boolean isClassFile() {
        return FileSuffixes.isClassFile(this.getName());
    }

    public InputStream getInputStream() {
        try {
            return this.jarFile.getInputStream(this.jarFile.getEntry(this.entryName));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public long getSize() {
        return this.jarFile.getEntry(this.entryName).getSize();
    }

    public String toString() {
        return String.valueOf(this.jarFile.getName()) + ":" + this.getName();
    }

    public boolean isModuleFile() {
        return FileSuffixes.isJarFile(this.getName()) || FileSuffixes.isWarFile(this.getName());
    }

    public Module asModule() {
        return new NestedJarFileModule(this.jarFileModule, this.jarFile.getEntry(this.entryName));
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    public int hashCode() {
        return this.entryName.hashCode() * 5059 + this.jarFile.hashCode();
    }

    public String getClassName() {
        return FileSuffixes.stripSuffix(this.getName());
    }

    public boolean isSourceFile() {
        return FileSuffixes.isSourceFile(this.getName());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

