/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.CacheReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileModule
implements Module {
    private final JarFile file;
    private final HashMap<ZipEntry, Object> cache = HashMapFactory.make();

    public JarFileModule(JarFile f) {
        this.file = f;
    }

    public String getAbsolutePath() {
        return this.file.getName();
    }

    public String toString() {
        return "JarFileModule:" + this.file.getName();
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        HashSet result = HashSetFactory.make();
        Enumeration<JarEntry> e = this.file.entries();
        while (e.hasMoreElements()) {
            ZipEntry Z = e.nextElement();
            result.add(new JarFileEntry(Z.getName(), this));
        }
        return result.iterator();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (this.getClass().equals(arg0.getClass())) {
            JarFileModule other = (JarFileModule)arg0;
            return this.file.equals(other.file);
        }
        return false;
    }

    public byte[] getContents(ZipEntry entry) {
        byte[] b = (byte[])CacheReference.get(this.cache.get(entry));
        if (b != null) {
            return b;
        }
        try {
            InputStream s = this.file.getInputStream(entry);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            b = new byte[1024];
            int n = s.read(b);
            while (n != -1) {
                out.write(b, 0, n);
                n = s.read(b);
            }
            byte[] bb = out.toByteArray();
            this.cache.put(entry, CacheReference.make(bb));
            s.close();
            return bb;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public JarFile getJarFile() {
        return this.file;
    }
}

