/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileSuffixes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarFileModule
implements Module {
    private static final boolean DEBUG = false;
    private final JarFileModule parent;
    private final ZipEntry entry;
    private HashMap<String, byte[]> cache = null;

    public NestedJarFileModule(JarFileModule parent, ZipEntry entry) {
        this.parent = parent;
        this.entry = entry;
    }

    public InputStream getInputStream(String name) {
        this.populateCache();
        byte[] b = this.cache.get(name);
        return new ByteArrayInputStream(b);
    }

    private void populateCache() {
        if (this.cache != null) {
            return;
        }
        try {
            this.cache = HashMapFactory.make();
            byte[] b = this.parent.getContents(this.entry);
            JarInputStream stream = new JarInputStream(new ByteArrayInputStream(b));
            ZipEntry z = stream.getNextEntry();
            while (z != null) {
                if (FileSuffixes.isClassFile(z.getName()) || FileSuffixes.isSourceFile(z.getName())) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] temp = new byte[1024];
                    int n = stream.read(temp);
                    while (n != -1) {
                        out.write(temp, 0, n);
                        n = stream.read(temp);
                    }
                    byte[] bb = out.toByteArray();
                    try {
                        if (FileSuffixes.isClassFile(z.getName())) {
                            new ClassReader(bb);
                        }
                        this.cache.put(z.getName(), bb);
                    }
                    catch (InvalidClassFileException e1) {
                        e1.printStackTrace();
                        Assertions.UNREACHABLE();
                    }
                }
                z = stream.getNextEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    protected long getEntrySize(String name) {
        this.populateCache();
        byte[] b = this.cache.get(name);
        return b.length;
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        this.populateCache();
        final Iterator<String> it = this.cache.keySet().iterator();
        return new Iterator<ModuleEntry>(){
            String next = null;
            {
                this.advance();
            }

            private void advance() {
                this.next = it.hasNext() ? (String)it.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ModuleEntry next() {
                Entry result = new Entry(this.next);
                this.advance();
                return result;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public String toString() {
        return "Nested Jar File:" + this.entry.getName();
    }

    private class Entry
    implements ModuleEntry {
        private final String name;

        Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isClassFile() {
            return FileSuffixes.isClassFile(this.getName());
        }

        public InputStream getInputStream() {
            return NestedJarFileModule.this.getInputStream(this.name);
        }

        public long getSize() {
            return NestedJarFileModule.this.getEntrySize(this.name);
        }

        public boolean isModuleFile() {
            return false;
        }

        public Module asModule() {
            Assertions.UNREACHABLE();
            return null;
        }

        public String toString() {
            return "nested entry: " + this.name;
        }

        public String getClassName() {
            return FileSuffixes.stripSuffix(this.getName());
        }

        public boolean isSourceFile() {
            return FileSuffixes.isSourceFile(this.getName());
        }
    }
}

