/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.Exceptions;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.ShrikeUtil;
import com.ibm.wala.util.bytecode.BytecodeStream;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShrikeBTMethod
implements IMethod,
BytecodeConstants {
    private static final boolean verbose = false;
    private static int methodsParsed = 0;
    protected final IClass declaringClass;
    private MethodReference methodReference;
    private SoftReference<BytecodeInfo> bcInfo;

    public ShrikeBTMethod(IClass klass) {
        this.declaringClass = klass;
    }

    protected BytecodeInfo getBCInfo() throws InvalidClassFileException {
        BytecodeInfo result = null;
        if (this.bcInfo != null) {
            result = this.bcInfo.get();
        }
        if (result == null) {
            result = this.computeBCInfo();
            this.bcInfo = new SoftReference<BytecodeInfo>(result);
        }
        return result;
    }

    public int getBytecodeIndex(int instructionIndex) throws InvalidClassFileException {
        return this.getBCInfo().pcMap[instructionIndex];
    }

    Collection<CallSiteReference> getCallSites() throws InvalidClassFileException {
        Collection empty = Collections.emptySet();
        if (this.isNative()) {
            return empty;
        }
        return this.getBCInfo().callSites == null ? empty : Collections.unmodifiableCollection((Collection)Arrays.asList(this.getBCInfo().callSites));
    }

    Collection<NewSiteReference> getNewSites() throws InvalidClassFileException {
        Collection empty = Collections.emptySet();
        if (this.isNative()) {
            return empty;
        }
        return this.getBCInfo().newSites == null ? empty : Collections.unmodifiableCollection((Collection)Arrays.asList(this.getBCInfo().newSites));
    }

    public Collection getImplicitExceptionTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return Collections.EMPTY_SET;
        }
        return this.getBCInfo().implicitExceptions == null ? Arrays.asList(new TypeReference[0]) : Arrays.asList(this.getBCInfo().implicitExceptions);
    }

    private BytecodeInfo computeBCInfo() throws InvalidClassFileException {
        BytecodeInfo result = new BytecodeInfo();
        result.exceptionTypes = this.computeDeclaredExceptions();
        if (this.isNative()) {
            return result;
        }
        this.processBytecodesWithShrikeBT(result);
        return result;
    }

    public boolean hasMonitorOp() throws InvalidClassFileException {
        if (this.isNative()) {
            return false;
        }
        return this.getBCInfo().hasMonitorOp;
    }

    public Iterator<FieldReference> getFieldsWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsWritten == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> l = Arrays.asList(this.getBCInfo().fieldsWritten);
        return l.iterator();
    }

    public Iterator<FieldReference> getFieldsRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        if (this.getBCInfo().fieldsRead == null) {
            return EmptyIterator.instance();
        }
        List<FieldReference> l = Arrays.asList(this.getBCInfo().fieldsRead);
        return l.iterator();
    }

    public Iterator getArraysRead() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().arraysRead == null ? (Iterator<TypeReference>)EmptyIterator.instance() : Arrays.asList(this.getBCInfo().arraysRead).iterator();
    }

    public Iterator getArraysWritten() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().arraysWritten == null ? (Iterator<TypeReference>)EmptyIterator.instance() : Arrays.asList(this.getBCInfo().arraysWritten).iterator();
    }

    public Iterator getCastTypes() throws InvalidClassFileException {
        if (this.isNative()) {
            return EmptyIterator.instance();
        }
        return this.getBCInfo().castTypes == null ? (Iterator<TypeReference>)EmptyIterator.instance() : Arrays.asList(this.getBCInfo().castTypes).iterator();
    }

    protected abstract byte[] getBytecodes();

    public BytecodeStream getBytecodeStream() {
        byte[] bytecodes = this.getBytecodes();
        if (bytecodes == null) {
            return null;
        }
        return new BytecodeStream(this, bytecodes);
    }

    protected abstract String getMethodName() throws InvalidClassFileException;

    protected abstract String getMethodSignature() throws InvalidClassFileException;

    private MethodReference computeMethodReference() {
        try {
            Atom name = Atom.findOrCreateUnicodeAtom(this.getMethodName());
            ImmutableByteArray desc = ImmutableByteArray.make(this.getMethodSignature());
            Descriptor D = Descriptor.findOrCreate(desc);
            return MethodReference.findOrCreate(this.declaringClass.getReference(), name, D);
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public MethodReference getReference() {
        if (this.methodReference == null) {
            this.methodReference = this.computeMethodReference();
        }
        return this.methodReference;
    }

    @Override
    public boolean isClinit() {
        return this.getReference().getSelector().equals(MethodReference.clinitSelector);
    }

    @Override
    public boolean isInit() {
        return this.getReference().getName().equals(MethodReference.initAtom);
    }

    protected abstract int getModifiers();

    @Override
    public boolean isNative() {
        return (this.getModifiers() & 0x100) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    @Override
    public boolean isVolatile() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public boolean isSynchronized() {
        return (this.getModifiers() & 0x20) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    protected abstract Decoder makeDecoder();

    protected abstract void processDebugInfo(BytecodeInfo var1) throws InvalidClassFileException;

    private void processBytecodesWithShrikeBT(BytecodeInfo info) throws InvalidClassFileException {
        info.decoder = this.makeDecoder();
        if (!this.isAbstract() && info.decoder == null) {
            Assertions.UNREACHABLE("bad method " + this.getReference());
        }
        if (info.decoder == null) {
            return;
        }
        info.pcMap = info.decoder.getInstructionsToBytecodes();
        this.processDebugInfo(info);
        SimpleVisitor simpleVisitor = new SimpleVisitor(info);
        Instruction[] instructions = info.decoder.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            Collection<TypeReference> t;
            simpleVisitor.setInstructionIndex(i);
            instructions[i].visit(simpleVisitor);
            if (Exceptions.isPEI(instructions[i]) && (t = Exceptions.getIndependentExceptionTypes(instructions[i])) != null) {
                simpleVisitor.implicitExceptions.addAll(t);
            }
            ++i;
        }
        this.copyVisitorSetsToArrays(simpleVisitor, info);
    }

    private void copyVisitorSetsToArrays(SimpleVisitor simpleVisitor, BytecodeInfo info) {
        info.newSites = new NewSiteReference[simpleVisitor.newSites.size()];
        int i = 0;
        Iterator<Object> it = simpleVisitor.newSites.iterator();
        while (it.hasNext()) {
            info.newSites[i++] = it.next();
        }
        info.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        i = 0;
        it = simpleVisitor.fieldsRead.iterator();
        while (it.hasNext()) {
            info.fieldsRead[i++] = (FieldReference)it.next();
        }
        info.fieldsRead = new FieldReference[simpleVisitor.fieldsRead.size()];
        i = 0;
        it = simpleVisitor.fieldsRead.iterator();
        while (it.hasNext()) {
            info.fieldsRead[i++] = (FieldReference)it.next();
        }
        info.fieldsWritten = new FieldReference[simpleVisitor.fieldsWritten.size()];
        i = 0;
        it = simpleVisitor.fieldsWritten.iterator();
        while (it.hasNext()) {
            info.fieldsWritten[i++] = (FieldReference)it.next();
        }
        info.callSites = new CallSiteReference[simpleVisitor.callSites.size()];
        i = 0;
        it = simpleVisitor.callSites.iterator();
        while (it.hasNext()) {
            info.callSites[i++] = (CallSiteReference)it.next();
        }
        info.arraysRead = new TypeReference[simpleVisitor.arraysRead.size()];
        i = 0;
        it = simpleVisitor.arraysRead.iterator();
        while (it.hasNext()) {
            info.arraysRead[i++] = (TypeReference)it.next();
        }
        info.arraysWritten = new TypeReference[simpleVisitor.arraysWritten.size()];
        i = 0;
        it = simpleVisitor.arraysWritten.iterator();
        while (it.hasNext()) {
            info.arraysWritten[i++] = (TypeReference)it.next();
        }
        info.implicitExceptions = new TypeReference[simpleVisitor.implicitExceptions.size()];
        i = 0;
        it = simpleVisitor.implicitExceptions.iterator();
        while (it.hasNext()) {
            info.implicitExceptions[i++] = (TypeReference)it.next();
        }
        info.castTypes = new TypeReference[simpleVisitor.castTypes.size()];
        i = 0;
        it = simpleVisitor.castTypes.iterator();
        while (it.hasNext()) {
            info.castTypes[i++] = (TypeReference)it.next();
        }
        info.hasMonitorOp = simpleVisitor.hasMonitorOp;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShrikeBTMethod) {
            ShrikeBTMethod that = (ShrikeBTMethod)obj;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && this.getReference().equals(that.getReference());
        }
        return false;
    }

    public int hashCode() {
        return 9661 * this.getReference().hashCode();
    }

    @Override
    public abstract int getMaxLocals();

    @Override
    public abstract int getMaxStackHeight();

    @Override
    public Atom getName() {
        return this.getReference().getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.getReference().getDescriptor();
    }

    public Instruction[] getInstructions() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getInstructions();
    }

    public ExceptionHandler[][] getHandlers() throws InvalidClassFileException {
        if (this.getBCInfo().decoder == null) {
            return null;
        }
        return this.getBCInfo().decoder.getHandlers();
    }

    @Override
    public TypeReference getParameterType(int i) {
        if (!this.isStatic()) {
            if (i == 0) {
                return this.declaringClass.getReference();
            }
            return this.getReference().getParameterType(i - 1);
        }
        return this.getReference().getParameterType(i);
    }

    @Override
    public int getNumberOfParameters() {
        if (this.isStatic() || this.isClinit()) {
            return this.getReference().getNumberOfParameters();
        }
        return this.getReference().getNumberOfParameters() + 1;
    }

    @Override
    public abstract boolean hasExceptionHandler();

    @Override
    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException {
        return this.getBCInfo().exceptionTypes == null ? new TypeReference[]{} : this.getBCInfo().exceptionTypes;
    }

    protected abstract String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException;

    private TypeReference[] computeDeclaredExceptions() {
        String[] strings;
        block4: {
            strings = this.getDeclaredExceptionTypeNames();
            if (strings != null) break block4;
            return null;
        }
        try {
            ClassLoaderReference loader = this.getDeclaringClass().getClassLoader().getReference();
            TypeReference[] result = new TypeReference[strings.length];
            int i = 0;
            while (i < result.length) {
                result[i] = TypeReference.findOrCreate(loader, TypeName.findOrCreate(ImmutableByteArray.make("L" + strings[i])));
                ++i;
            }
            return result;
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public int getLineNumber(int bcIndex) throws InvalidClassFileException {
        return this.getBCInfo().lineNumberMap == null ? -1 : this.getBCInfo().lineNumberMap[bcIndex];
    }

    public Set<TypeReference> getCaughtExceptionTypes() throws InvalidClassFileException {
        ExceptionHandler[][] handlers = this.getHandlers();
        if (handlers == null) {
            return Collections.emptySet();
        }
        HashSet<TypeReference> result = HashSetFactory.make(10);
        ClassLoaderReference loader = this.getReference().getDeclaringClass().getClassLoader();
        int i = 0;
        while (i < handlers.length) {
            int j = 0;
            while (j < handlers[i].length) {
                TypeReference t = ShrikeUtil.makeTypeReference(loader, handlers[i][j].getCatchClass());
                if (t == null) {
                    t = TypeReference.JavaLangThrowable;
                }
                result.add(t);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public String getSignature() {
        return this.getReference().getSignature();
    }

    @Override
    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    @Override
    public abstract String getLocalVariableName(int var1, int var2) throws InvalidClassFileException;

    @Override
    public abstract boolean hasLocalVariableTable();

    public void clearCaches() {
        this.bcInfo = null;
    }

    protected static class BytecodeInfo {
        Decoder decoder;
        CallSiteReference[] callSites;
        FieldReference[] fieldsWritten;
        FieldReference[] fieldsRead;
        NewSiteReference[] newSites;
        TypeReference[] arraysRead;
        TypeReference[] arraysWritten;
        TypeReference[] implicitExceptions;
        TypeReference[] castTypes;
        boolean hasMonitorOp;
        private int[] pcMap;
        protected int[] lineNumberMap;
        protected int[][] localVariableMap;
        private TypeReference[] exceptionTypes;

        protected BytecodeInfo() {
        }
    }

    private class SimpleVisitor
    extends Instruction.Visitor {
        private final BytecodeInfo info;
        final Set<CallSiteReference> callSites = HashSetFactory.make(5);
        final Set<FieldReference> fieldsWritten = HashSetFactory.make(5);
        final Set<FieldReference> fieldsRead = HashSetFactory.make(5);
        final Set<NewSiteReference> newSites = HashSetFactory.make(5);
        final Set<TypeReference> arraysRead = HashSetFactory.make(5);
        final Set<TypeReference> arraysWritten = HashSetFactory.make(5);
        final Set<TypeReference> implicitExceptions = HashSetFactory.make(5);
        final Set<TypeReference> castTypes = HashSetFactory.make(5);
        boolean hasMonitorOp;
        private int instructionIndex;

        public SimpleVisitor(BytecodeInfo info) {
            this.info = info;
        }

        public void setInstructionIndex(int i) {
            this.instructionIndex = i;
        }

        public int getProgramCounter() throws InvalidClassFileException {
            return this.info.pcMap[this.instructionIndex];
        }

        public void visitMonitor(MonitorInstruction instruction) {
            this.hasMonitorOp = true;
        }

        public void visitNew(NewInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            TypeReference t = ShrikeUtil.makeTypeReference(loader, instruction.getType());
            try {
                this.newSites.add(NewSiteReference.make(this.getProgramCounter(), t));
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }

        public void visitGet(GetInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference f = FieldReference.findOrCreate(loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            this.fieldsRead.add(f);
        }

        public void visitPut(PutInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            FieldReference f = FieldReference.findOrCreate(loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            this.fieldsWritten.add(f);
        }

        public void visitInvoke(InvokeInstruction instruction) {
            ClassLoaderReference loader = ShrikeBTMethod.this.getReference().getDeclaringClass().getClassLoader();
            MethodReference m = MethodReference.findOrCreate(loader, instruction.getClassType(), instruction.getMethodName(), instruction.getMethodSignature());
            int programCounter = 0;
            try {
                programCounter = this.getProgramCounter();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            CallSiteReference site = null;
            int nParams = m.getNumberOfParameters();
            switch (instruction.getInvocationMode()) {
                case 184: {
                    site = CallSiteReference.make(programCounter, m, IInvokeInstruction.Dispatch.STATIC);
                    break;
                }
                case 185: {
                    site = CallSiteReference.make(programCounter, m, IInvokeInstruction.Dispatch.INTERFACE);
                    ++nParams;
                    break;
                }
                case 183: {
                    site = CallSiteReference.make(programCounter, m, IInvokeInstruction.Dispatch.SPECIAL);
                    ++nParams;
                    break;
                }
                case 182: {
                    site = CallSiteReference.make(programCounter, m, IInvokeInstruction.Dispatch.VIRTUAL);
                    ++nParams;
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                }
            }
            this.callSites.add(site);
        }

        public void visitArrayLoad(ArrayLoadInstruction instruction) {
            this.arraysRead.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), instruction.getType()));
        }

        public void visitArrayStore(ArrayStoreInstruction instruction) {
            this.arraysWritten.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), instruction.getType()));
        }

        public void visitCheckCast(CheckCastInstruction instruction) {
            this.castTypes.add(ShrikeUtil.makeTypeReference(ShrikeBTMethod.this.getDeclaringClass().getClassLoader().getReference(), instruction.getType()));
        }
    }
}

