/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.util.Atom;
import com.ibm.wala.util.ImmutableByteArray;
import com.ibm.wala.util.ShrikeClassReaderHandle;
import com.ibm.wala.util.collections.BimodalMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrikeClass
implements IClass {
    static final boolean DEBUG = false;
    private final ShrikeClassReaderHandle reader;
    private final IClassLoader loader;
    private final IClassHierarchy cha;
    private Map<Selector, IMethod> methodMap;
    private Map<Selector, IMethod> inheritCache;
    private TypeReference typeReference;
    private IClass superClass;
    private boolean superclassComputed = false;
    private ImmutableByteArray superName;
    private ImmutableByteArray[] interfaceNames;
    private Collection<IClass> allInterfaces = null;
    private IField[] instanceFields;
    private IField[] staticFields;
    private int modifiers;
    private final int hashCode;
    private final HashMap<Atom, IField> fieldMap = HashMapFactory.make(5);

    public ShrikeClass(ShrikeClassReaderHandle reader, IClassLoader loader, IClassHierarchy cha) throws InvalidClassFileException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader;
        this.loader = loader;
        this.cha = cha;
        this.computeTypeReference();
        this.hashCode = 2161 * this.getReference().hashCode();
        this.computeSuperName();
        this.computeModifiers();
        this.computeInterfaceNames();
        this.computeFields();
    }

    private void computeFields() throws InvalidClassFileException {
        ClassReader cr = this.reader.get();
        int fieldCount = cr.getFieldCount();
        ArrayList<FieldImpl> instanceList = new ArrayList<FieldImpl>(fieldCount);
        ArrayList<FieldImpl> staticList = new ArrayList<FieldImpl>(fieldCount);
        try {
            int i = 0;
            while (i < fieldCount) {
                int accessFlags = cr.getFieldAccessFlags(i);
                Atom name = Atom.findOrCreateUnicodeAtom(cr.getFieldName(i));
                ImmutableByteArray b = ImmutableByteArray.make(cr.getFieldType(i));
                Collection<Annotation> annotations = null;
                try {
                    annotations = this.getRuntimeInvisibleAnnotations(i);
                    annotations = annotations.isEmpty() ? null : annotations;
                }
                catch (RuntimeInvisibleAnnotationsReader.UnimplementedException e) {
                    e.printStackTrace();
                }
                if ((accessFlags & 8) == 0) {
                    this.addFieldToList(instanceList, name, b, accessFlags, annotations);
                } else {
                    this.addFieldToList(staticList, name, b, accessFlags, annotations);
                }
                ++i;
            }
            this.instanceFields = new IField[instanceList.size()];
            this.populateFieldArrayFromList(instanceList, this.instanceFields);
            this.staticFields = new IField[staticList.size()];
            this.populateFieldArrayFromList(staticList, this.staticFields);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void populateFieldArrayFromList(List<FieldImpl> L, IField[] A) {
        Iterator<FieldImpl> it = L.iterator();
        int i = 0;
        while (i < A.length) {
            A[i] = it.next();
            ++i;
        }
    }

    private void addFieldToList(List<FieldImpl> L, Atom name, ImmutableByteArray fieldType, int accessFlags, Collection<Annotation> annotations) {
        TypeName T = null;
        T = fieldType.get(fieldType.length() - 1) == 59 ? TypeName.findOrCreate(fieldType, 0, fieldType.length() - 1) : TypeName.findOrCreate(fieldType);
        TypeReference type = TypeReference.findOrCreate(this.getClassLoader().getReference(), T);
        FieldReference fr = FieldReference.findOrCreate(this.getReference(), name, type);
        FieldImpl f = new FieldImpl(this, fr, accessFlags, annotations);
        L.add(f);
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public boolean isInterface() {
        boolean result = (this.modifiers & 0x200) != 0;
        return result;
    }

    @Override
    public boolean isAbstract() {
        boolean result = (this.modifiers & 0x400) != 0;
        return result;
    }

    private void computeModifiers() throws InvalidClassFileException {
        this.modifiers = this.reader.get().getAccessFlags();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void computeSuperName() {
        try {
            String s = this.reader.get().getSuperName();
            if (s != null) {
                this.superName = ImmutableByteArray.make("L" + s);
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    private void computeSuperclass() {
        this.superclassComputed = true;
        if (this.superName == null) {
            if (!this.getReference().equals(TypeReference.JavaLangObject)) {
                this.superClass = this.loader.lookupClass(TypeReference.JavaLangObject.getName());
            }
            return;
        }
        this.superClass = this.loader.lookupClass(TypeName.findOrCreate(this.superName));
    }

    @Override
    public IClass getSuperclass() throws ClassHierarchyException {
        if (!this.superclassComputed) {
            this.computeSuperclass();
        }
        if (this.superClass == null && !this.getReference().equals(TypeReference.JavaLangObject)) {
            try {
                throw new ClassHierarchyException("No superclass " + this.reader.get().getSuperName() + " found for " + this);
            }
            catch (InvalidClassFileException e) {
                Assertions.UNREACHABLE();
            }
        }
        return this.superClass;
    }

    private void computeInterfaceNames() {
        try {
            String[] s = this.reader.get().getInterfaceNames();
            this.interfaceNames = new ImmutableByteArray[s.length];
            int i = 0;
            while (i < this.interfaceNames.length) {
                this.interfaceNames[i] = ImmutableByteArray.make("L" + s[i]);
                ++i;
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    private Collection<IClass> computeAllInterfacesAsCollection() throws ClassHierarchyException {
        Collection<IClass> c = this.getDirectInterfaces();
        Set result = HashSetFactory.make();
        for (IClass iClass : c) {
            if (iClass.isInterface()) {
                result.add(iClass);
                continue;
            }
            Warnings.add(ClassHierarchyWarning.create("expected an interface " + iClass));
        }
        for (ShrikeClass shrikeClass : c) {
            if (shrikeClass.isInterface()) {
                result.addAll(shrikeClass.computeAllInterfacesAsCollection());
                continue;
            }
            Warnings.add(ClassHierarchyWarning.create("expected an interface " + shrikeClass));
        }
        ShrikeClass sup = null;
        try {
            sup = (ShrikeClass)this.getSuperclass();
        }
        catch (ClassHierarchyException classHierarchyException) {
            Assertions.UNREACHABLE();
        }
        if (sup != null) {
            result.addAll(sup.computeAllInterfacesAsCollection());
        }
        return result;
    }

    @Override
    public Collection<IClass> getDirectInterfaces() {
        return this.array2IClassSet(this.interfaceNames);
    }

    private Collection<IClass> array2IClassSet(ImmutableByteArray[] interfaces) {
        ArrayList<IClass> result = new ArrayList<IClass>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            ImmutableByteArray name = interfaces[i];
            IClass klass = null;
            klass = this.loader.lookupClass(TypeName.findOrCreate(name));
            if (klass == null) {
                Warnings.add(ClassNotFoundWarning.create(name));
            } else {
                result.add(klass);
            }
            ++i;
        }
        return result;
    }

    private void computeMethodMap() throws InvalidClassFileException {
        if (this.methodMap == null) {
            ShrikeCTMethod[] methods = this.computeDeclaredMethods();
            this.methodMap = methods.length > 5 ? (Map<Object, Object>)HashMapFactory.make(methods.length) : new SmallMap<Selector, IMethod>();
            int i = 0;
            while (i < methods.length) {
                ShrikeCTMethod m = methods[i];
                this.methodMap.put(m.getReference().getSelector(), m);
                ++i;
            }
        }
    }

    private ShrikeCTMethod[] computeDeclaredMethods() throws InvalidClassFileException {
        int methodCount = this.reader.get().getMethodCount();
        ShrikeCTMethod[] result = new ShrikeCTMethod[methodCount];
        int i = 0;
        while (i < methodCount) {
            ShrikeCTMethod m;
            result[i] = m = new ShrikeCTMethod(this, i);
            ++i;
        }
        return result;
    }

    @Override
    public IMethod getMethod(Selector selector) {
        IMethod result;
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        if ((result = this.methodMap.get(selector)) != null) {
            return result;
        }
        if (this.inheritCache != null && (result = this.inheritCache.get(selector)) != null) {
            return result;
        }
        try {
            IMethod inherit;
            ShrikeClass superclass;
            if (!selector.equals(MethodReference.clinitSelector) && !selector.equals(MethodReference.initSelector) && (superclass = (ShrikeClass)this.getSuperclass()) != null && (inherit = superclass.getMethod(selector)) != null) {
                if (this.inheritCache == null) {
                    this.inheritCache = new BimodalMap<Selector, IMethod>(5);
                }
                this.inheritCache.put(selector, inherit);
                return inherit;
            }
        }
        catch (ClassHierarchyException e) {
            Assertions.UNREACHABLE();
        }
        try {
            if (this.isInterface() || this.isAbstract()) {
                for (IClass k : this.getAllImplementedInterfaces()) {
                    result = k.getMethod(selector);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        catch (ClassHierarchyException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE("Bad method lookup in " + this);
        }
        return null;
    }

    @Override
    public IField getField(Atom name) {
        if (this.fieldMap.containsKey(name)) {
            return this.fieldMap.get(name);
        }
        IField f = this.findDeclaredField(name);
        if (f != null) {
            this.fieldMap.put(name, f);
            return f;
        }
        if (this.superClass != null && (f = this.superClass.getField(name)) != null) {
            this.fieldMap.put(name, f);
            return f;
        }
        try {
            for (IClass i : this.getAllImplementedInterfaces()) {
                f = i.getField(name);
                if (f == null) continue;
                this.fieldMap.put(name, f);
                return f;
            }
        }
        catch (ClassHierarchyException classHierarchyException) {
            // empty catch block
        }
        return null;
    }

    private IField findDeclaredField(Atom name) {
        int i = 0;
        while (i < this.instanceFields.length) {
            if (this.instanceFields[i].getName() == name) {
                return this.instanceFields[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.staticFields.length) {
            if (this.staticFields[i].getName() == name) {
                return this.staticFields[i];
            }
            ++i;
        }
        return null;
    }

    private void computeTypeReference() throws InvalidClassFileException {
        String className = "L" + this.reader.get().getName();
        ImmutableByteArray name = ImmutableByteArray.make(className);
        this.typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), TypeName.findOrCreate(name));
    }

    @Override
    public TypeReference getReference() {
        return this.typeReference;
    }

    @Override
    public String getSourceFileName() {
        return this.loader.getSourceFileName(this);
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() throws ClassHierarchyException {
        if (this.allInterfaces != null) {
            return this.allInterfaces;
        }
        Collection<IClass> C = this.computeAllInterfacesAsCollection();
        this.allInterfaces = Collections.unmodifiableCollection(C);
        return this.allInterfaces;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShrikeClass) {
            return this.getReference().equals(((ShrikeClass)obj).getReference());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public ClassReader getReader() {
        try {
            return this.reader.get();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public IMethod getClassInitializer() {
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        return this.methodMap.get(MethodReference.clinitSelector);
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        return Collections.unmodifiableCollection(this.methodMap.values());
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return Collections.unmodifiableList(Arrays.asList(this.instanceFields));
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.unmodifiableList(Arrays.asList(this.staticFields));
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    @Override
    public boolean isReferenceType() {
        return this.getReference().isReferenceType();
    }

    public void clearSoftCaches() {
        if (this.methodMap != null) {
            for (ShrikeCTMethod shrikeCTMethod : this.getDeclaredMethods()) {
                shrikeCTMethod.clearCaches();
            }
        }
        this.inheritCache = null;
        this.allInterfaces = null;
        this.reader.clear();
    }

    @Override
    public Collection<IField> getAllInstanceFields() throws ClassHierarchyException {
        LinkedList<IField> result = new LinkedList<IField>(this.getDeclaredInstanceFields());
        IClass s = this.getSuperclass();
        while (s != null) {
            result.addAll(s.getDeclaredInstanceFields());
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IField> getAllStaticFields() throws ClassHierarchyException {
        LinkedList<IField> result = new LinkedList<IField>(this.getDeclaredStaticFields());
        IClass s = this.getSuperclass();
        while (s != null) {
            result.addAll(s.getDeclaredStaticFields());
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IMethod> getAllMethods() throws ClassHierarchyException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        Iterator<IMethod> declaredMethods = this.getDeclaredMethods().iterator();
        while (declaredMethods.hasNext()) {
            result.add(declaredMethods.next());
        }
        IClass s = this.getSuperclass();
        while (s != null) {
            Iterator<IMethod> superDeclaredMethods = s.getDeclaredMethods().iterator();
            while (superDeclaredMethods.hasNext()) {
                result.add(superDeclaredMethods.next());
            }
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IField> getAllFields() throws ClassHierarchyException {
        LinkedList<IField> result = new LinkedList<IField>();
        result.addAll(this.getAllInstanceFields());
        result.addAll(this.getAllStaticFields());
        return result;
    }

    @Override
    public boolean isPublic() {
        boolean result = (this.modifiers & 1) != 0;
        return result;
    }

    @Override
    public boolean isStatic() {
        boolean result = (this.modifiers & 8) != 0;
        return result;
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException, RuntimeInvisibleAnnotationsReader.UnimplementedException {
        RuntimeInvisibleAnnotationsReader r = this.getRuntimeInvisibleAnnotationsReader();
        if (r != null) {
            int[] offsets = r.getAnnotationOffsets();
            Collection result = HashSetFactory.make();
            int[] nArray = offsets;
            int n = offsets.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                String type = r.getAnnotationType(i);
                type = type.replaceAll(";", "");
                TypeReference t = TypeReference.findOrCreate(this.getClassLoader().getReference(), type);
                result.add(Annotation.make(t));
                ++n2;
            }
            return result;
        }
        return Collections.emptySet();
    }

    private RuntimeInvisibleAnnotationsReader getRuntimeInvisibleAnnotationsReader() throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        RuntimeInvisibleAnnotationsReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().toString().equals("RuntimeInvisibleAnnotations")) {
                    result = new RuntimeInvisibleAnnotationsReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private RuntimeInvisibleAnnotationsReader getRuntimeInvisibleAnnotationsReader(int fieldIndex) throws InvalidClassFileException {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.reader.get().initFieldAttributeIterator(fieldIndex, iter);
        RuntimeInvisibleAnnotationsReader result = null;
        try {
            while (iter.isValid()) {
                if (iter.getName().toString().equals("RuntimeInvisibleAnnotations")) {
                    result = new RuntimeInvisibleAnnotationsReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations(int fieldIndex) throws InvalidClassFileException, RuntimeInvisibleAnnotationsReader.UnimplementedException {
        RuntimeInvisibleAnnotationsReader r = this.getRuntimeInvisibleAnnotationsReader(fieldIndex);
        if (r != null) {
            int[] offsets = r.getAnnotationOffsets();
            Collection result = HashSetFactory.make();
            int[] nArray = offsets;
            int n = offsets.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                String type = r.getAnnotationType(i);
                type = type.replaceAll(";", "");
                TypeReference t = TypeReference.findOrCreate(this.getClassLoader().getReference(), type);
                result.add(Annotation.make(t));
                ++n2;
            }
            return result;
        }
        return Collections.emptySet();
    }

    private SignatureReader getSignatureReader() throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        SignatureReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().toString().equals("Signature")) {
                    result = new SignatureReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    public ClassSignature getClassSignature() throws InvalidClassFileException {
        SignatureReader r = this.getSignatureReader();
        if (r == null) {
            return null;
        }
        return ClassSignature.make(r.getSignature());
    }

    public ModuleEntry getModuleEntry() {
        return this.reader.getModuleEntry();
    }

    private static class ClassNotFoundWarning
    extends Warning {
        final ImmutableByteArray className;

        ClassNotFoundWarning(ImmutableByteArray className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static ClassNotFoundWarning create(ImmutableByteArray className) {
            return new ClassNotFoundWarning(className);
        }
    }
}

