/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.io.FileSuffixes;
import java.io.File;

public class SourceFileModule
extends FileModule
implements Module,
ModuleEntry {
    private final String fileName;

    public SourceFileModule(File f, String fileName) {
        super(f);
        this.fileName = fileName;
    }

    public SourceFileModule(File f, SourceFileModule clonedFrom) {
        super(f);
        if (clonedFrom == null) {
            throw new IllegalArgumentException("clonedFrom is null");
        }
        this.fileName = clonedFrom.fileName;
    }

    public String toString() {
        return "SourceFileModule:" + this.getFile().toString();
    }

    public boolean isClassFile() {
        return false;
    }

    public String getClassName() {
        return FileSuffixes.stripSuffix(this.fileName).replace(File.separator.charAt(0), '/');
    }

    public boolean isSourceFile() {
        return true;
    }
}

