/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.client.impl;

import com.ibm.wala.analysis.pointers.BasicHeapGraph;
import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AnalysisEngine;
import com.ibm.wala.client.CallGraphBuilderFactory;
import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerFlowGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerFlowGraphFactory;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalysisEngine
implements AnalysisEngine {
    public static final String SYNTHETIC_J2SE_MODEL = "SyntheticJ2SEModel.txt";
    protected static final int DEBUG_LEVEL = 1;
    private String exclusionsFile = "J2SEClassHierarchyExclusions.txt";
    protected Collection moduleFiles;
    protected AnalysisScope scope;
    private AnalysisOptions options;
    private AnalysisCache cache = this.makeDefaultCache();
    protected Module[] j2seLibs;
    private boolean closedWorld = false;
    private CallGraphBuilderFactory callGraphBuilderFactory;
    private IClassHierarchy cha;
    protected CallGraph cg;
    protected PointerAnalysis pointerAnalysis;
    private PointerFlowGraphFactory pointerFlowGraphFactory;
    private PointerFlowGraph pointerFlowGraph;
    private HeapGraph heapGraph;
    private EntrypointBuilder entrypointBuilder = new EntrypointBuilder(){

        @Override
        public Iterable<Entrypoint> createEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
            return AbstractAnalysisEngine.this.makeDefaultEntrypoints(scope, cha);
        }
    };

    protected CallGraphBuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        return this.getCallGraphBuilderFactory().make(options, cache, cha, this.getScope(), false);
    }

    protected CallGraphBuilder buildCallGraph(IClassHierarchy cha, AnalysisOptions options, boolean savePointerAnalysis) throws IllegalArgumentException, CancelException {
        Assertions.productionAssertion(this.getCallGraphBuilderFactory() != null, "must initialize callGraphBuilderFactory!");
        CallGraphBuilder builder = this.getCallGraphBuilder(cha, options, this.cache);
        this.cg = builder.makeCallGraph(options);
        if (savePointerAnalysis) {
            this.pointerFlowGraphFactory = builder.getPointerFlowGraphFactory();
            this.pointerAnalysis = builder.getPointerAnalysis();
        }
        return builder;
    }

    @Override
    public void setModuleFiles(Collection moduleFiles) {
        this.moduleFiles = moduleFiles;
    }

    protected void buildAnalysisScope() throws IOException {
        if (this.j2seLibs == null) {
            Assertions.UNREACHABLE("no j2selibs specified. You probably did not call AppAnalysisEngine.setJ2SELibrary.");
        }
        this.scope = AnalysisScopeReader.read(SYNTHETIC_J2SE_MODEL, new File(this.getExclusionsFile()), this.getClass().getClassLoader());
        int i = 0;
        while (i < this.j2seLibs.length) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), this.j2seLibs[i]);
            ++i;
        }
        this.addApplicationModulesToScope();
    }

    public IClassHierarchy buildClassHierarchy() {
        ClassHierarchy cha = null;
        ClassLoaderFactoryImpl factory = new ClassLoaderFactoryImpl(this.getScope().getExclusions());
        try {
            cha = ClassHierarchy.make(this.getScope(), factory);
        }
        catch (ClassHierarchyException e) {
            System.err.println("Class Hierarchy construction failed");
            System.err.println(e.toString());
            e.printStackTrace();
        }
        return cha;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    protected void setClassHierarchy(IClassHierarchy cha) {
        this.cha = cha;
    }

    protected CallGraph getCallGraph() {
        return this.cg;
    }

    protected void addApplicationModulesToScope() {
        ClassLoaderReference app = this.scope.getApplicationLoader();
        for (Object o : this.moduleFiles) {
            if (!(o instanceof Module)) {
                Assertions.UNREACHABLE("Unexpected type: " + o.getClass());
            }
            Module M = (Module)o;
            this.scope.addToScope(app, M);
        }
    }

    @Override
    public void setJ2SELibraries(JarFile[] libs) {
        if (libs == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = new Module[libs.length];
        int i = 0;
        while (i < libs.length) {
            this.j2seLibs[i] = new JarFileModule(libs[i]);
            ++i;
        }
    }

    @Override
    public void setJ2SELibraries(Module[] libs) {
        if (libs == null) {
            throw new IllegalArgumentException("libs is null");
        }
        this.j2seLibs = new Module[libs.length];
        int i = 0;
        while (i < libs.length) {
            this.j2seLibs[i] = libs[i];
            ++i;
        }
    }

    @Override
    public void setClosedWorld(boolean b) {
        this.closedWorld = b;
    }

    public boolean isClosedWorld() {
        return this.closedWorld;
    }

    protected AnalysisScope getScope() {
        return this.scope;
    }

    protected CallGraphBuilderFactory getCallGraphBuilderFactory() {
        return this.callGraphBuilderFactory;
    }

    protected void setCallGraphBuilderFactory(CallGraphBuilderFactory callGraphBuilderFactory) {
        this.callGraphBuilderFactory = callGraphBuilderFactory;
    }

    public PointerAnalysis getPointerAnalysis() {
        return this.pointerAnalysis;
    }

    public PointerFlowGraph getPointerFlowGraph() {
        if (this.pointerFlowGraph == null) {
            this.pointerFlowGraph = this.pointerFlowGraphFactory.make(this.pointerAnalysis, this.cg);
        }
        return this.pointerFlowGraph;
    }

    public HeapGraph getHeapGraph() {
        if (this.heapGraph == null) {
            this.heapGraph = new BasicHeapGraph(this.getPointerAnalysis(), this.cg);
        }
        return this.heapGraph;
    }

    public String getExclusionsFile() {
        return this.exclusionsFile;
    }

    public void setExclusionsFile(String exclusionsFile) {
        this.exclusionsFile = exclusionsFile;
    }

    @Override
    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> entrypoints) {
        return new AnalysisOptions(this.getScope(), entrypoints);
    }

    public AnalysisCache makeDefaultCache() {
        return new AnalysisCache(new DefaultIRFactory());
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return Util.makeMainEntrypoints(scope, cha);
    }

    public void setEntrypointBuilder(EntrypointBuilder builder) {
        this.entrypointBuilder = builder;
    }

    public CallGraphBuilder defaultCallGraphBuilder() throws IllegalArgumentException, CancelException, IOException {
        this.buildAnalysisScope();
        IClassHierarchy cha = this.buildClassHierarchy();
        this.setClassHierarchy(cha);
        Iterable<Entrypoint> eps = this.entrypointBuilder.createEntrypoints(this.scope, cha);
        this.options = this.getDefaultOptions(eps);
        this.cache = this.makeDefaultCache();
        return this.buildCallGraph(cha, this.options, true);
    }

    public CallGraph buildDefaultCallGraph() throws IllegalArgumentException, CancelException, IOException {
        return this.defaultCallGraphBuilder().makeCallGraph(this.options);
    }

    public AnalysisCache getCache() {
        return this.cache;
    }

    public AnalysisOptions getOptions() {
        return this.options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntrypointBuilder {
        public Iterable<Entrypoint> createEntrypoints(AnalysisScope var1, IClassHierarchy var2);
    }
}

