/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackwardsSupergraph<T, P>
implements ISupergraph<T, P> {
    static final int DEBUG_LEVEL = 0;
    private final ISupergraph<T, P> delegate;
    private final ExitFilter exitFilter = new ExitFilter();

    protected BackwardsSupergraph(ISupergraph<T, P> forwardGraph) {
        this.delegate = forwardGraph;
    }

    public static <T, P> BackwardsSupergraph<T, P> make(ISupergraph<T, P> forwardGraph) {
        return new BackwardsSupergraph<T, P>(forwardGraph);
    }

    @Override
    public Graph<? extends P> getProcedureGraph() {
        return this.delegate.getProcedureGraph();
    }

    @Override
    public P getMain() throws UnsupportedOperationException {
        return this.delegate.getMain();
    }

    @Override
    public boolean isCall(T n) {
        return this.delegate.isReturn(n);
    }

    @Override
    public Iterator<T> getCalledNodes(T ret) {
        return new FilterIterator(this.getSuccNodes(ret), this.exitFilter);
    }

    @Override
    public Iterator<T> getNormalSuccessors(final T ret) {
        Iterator<T> allPreds = this.delegate.getPredNodes(ret);
        Filter sameProc = new Filter<T>(){

            @Override
            public boolean accepts(T o) {
                return BackwardsSupergraph.this.getProcOf(ret).equals(BackwardsSupergraph.this.getProcOf(o)) && !BackwardsSupergraph.this.delegate.isExit(o);
            }
        };
        FilterIterator sameProcPreds = new FilterIterator(allPreds, sameProc);
        Filter notCall = new Filter<T>(){

            @Override
            public boolean accepts(T o) {
                return !BackwardsSupergraph.this.delegate.isCall(o);
            }
        };
        return new FilterIterator(sameProcPreds, notCall);
    }

    @Override
    public Iterator<? extends T> getReturnSites(T c) {
        return this.delegate.getCallSites(c);
    }

    @Override
    public boolean isExit(T n) {
        return this.delegate.isEntry(n);
    }

    @Override
    public P getProcOf(T n) {
        return this.delegate.getProcOf(n);
    }

    @Override
    public void removeNodeAndEdges(Object N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public void addNode(Object n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(Object n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(T N) {
        return this.delegate.containsNode(N);
    }

    @Override
    public Iterator<? extends T> getPredNodes(T N) {
        return this.delegate.getSuccNodes(N);
    }

    @Override
    public int getPredNodeCount(T N) {
        return this.delegate.getSuccNodeCount(N);
    }

    @Override
    public Iterator<? extends T> getSuccNodes(T N) {
        return this.delegate.getPredNodes(N);
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        return this.delegate.hasEdge(dst, src);
    }

    @Override
    public int getSuccNodeCount(T N) {
        return this.delegate.getPredNodeCount(N);
    }

    @Override
    public void addEdge(Object src, Object dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(Object src, Object dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(Object node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T[] getEntriesForProcedure(P object) {
        return this.delegate.getExitsForProcedure(object);
    }

    @Override
    public T[] getExitsForProcedure(P object) {
        return this.delegate.getEntriesForProcedure(object);
    }

    @Override
    public T getMainEntry() {
        return this.delegate.getMainExit();
    }

    @Override
    public T getMainExit() {
        return this.delegate.getMainEntry();
    }

    @Override
    public boolean isReturn(T n) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public Iterator<? extends T> getCallSites(T r) {
        return this.delegate.getReturnSites(r);
    }

    @Override
    public boolean isEntry(T n) {
        return this.delegate.isExit(n);
    }

    @Override
    public byte classifyEdge(T src, T dest) {
        byte d = this.delegate.classifyEdge(dest, src);
        switch (d) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public String toString() {
        return "Backwards of delegate\n" + this.delegate;
    }

    @Override
    public void removeIncomingEdges(Object node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(T node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfBlocks(P procedure) {
        return this.delegate.getNumberOfBlocks(procedure);
    }

    @Override
    public int getLocalBlockNumber(T n) {
        return this.delegate.getLocalBlockNumber(n);
    }

    @Override
    public T getLocalBlock(P procedure, int i) {
        return this.delegate.getLocalBlock(procedure, i);
    }

    @Override
    public int getNumber(T N) {
        return this.delegate.getNumber(N);
    }

    @Override
    public T getNode(int number) {
        return this.delegate.getNode(number);
    }

    @Override
    public int getMaxNumber() {
        return this.delegate.getMaxNumber();
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) {
        return this.delegate.getPredNodeNumbers(node);
    }

    @Override
    public IntSet getPredNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    private class ExitFilter
    implements Filter {
        private ExitFilter() {
        }

        public boolean accepts(Object o) {
            return BackwardsSupergraph.this.delegate.isExit(o);
        }
    }
}

