/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.SparseVector;

public class CallFlowEdges {
    private final SparseVector<IBinaryNaturalRelation> edges = new SparseVector(1, 1.1f);
    private final SparseVector<IntSet> identityEdges = new SparseVector(1, 1.1f);

    public void addCallEdge(int c, int d1, int d2) {
        if (d1 == d2) {
            BitVectorIntSet s = (BitVectorIntSet)this.identityEdges.get(d1);
            if (s == null) {
                s = new BitVectorIntSet();
                this.identityEdges.set(d1, s);
            }
            s.add(c);
        } else {
            IBinaryNaturalRelation R = this.edges.get(c);
            if (R == null) {
                R = new BasicNaturalRelation(new byte[]{2}, 1);
                this.edges.set(c, R);
            }
            R.add(d2, d1);
        }
    }

    public IntSet getCallFlowSources(int c, int d2) {
        BitVectorIntSet s = (BitVectorIntSet)this.identityEdges.get(d2);
        IBinaryNaturalRelation R = this.edges.get(c);
        IntSet result = null;
        if (R == null) {
            if (s != null) {
                result = s.contains(c) ? SparseIntSet.singleton(d2) : null;
            }
        } else if (s == null) {
            result = R.getRelated(d2);
        } else if (s.contains(c)) {
            if (R.getRelated(d2) == null) {
                result = SparseIntSet.singleton(d2);
            } else {
                result = MutableSparseIntSet.make(R.getRelated(d2));
                ((MutableSparseIntSet)result).add(d2);
            }
        } else {
            result = R.getRelated(d2);
        }
        return result;
    }
}

