/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.ExplodedSupergraphNode;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedSupergraph<T>
implements Graph<ExplodedSupergraphNode<T>> {
    private final ISupergraph<T, ?> supergraph;
    private final IFlowFunctionMap<T> flowFunctions;

    public ExplodedSupergraph(ISupergraph<T, ?> supergraph, IFlowFunctionMap<T> flowFunctions) {
        this.supergraph = supergraph;
        this.flowFunctions = flowFunctions;
    }

    @Override
    public void removeNodeAndEdges(ExplodedSupergraphNode N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ExplodedSupergraphNode<T>> iterator() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getNumberOfNodes() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public void addNode(ExplodedSupergraphNode n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNode(ExplodedSupergraphNode n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(ExplodedSupergraphNode N) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public Iterator<ExplodedSupergraphNode<T>> getPredNodes(ExplodedSupergraphNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        T dest = node.getSupergraphNode();
        HashSet result = HashSetFactory.make(this.supergraph.getPredNodeCount(dest));
        Iterator<T> it = this.supergraph.getPredNodes(dest);
        while (it.hasNext()) {
            T src = it.next();
            if (this.supergraph.classifyEdge(src, dest) != 1) {
                IFlowFunction f = this.getFlowFunction(src, dest);
                if (f instanceof IReversibleFlowFunction) {
                    IReversibleFlowFunction rf = (IReversibleFlowFunction)f;
                    IntSet sources = rf.getSources(node.getFact());
                    if (sources == null) continue;
                    IntIterator ii = sources.intIterator();
                    while (ii.hasNext()) {
                        int t = ii.next();
                        result.add(new ExplodedSupergraphNode<T>(src, t));
                    }
                    continue;
                }
                Assertions.UNREACHABLE("need to implement for non-reversible flow function " + f.getClass());
                continue;
            }
            Iterator<T> it2 = this.supergraph.getCallSites(dest);
            while (it2.hasNext()) {
                T callBlock = it2.next();
                IFlowFunction f = this.flowFunctions.getReturnFlowFunction(callBlock, src, dest);
                if (f instanceof IReversibleFlowFunction) {
                    IReversibleFlowFunction rf = (IReversibleFlowFunction)f;
                    IntSet sources = rf.getSources(node.getFact());
                    if (sources == null) continue;
                    IntIterator ii = sources.intIterator();
                    while (ii.hasNext()) {
                        int t = ii.next();
                        result.add(new ExplodedSupergraphNode<T>(src, t));
                    }
                    continue;
                }
                Assertions.UNREACHABLE("need to implement for non-reversible flow function " + f.getClass());
            }
        }
        return result.iterator();
    }

    @Override
    public int getPredNodeCount(ExplodedSupergraphNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        T dest = node.getSupergraphNode();
        int count = 0;
        Iterator<T> it = this.supergraph.getPredNodes(dest);
        while (it.hasNext()) {
            T src = it.next();
            if (this.supergraph.classifyEdge(src, dest) != 1) {
                IFlowFunction f = this.getFlowFunction(src, dest);
                if (f instanceof IReversibleFlowFunction) {
                    IReversibleFlowFunction rf = (IReversibleFlowFunction)f;
                    IntSet sources = rf.getSources(node.getFact());
                    if (sources == null) continue;
                    count += sources.size();
                    continue;
                }
                Assertions.UNREACHABLE("need to implement for non-reversible flow function");
                continue;
            }
            Assertions.UNREACHABLE("TODO: Implement me!");
        }
        return count;
    }

    @Override
    public Iterator<ExplodedSupergraphNode<T>> getSuccNodes(ExplodedSupergraphNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        T src = node.getSupergraphNode();
        HashSet result = HashSetFactory.make(this.supergraph.getSuccNodeCount(src));
        Iterator<T> it = this.supergraph.getSuccNodes(src);
        while (it.hasNext()) {
            T dest = it.next();
            if (this.supergraph.classifyEdge(src, dest) != 1) {
                IUnaryFlowFunction f = (IUnaryFlowFunction)this.getFlowFunction(src, dest);
                IntSet targets = f.getTargets(node.getFact());
                if (targets == null) continue;
                IntIterator ii = targets.intIterator();
                while (ii.hasNext()) {
                    int t = ii.next();
                    result.add(new ExplodedSupergraphNode<T>(dest, t));
                }
                continue;
            }
            Iterator<T> it2 = this.supergraph.getCallSites(dest);
            while (it2.hasNext()) {
                T callBlock = it2.next();
                IUnaryFlowFunction f = (IUnaryFlowFunction)this.flowFunctions.getReturnFlowFunction(callBlock, src, dest);
                IntSet targets = f.getTargets(node.getFact());
                if (targets == null) continue;
                IntIterator ii = targets.intIterator();
                while (ii.hasNext()) {
                    int t = ii.next();
                    result.add(new ExplodedSupergraphNode<T>(dest, t));
                }
            }
        }
        return result.iterator();
    }

    private IFlowFunction getFlowFunction(T src, T dest) {
        switch (this.supergraph.classifyEdge(src, dest)) {
            case 0: {
                return this.flowFunctions.getCallFlowFunction(src, dest);
            }
            case 2: {
                Iterator<T> callees = this.supergraph.getCalledNodes(src);
                if (callees.hasNext()) {
                    return this.flowFunctions.getCallToReturnFlowFunction(src, dest);
                }
                return this.flowFunctions.getCallNoneToReturnFlowFunction(src, dest);
            }
            case 1: {
                Assertions.UNREACHABLE();
                return null;
            }
            case 3: {
                return this.flowFunctions.getNormalFlowFunction(src, dest);
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getSuccNodeCount(ExplodedSupergraphNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        T src = node.getSupergraphNode();
        int count = 0;
        Iterator<T> it = this.supergraph.getSuccNodes(src);
        while (it.hasNext()) {
            T dest = it.next();
            IUnaryFlowFunction f = (IUnaryFlowFunction)this.getFlowFunction(src, dest);
            IntSet targets = f.getTargets(node.getFact());
            if (targets == null) continue;
            count += targets.size();
        }
        return count;
    }

    @Override
    public void addEdge(ExplodedSupergraphNode src, ExplodedSupergraphNode dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(ExplodedSupergraphNode src, ExplodedSupergraphNode dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllIncidentEdges(ExplodedSupergraphNode node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIncomingEdges(ExplodedSupergraphNode node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOutgoingEdges(ExplodedSupergraphNode node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasEdge(ExplodedSupergraphNode<T> src, ExplodedSupergraphNode<T> dst) {
        Iterator<ExplodedSupergraphNode<T>> it = this.getSuccNodes(src);
        while (it.hasNext()) {
            if (!((Object)it.next()).equals(dst)) continue;
            return true;
        }
        return false;
    }

    public ISupergraph<T, ?> getSupergraph() {
        return this.supergraph;
    }

    public IFlowFunctionMap getFlowFunctions() {
        return this.flowFunctions;
    }
}

