/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.ExplodedSupergraphNode;
import com.ibm.wala.dataflow.IFDS.ExplodedSupergraphWithSummaryEdges;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.PartiallyCollapsedSupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.util.CollectionFilter;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.BFSPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedSupergraphPath<T> {
    private static final boolean DEBUG = false;
    private final List<ExplodedSupergraphNode<T>> outermostList;
    private final Map<Pair, List<ExplodedSupergraphNode<T>>> edge2SLVP = HashMapFactory.make();
    private boolean skipBoringCalls = false;
    private final ExplodedSupergraphWithSummaryEdges<T> esg;
    private static final Filter zeroFactFilter = new Filter(){

        public boolean accepts(Object o) {
            ExplodedSupergraphNode node = (ExplodedSupergraphNode)o;
            return node.getFact() == 0;
        }
    };

    private ExplodedSupergraphPath(List<ExplodedSupergraphNode<T>> nodeList, ExplodedSupergraphWithSummaryEdges<T> esg) {
        this.outermostList = nodeList;
        this.esg = esg;
    }

    private List<ExplodedSupergraphNode<T>> findOrCreateSLVP(ExplodedSupergraphNode<T> src, ExplodedSupergraphNode<T> dest, Stack<CGNode> callStack) {
        Pair<ExplodedSupergraphNode<T>, ExplodedSupergraphNode<T>> p = Pair.make(src, dest);
        List<ExplodedSupergraphNode<T>> l = this.edge2SLVP.get(p);
        if (l != null && !this.validInCallStack(l, callStack)) {
            l = null;
        }
        if (l == null && (l = this.computeSummarySLVP(src, dest, callStack)) != null) {
            this.edge2SLVP.put(p, l);
        }
        return l;
    }

    private boolean validInCallStack(List<ExplodedSupergraphNode<T>> l, Stack<CGNode> callStack) {
        for (ExplodedSupergraphNode<T> src : l) {
            if (!callStack.contains(this.esg.getSupergraph().getProcOf(src.getSupergraphNode()))) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return new PathIterator();
    }

    public static <T> ExplodedSupergraphPath<T> findRealizablePath(ExplodedSupergraphWithSummaryEdges<T> esg, ExplodedSupergraphNode<T> sink) {
        NoReturnBackwardsPathFinder<T> backwardsFinder = new NoReturnBackwardsPathFinder<T>(esg, sink);
        List<ExplodedSupergraphNode<T>> L = backwardsFinder.find();
        if (L == null) {
            return null;
        }
        ExplodedSupergraphPath<T> result = new ExplodedSupergraphPath<T>(L, esg);
        return result;
    }

    private List<ExplodedSupergraphNode<T>> computeSummarySLVP(ExplodedSupergraphNode<T> src, ExplodedSupergraphNode<T> dest, Collection<CGNode> callStack) {
        HashSet calledTargets = HashSetFactory.make(3);
        Iterator<ExplodedSupergraphNode<T>> it = this.esg.getSuccNodes(src);
        while (it.hasNext()) {
            ExplodedSupergraphNode<T> target = it.next();
            if (this.esg.getSupergraph().classifyEdge(src.getSupergraphNode(), target.getSupergraphNode()) != 0) continue;
            calledTargets.add(target);
        }
        HashSet calledExitNodes = HashSetFactory.make(3);
        Iterator<ExplodedSupergraphNode<T>> it2 = this.esg.getPredNodes(dest);
        while (it2.hasNext()) {
            ExplodedSupergraphNode<T> target = it2.next();
            if (this.esg.getSupergraph().classifyEdge(target.getSupergraphNode(), dest.getSupergraphNode()) != 1) continue;
            calledExitNodes.add(target);
        }
        if (calledTargets.isEmpty() || calledExitNodes.isEmpty()) {
            return null;
        }
        SLVPFinder<T> innerFinder = new SLVPFinder<T>(this.esg, calledTargets, calledExitNodes, callStack);
        List<ExplodedSupergraphNode<T>> subList = innerFinder.find();
        return subList;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Outermost List: \n");
        if (this.outermostList == null) {
            return "null outermost list";
        }
        this.appendNumberedList(result, this.outermostList.iterator());
        for (Map.Entry<Pair, List<ExplodedSupergraphNode<T>>> e : this.edge2SLVP.entrySet()) {
            Pair p = e.getKey();
            result.append("SLVP for " + p + "\n");
            List<ExplodedSupergraphNode<T>> l = e.getValue();
            this.appendNumberedList(result, l.iterator());
        }
        return result.toString();
    }

    private void appendNumberedList(StringBuffer result, Iterator it) {
        int i = 0;
        while (it.hasNext()) {
            ExplodedSupergraphNode n = (ExplodedSupergraphNode)it.next();
            result.append(String.valueOf(++i) + "   " + n + "\n");
        }
    }

    public static <T> ExplodedSupergraphPath<T> summarize(ISupergraph<T, ?> supergraph, ExplodedSupergraphPath<T> path) {
        ExplodedSupergraphPath.pruneForCallReturn(supergraph, path);
        ExplodedSupergraphPath.pruneBoringCalls(path);
        return path;
    }

    public static <T> void pruneBoringCalls(ExplodedSupergraphPath<T> path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        path.skipBoringCalls = true;
    }

    public static <T> void pruneForCallReturn(ISupergraph<T, ?> supergraph, ExplodedSupergraphPath<T> path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        ExplodedSupergraphPath.pruneListForCallReturn(supergraph, path.outermostList);
        for (List<ExplodedSupergraphNode<T>> l : path.edge2SLVP.values()) {
            ExplodedSupergraphPath.pruneListForCallReturn(supergraph, l);
        }
    }

    public static <T> List<ExplodedSupergraphNode<T>> pruneListForCallReturn(ISupergraph<T, ?> supergraph, List<ExplodedSupergraphNode<T>> L) throws IllegalArgumentException {
        if (L == null) {
            throw new IllegalArgumentException("L == null");
        }
        int i = 0;
        while (i < L.size()) {
            ExplodedSupergraphNode<T> n = L.get(i);
            if (!(supergraph.isEntry(n.getSupergraphNode()) || supergraph.isExit(n.getSupergraphNode()) || supergraph.isCall(n.getSupergraphNode()) || supergraph.isReturn(n.getSupergraphNode()))) {
                L.remove(i);
                --i;
            }
            ++i;
        }
        return L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoReturnBackwardsPathFinder<T>
    extends BFSPathFinder<ExplodedSupergraphNode<T>> {
        final ExplodedSupergraphWithSummaryEdges<T> esg;

        NoReturnBackwardsPathFinder(ExplodedSupergraphWithSummaryEdges<T> esg, ExplodedSupergraphNode<T> sink) {
            super(GraphInverter.invert(esg), Collections.singleton(sink).iterator(), zeroFactFilter);
            this.esg = esg;
        }

        @Override
        protected Iterator<ExplodedSupergraphNode<T>> getConnected(ExplodedSupergraphNode<T> n) {
            ExplodedSupergraphNode<T> src = n;
            PartiallyCollapsedSupergraph supergraph = (PartiallyCollapsedSupergraph)this.esg.getSupergraph();
            HashSet result = HashSetFactory.make(this.esg.getPredNodeCount(n));
            Iterator<ExplodedSupergraphNode<T>> it = super.getConnected(n);
            while (it.hasNext()) {
                ExplodedSupergraphNode<T> dest = it.next();
                switch (supergraph.classifyEdge((Object)dest.getSupergraphNode(), (Object)src.getSupergraphNode())) {
                    case 1: {
                        break;
                    }
                    default: {
                        result.add(dest);
                    }
                }
            }
            return result.iterator();
        }
    }

    private final class PathIterator
    implements Iterator {
        private final Iterator it;

        public void remove() {
            Assertions.UNREACHABLE();
        }

        PathIterator() {
            Stack<CGNode> callStack = new Stack<CGNode>();
            ArrayList L = new ArrayList(ExplodedSupergraphPath.this.outermostList);
            int i = 0;
            while (i < L.size() - 1) {
                CGNode srcNode;
                ExplodedSupergraphNode src = (ExplodedSupergraphNode)L.get(i);
                ExplodedSupergraphNode dest = (ExplodedSupergraphNode)L.get(i + 1);
                if (ExplodedSupergraphPath.this.esg.getSupergraph().isExit(src.getSupergraphNode())) {
                    if (!callStack.isEmpty()) {
                        callStack.pop();
                    }
                } else if ((!ExplodedSupergraphPath.this.skipBoringCalls || src.getFact() != dest.getFact()) && ExplodedSupergraphPath.this.esg.getSupergraph().isCall(src.getSupergraphNode()) && ExplodedSupergraphPath.this.esg.getSupergraph().getProcOf(src.getSupergraphNode()).equals(ExplodedSupergraphPath.this.esg.getSupergraph().getProcOf(dest.getSupergraphNode())) && !callStack.contains(srcNode = (CGNode)ExplodedSupergraphPath.this.esg.getSupergraph().getProcOf(src.getSupergraphNode()))) {
                    callStack.push(srcNode);
                    List slvp = ExplodedSupergraphPath.this.findOrCreateSLVP(src, dest, callStack);
                    if (slvp != null) {
                        L.addAll(i + 1, ExplodedSupergraphPath.this.findOrCreateSLVP(src, dest, callStack));
                    }
                }
                ++i;
            }
            this.it = L.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            return this.it.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SLVPFinder<T>
    extends BFSPathFinder<ExplodedSupergraphNode<T>> {
        final ExplodedSupergraphWithSummaryEdges esg;
        final Collection<CGNode> exclusions;

        SLVPFinder(ExplodedSupergraphWithSummaryEdges<T> esg, Collection<ExplodedSupergraphNode<T>> sources, Collection<ExplodedSupergraphNode<T>> sinks, Collection<CGNode> exclusions) {
            super(esg, sources.iterator(), new CollectionFilter<ExplodedSupergraphNode<T>>(sinks));
            this.esg = esg;
            this.exclusions = exclusions;
        }

        @Override
        protected Iterator<ExplodedSupergraphNode<T>> getConnected(final ExplodedSupergraphNode<T> n) {
            return new FilterIterator<ExplodedSupergraphNode<T>>(super.getConnected(n), new Filter(){

                public boolean accepts(Object o) {
                    ExplodedSupergraphNode dest = (ExplodedSupergraphNode)o;
                    return SLVPFinder.this.sameProc(n, dest) && !SLVPFinder.this.exclusions.contains(SLVPFinder.this.esg.getSupergraph().getProcOf(n.getSupergraphNode()));
                }
            });
        }

        private final boolean sameProc(ExplodedSupergraphNode<T> a, ExplodedSupergraphNode<T> b) {
            PartiallyCollapsedSupergraph supergraph = (PartiallyCollapsedSupergraph)this.esg.getSupergraph();
            return supergraph.getProcOf((Object)a.getSupergraphNode()).equals(supergraph.getProcOf((Object)b.getSupergraphNode()));
        }

        @Override
        public List<ExplodedSupergraphNode<T>> find() {
            List<ExplodedSupergraphNode<T>> L = super.find();
            if (L == null) {
                return L;
            }
            Collections.reverse(L);
            return L;
        }
    }
}

