/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.dataflow.IFDS.ExplodedSupergraph;
import com.ibm.wala.dataflow.IFDS.ExplodedSupergraphNode;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.TabulationSolver;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedSupergraphWithSummaryEdges<T>
extends ExplodedSupergraph<T> {
    private final TabulationSolver<T, ?> solver;

    public ExplodedSupergraphWithSummaryEdges(ISupergraph<T, ?> supergraph, IFlowFunctionMap<T> flowFunctions, TabulationSolver<T, ?> solver) {
        super(supergraph, flowFunctions);
        this.solver = solver;
    }

    @Override
    public Iterator<ExplodedSupergraphNode<T>> getSuccNodes(ExplodedSupergraphNode<T> src) {
        if (src == null) {
            throw new IllegalArgumentException("src is null");
        }
        HashSet result = HashSetFactory.make(5);
        result.addAll(Iterator2Collection.toCollection(super.getSuccNodes(src)));
        if (this.getSupergraph().isCall(src.getSupergraphNode())) {
            Iterator it = this.getSupergraph().getReturnSites(src.getSupergraphNode());
            while (it.hasNext()) {
                Object dest = it.next();
                Assertions.UNREACHABLE();
                IntSet summary = null;
                if (summary == null) continue;
                IntIterator ii = summary.intIterator();
                while (ii.hasNext()) {
                    int d2 = ii.next();
                    result.add(new ExplodedSupergraphNode(dest, d2));
                }
            }
        }
        return result.iterator();
    }

    @Override
    public Iterator<ExplodedSupergraphNode<T>> getPredNodes(ExplodedSupergraphNode<T> dest) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        HashSet result = HashSetFactory.make(5);
        result.addAll(Iterator2Collection.toCollection(super.getPredNodes(dest)));
        if (this.getSupergraph().isReturn(dest.getSupergraphNode())) {
            Iterator it = this.getSupergraph().getCallSites(dest.getSupergraphNode());
            while (it.hasNext()) {
                Object src = it.next();
                IntSet summary = this.solver.getSummarySources(dest.getSupergraphNode(), dest.getFact(), src);
                if (summary == null) continue;
                IntIterator ii = summary.intIterator();
                while (ii.hasNext()) {
                    int d1 = ii.next();
                    result.add(new ExplodedSupergraphNode(src, d1));
                }
            }
        }
        return result.iterator();
    }

    @Override
    public int getPredNodeCount(ExplodedSupergraphNode<T> N) {
        return Iterator2Collection.toCollection(this.getPredNodes(N)).size();
    }

    @Override
    public int getSuccNodeCount(ExplodedSupergraphNode<T> N) {
        return Iterator2Collection.toCollection(this.getSuccNodes(N)).size();
    }
}

