/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.InterproceduralCFG;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.util.CollectionFilter;
import com.ibm.wala.util.CompoundIterator;
import com.ibm.wala.util.IndiscriminateFilter;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Filtersection;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartiallyCollapsedSupergraph
extends AbstractGraph<Object>
implements ISupergraph<Object, CGNode> {
    static final int DEBUG_LEVEL = 0;
    private final NodeManager nodeManager;
    private final EdgeManager edgeManager;
    private final CallGraph cg;
    private final InterproceduralCFG partialIPFG;
    private final Collection<CGNode> noCollapse;
    private final Filter isEntry = new Filter(){

        public boolean accepts(Object o) {
            return PartiallyCollapsedSupergraph.this.isEntry(o);
        }
    };

    @Override
    public Graph<CGNode> getProcedureGraph() {
        return this.cg;
    }

    public PartiallyCollapsedSupergraph(CallGraph cg, Collection<CGNode> noCollapse) {
        this(cg, noCollapse, IndiscriminateFilter.singleton());
    }

    public PartiallyCollapsedSupergraph(CallGraph cg, Collection<CGNode> noCollapse, Filter<CGNode> relevant) {
        this.cg = cg;
        this.noCollapse = noCollapse;
        this.partialIPFG = new InterproceduralCFG(cg, new Filtersection<CGNode>(relevant, new CollectionFilter<CGNode>(noCollapse)));
        this.nodeManager = new NodeManager();
        this.edgeManager = new EdgeManager();
    }

    @Override
    protected com.ibm.wala.util.graph.NodeManager<Object> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    protected com.ibm.wala.util.graph.EdgeManager<Object> getEdgeManager() {
        return this.edgeManager;
    }

    @Override
    public CGNode getMain() {
        return this.cg.getFakeRootNode();
    }

    public Object getEntryForProcedure(CGNode n) {
        Assertions._assert(n != null);
        if (this.noCollapse.contains(n)) {
            return this.partialIPFG.getEntry(n);
        }
        return this.nodeManager.getCollapsedEntry(n);
    }

    public Object[] getEntries(Object n) {
        CGNode p = this.getProcOf(n);
        return new Object[]{this.getEntryForProcedure(p)};
    }

    @Override
    public Object[] getExitsForProcedure(CGNode node) {
        if (this.noCollapse.contains(node)) {
            ControlFlowGraph<ISSABasicBlock> cfg = this.partialIPFG.getCFG(node);
            return new Object[]{new BasicBlockInContext<ISSABasicBlock>(node, cfg.exit())};
        }
        return new Object[]{this.nodeManager.getCollapsedExit(node)};
    }

    @Override
    public boolean isCall(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        if (object instanceof BasicBlockInContext) {
            return this.partialIPFG.hasCall((BasicBlockInContext)object);
        }
        if (!(object instanceof CollapsedNode)) {
            Assertions._assert(false, object.getClass().toString());
        }
        if (this.nodeManager.isCollapsedEntry(object)) {
            CGNode n = this.nodeManager.getProcOfCollapsedNode(object);
            return this.cg.getSuccNodeCount(n) > 0;
        }
        return false;
    }

    @Override
    public boolean isEntry(Object object) {
        if (object instanceof IBasicBlock) {
            IBasicBlock b = (IBasicBlock)object;
            return b.isEntryBlock();
        }
        return this.nodeManager.isCollapsedEntry(object);
    }

    @Override
    public boolean isExit(Object object) {
        if (object instanceof IBasicBlock) {
            IBasicBlock b = (IBasicBlock)object;
            return b.isExitBlock();
        }
        return this.nodeManager.isCollapsedExit(object);
    }

    @Override
    public Iterator<Object> getCalledNodes(Object n) {
        return new FilterIterator<Object>(this.edgeManager.getSuccNodes(n), this.isEntry);
    }

    @Override
    public Iterator<? extends Object> getReturnSites(Object object) {
        if (object instanceof BasicBlockInContext) {
            return this.partialIPFG.getReturnSites((BasicBlockInContext)object);
        }
        CGNode n = this.nodeManager.getProcOfCollapsedNode(object);
        return new NonNullSingletonIterator<CollapsedNode>(this.nodeManager.getCollapsedExit(n));
    }

    @Override
    public Iterator<? extends Object> getCallSites(Object object) {
        if (object instanceof BasicBlockInContext) {
            return this.partialIPFG.getCallSites((BasicBlockInContext)object);
        }
        CGNode n = this.nodeManager.getProcOfCollapsedNode(object);
        return new NonNullSingletonIterator<CollapsedNode>(this.nodeManager.getCollapsedEntry(n));
    }

    @Override
    public CGNode getProcOf(Object n) throws IllegalArgumentException {
        if (!(n instanceof BasicBlockInContext) && n instanceof IBasicBlock) {
            throw new IllegalArgumentException("(n instanceof com.ibm.wala.cfg.IBasicBlock) and (not ( n instanceof com.ibm.wala.ipa.cfg.BasicBlockInContext ) ): " + n + ", " + n.getClass());
        }
        if (n instanceof BasicBlockInContext) {
            return this.partialIPFG.getCGNode((BasicBlockInContext)n);
        }
        return this.nodeManager.getProcOfCollapsedNode(n);
    }

    @Override
    public Object[] getEntriesForProcedure(CGNode object) {
        Assertions._assert(object != null);
        return new Object[]{this.getEntryForProcedure(object)};
    }

    @Override
    public Object getMainEntry() {
        return this.getEntryForProcedure(this.getMain());
    }

    @Override
    public Object getMainExit() {
        CGNode n = this.getMain();
        if (this.noCollapse.contains(n)) {
            ControlFlowGraph<ISSABasicBlock> cfg = this.partialIPFG.getCFG(n);
            return cfg.exit();
        }
        return this.nodeManager.getCollapsedExit(n);
    }

    @Override
    public boolean isReturn(Object object) {
        if (object instanceof BasicBlockInContext) {
            return this.partialIPFG.isReturn((BasicBlockInContext)object);
        }
        if (this.nodeManager.isCollapsedExit(object)) {
            CGNode node = this.getProcOf(object);
            return this.cg.getSuccNodeCount(node) > 0;
        }
        return false;
    }

    public InterproceduralCFG getUncollapsedGraph() {
        return this.partialIPFG;
    }

    @Override
    public byte classifyEdge(Object src, Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (this.isCall(src)) {
            if (this.isEntry(dest)) {
                return 0;
            }
            return 2;
        }
        if (this.isExit(src)) {
            return 1;
        }
        return 3;
    }

    @Override
    public Iterator<Object> getNormalSuccessors(Object call) {
        return EmptyIterator.instance();
    }

    @Override
    public int getNumberOfBlocks(CGNode procedure) {
        CGNode n = procedure;
        if (this.noCollapse.contains(n)) {
            return this.partialIPFG.getCFG(n).getMaxNumber() + 1;
        }
        return 2;
    }

    @Override
    public int getLocalBlockNumber(Object n) {
        if (n instanceof IBasicBlock) {
            return ((IBasicBlock)n).getNumber();
        }
        return this.isEntry(n) ? 0 : 1;
    }

    @Override
    public Object getLocalBlock(CGNode procedure, int i) {
        CGNode n = procedure;
        if (this.noCollapse.contains(n)) {
            return this.partialIPFG.getCFG(n).getNode(i);
        }
        return i == 0 ? this.nodeManager.getCollapsedEntry(n) : this.nodeManager.getCollapsedExit(n);
    }

    @Override
    public int getNumber(Object N) {
        return this.nodeManager.getNumber(N);
    }

    @Override
    public Object getNode(int number) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getMaxNumber() {
        return this.nodeManager.getMaxNumber();
    }

    @Override
    public Iterator<Object> iterateNodes(IntSet s) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getSuccNodeNumbers(Object node) {
        return this.edgeManager.getSuccNodeNumbers(node);
    }

    @Override
    public IntSet getPredNodeNumbers(Object node) {
        return this.edgeManager.getPredNodeNumbers(node);
    }

    public CallGraph getCallGraph() {
        return this.cg;
    }

    private static final class CollapsedNode {
        final CGNode node;
        final boolean isEntry;
        final int number;

        CollapsedNode(CGNode node, boolean isEntry, int number) {
            this.node = node;
            this.isEntry = isEntry;
            this.number = number;
        }

        public String toString() {
            return this.node + "," + (this.isEntry ? "entry" : "exit");
        }

        public int hashCode() {
            return 8017 * this.node.hashCode() + (this.isEntry ? 1 : 0);
        }

        public boolean equals(Object other) {
            if (other instanceof CollapsedNode) {
                CollapsedNode that = (CollapsedNode)other;
                return this.node.equals(that.node) && this.isEntry == that.isEntry;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdgeManager
    implements NumberedEdgeManager<Object> {
        private final Map<Object, Set<Object>> incomingTransverseEdges = HashMapFactory.make();
        private final Map<Object, Set<Object>> outgoingTransverseEdges = HashMapFactory.make();

        EdgeManager() {
            this.computeTransverseEdges();
        }

        private void computeTransverseEdges() {
            for (BasicBlockInContext bb : PartiallyCollapsedSupergraph.this.partialIPFG) {
                if (!PartiallyCollapsedSupergraph.this.partialIPFG.hasCall(bb)) continue;
                Set<CGNode> targets = PartiallyCollapsedSupergraph.this.partialIPFG.getCallTargets(bb);
                for (CGNode n : targets) {
                    if (PartiallyCollapsedSupergraph.this.noCollapse.contains(n)) continue;
                    CollapsedNode s_n = PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(n);
                    Set<Object> incoming = MapUtil.findOrCreateSet(this.incomingTransverseEdges, s_n);
                    incoming.add(bb);
                    Set<Object> outgoing = MapUtil.findOrCreateSet(this.outgoingTransverseEdges, bb);
                    outgoing.add(s_n);
                    CollapsedNode e_n = PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedExit(n);
                    Iterator<? extends Object> returnSites = PartiallyCollapsedSupergraph.this.getReturnSites(bb);
                    while (returnSites.hasNext()) {
                        Object ret = returnSites.next();
                        Set<Object> in = MapUtil.findOrCreateSet(this.incomingTransverseEdges, ret);
                        in.add(e_n);
                        Set<Object> out = MapUtil.findOrCreateSet(this.outgoingTransverseEdges, e_n);
                        out.add(ret);
                    }
                }
            }
            Iterator it = PartiallyCollapsedSupergraph.this.nodeManager.iterateCollapsedNodes();
            while (it.hasNext()) {
                Object n = it.next();
                if (!PartiallyCollapsedSupergraph.this.nodeManager.isCollapsedEntry(n)) continue;
                CGNode node = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(n);
                Iterator<CGNode> it2 = PartiallyCollapsedSupergraph.this.cg.getSuccNodes(node);
                while (it2.hasNext()) {
                    CGNode outNode = it2.next();
                    if (!PartiallyCollapsedSupergraph.this.noCollapse.contains(outNode)) continue;
                    ControlFlowGraph<ISSABasicBlock> cfg = PartiallyCollapsedSupergraph.this.partialIPFG.getCFG(outNode);
                    BasicBlockInContext<ISSABasicBlock> entry = new BasicBlockInContext<ISSABasicBlock>(outNode, cfg.entry());
                    Set<Object> incoming = MapUtil.findOrCreateSet(this.incomingTransverseEdges, entry);
                    incoming.add(n);
                    Set<Object> outgoing = MapUtil.findOrCreateSet(this.outgoingTransverseEdges, n);
                    outgoing.add(entry);
                    BasicBlockInContext<ISSABasicBlock> exit = new BasicBlockInContext<ISSABasicBlock>(outNode, cfg.exit());
                    CollapsedNode retSite = PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedExit(node);
                    incoming = MapUtil.findOrCreateSet(this.incomingTransverseEdges, retSite);
                    incoming.add(exit);
                    outgoing = MapUtil.findOrCreateSet(this.outgoingTransverseEdges, exit);
                    outgoing.add(retSite);
                }
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Transverse Edges:\n");
            for (Map.Entry<Object, Set<Object>> e : this.incomingTransverseEdges.entrySet()) {
                Object entryNode = e.getKey();
                Set<Object> incoming = e.getValue();
                Iterator<Object> it2 = incoming.iterator();
                while (it2.hasNext()) {
                    result.append(it2.next()).append("->").append(entryNode).append("\n");
                }
            }
            result.append("Partial IPFG:\n");
            result.append(PartiallyCollapsedSupergraph.this.partialIPFG);
            return result.toString();
        }

        @Override
        public Iterator<? extends Object> getPredNodes(Object N) {
            if (N instanceof IBasicBlock) {
                Set<Object> incoming = this.incomingTransverseEdges.get(N);
                if (incoming == null) {
                    return PartiallyCollapsedSupergraph.this.partialIPFG.getPredNodes((BasicBlockInContext)N);
                }
                return new CompoundIterator<Object>(PartiallyCollapsedSupergraph.this.partialIPFG.getPredNodes((BasicBlockInContext)N), incoming.iterator());
            }
            if (PartiallyCollapsedSupergraph.this.isEntry(N)) {
                Set result = HashSetFactory.make(4);
                CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
                Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getPredNodes(n);
                while (it.hasNext()) {
                    CGNode p = it.next();
                    if (PartiallyCollapsedSupergraph.this.noCollapse.contains(p)) continue;
                    result.add(PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(p));
                }
                Set<Object> xverse = this.incomingTransverseEdges.get(N);
                if (xverse != null) {
                    result.addAll(xverse);
                }
                return result.iterator();
            }
            Set result = HashSetFactory.make(4);
            CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
            Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getSuccNodes(n);
            while (it.hasNext()) {
                CGNode s = it.next();
                if (PartiallyCollapsedSupergraph.this.noCollapse.contains(s)) continue;
                result.add(PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedExit(s));
            }
            result.add(PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(n));
            Set<Object> xverse = this.incomingTransverseEdges.get(N);
            if (xverse != null) {
                result.addAll(xverse);
            }
            return result.iterator();
        }

        @Override
        public IntSet getPredNodeNumbers(Object node) {
            if (node instanceof IBasicBlock) {
                Set<Object> incoming = this.incomingTransverseEdges.get(node);
                if (incoming == null) {
                    return PartiallyCollapsedSupergraph.this.partialIPFG.getPredNodeNumbers((BasicBlockInContext)node);
                }
                IntSet pred = PartiallyCollapsedSupergraph.this.partialIPFG.getPredNodeNumbers((BasicBlockInContext)node);
                MutableSparseIntSet result = pred == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make(pred);
                Iterator<Object> it = incoming.iterator();
                while (it.hasNext()) {
                    result.add(PartiallyCollapsedSupergraph.this.getNumber(it.next()));
                }
                return result;
            }
            if (PartiallyCollapsedSupergraph.this.isEntry(node)) {
                MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(node);
                Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getPredNodes(n);
                while (it.hasNext()) {
                    CGNode p = it.next();
                    if (PartiallyCollapsedSupergraph.this.noCollapse.contains(p)) continue;
                    result.add(((PartiallyCollapsedSupergraph)PartiallyCollapsedSupergraph.this).nodeManager.getCollapsedEntry((CGNode)p).number);
                }
                Set<Object> xverse = this.incomingTransverseEdges.get(node);
                if (xverse != null) {
                    Iterator<Object> it2 = xverse.iterator();
                    while (it2.hasNext()) {
                        result.add(PartiallyCollapsedSupergraph.this.getNumber(it2.next()));
                    }
                }
                return result;
            }
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(node);
            Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getSuccNodes(n);
            while (it.hasNext()) {
                CGNode s = it.next();
                if (PartiallyCollapsedSupergraph.this.noCollapse.contains(s)) continue;
                result.add(((PartiallyCollapsedSupergraph)PartiallyCollapsedSupergraph.this).nodeManager.getCollapsedExit((CGNode)s).number);
            }
            result.add(((PartiallyCollapsedSupergraph)PartiallyCollapsedSupergraph.this).nodeManager.getCollapsedEntry((CGNode)n).number);
            Set<Object> xverse = this.incomingTransverseEdges.get(node);
            if (xverse != null) {
                Iterator<Object> it3 = xverse.iterator();
                while (it3.hasNext()) {
                    result.add(PartiallyCollapsedSupergraph.this.getNumber(it3.next()));
                }
            }
            return result;
        }

        @Override
        public int getPredNodeCount(Object N) {
            Collection c = Iterator2Collection.toCollection(this.getPredNodes(N));
            return c.size();
        }

        @Override
        public Iterator<? extends Object> getSuccNodes(Object N) {
            if (N instanceof IBasicBlock) {
                Set<Object> xverse = this.outgoingTransverseEdges.get(N);
                if (xverse == null) {
                    return PartiallyCollapsedSupergraph.this.partialIPFG.getSuccNodes((BasicBlockInContext)N);
                }
                return new CompoundIterator<Object>(PartiallyCollapsedSupergraph.this.partialIPFG.getSuccNodes((BasicBlockInContext)N), xverse.iterator());
            }
            if (PartiallyCollapsedSupergraph.this.isEntry(N)) {
                Set result = HashSetFactory.make(4);
                CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
                Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getSuccNodes(n);
                while (it.hasNext()) {
                    CGNode s = it.next();
                    if (PartiallyCollapsedSupergraph.this.noCollapse.contains(s)) continue;
                    result.add(PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(s));
                }
                result.add(PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedExit(n));
                Set<Object> xverse = this.outgoingTransverseEdges.get(N);
                if (xverse != null) {
                    result.addAll(xverse);
                }
                return result.iterator();
            }
            CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
            CollapsedNode entry = PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(n);
            HashSet result = HashSetFactory.make(4);
            Iterator<? extends Object> it = this.getPredNodes(entry);
            while (it.hasNext()) {
                Object callSite = it.next();
                Iterator<? extends Object> returnSites = PartiallyCollapsedSupergraph.this.getReturnSites(callSite);
                while (returnSites.hasNext()) {
                    result.add(returnSites.next());
                }
            }
            return result.iterator();
        }

        @Override
        public IntSet getSuccNodeNumbers(Object N) {
            if (N instanceof IBasicBlock) {
                Set<Object> xverse = this.outgoingTransverseEdges.get(N);
                if (xverse == null) {
                    return PartiallyCollapsedSupergraph.this.partialIPFG.getSuccNodeNumbers((BasicBlockInContext)N);
                }
                IntSet succ = PartiallyCollapsedSupergraph.this.partialIPFG.getSuccNodeNumbers((BasicBlockInContext)N);
                MutableSparseIntSet result = succ == null ? MutableSparseIntSet.makeEmpty() : MutableSparseIntSet.make(succ);
                Iterator<Object> it = xverse.iterator();
                while (it.hasNext()) {
                    result.add(PartiallyCollapsedSupergraph.this.getNumber(it.next()));
                }
                return result;
            }
            if (PartiallyCollapsedSupergraph.this.isEntry(N)) {
                BimodalMutableIntSet result = new BimodalMutableIntSet();
                CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
                Iterator<CGNode> it = PartiallyCollapsedSupergraph.this.cg.getSuccNodes(n);
                while (it.hasNext()) {
                    CGNode s = it.next();
                    if (PartiallyCollapsedSupergraph.this.noCollapse.contains(s)) continue;
                    result.add(((PartiallyCollapsedSupergraph)PartiallyCollapsedSupergraph.this).nodeManager.getCollapsedEntry((CGNode)s).number);
                }
                result.add(((PartiallyCollapsedSupergraph)PartiallyCollapsedSupergraph.this).nodeManager.getCollapsedExit((CGNode)n).number);
                Set<Object> xverse = this.outgoingTransverseEdges.get(N);
                if (xverse != null) {
                    Iterator<Object> it2 = xverse.iterator();
                    while (it2.hasNext()) {
                        result.add(PartiallyCollapsedSupergraph.this.getNumber(it2.next()));
                    }
                }
                return result;
            }
            CGNode n = PartiallyCollapsedSupergraph.this.nodeManager.getProcOfCollapsedNode(N);
            CollapsedNode entry = PartiallyCollapsedSupergraph.this.nodeManager.getCollapsedEntry(n);
            BimodalMutableIntSet result = new BimodalMutableIntSet();
            Iterator<? extends Object> it = this.getPredNodes(entry);
            while (it.hasNext()) {
                Object callSite = it.next();
                Iterator<? extends Object> returnSites = PartiallyCollapsedSupergraph.this.getReturnSites(callSite);
                while (returnSites.hasNext()) {
                    result.add(PartiallyCollapsedSupergraph.this.getNumber(returnSites.next()));
                }
            }
            return result;
        }

        @Override
        public boolean hasEdge(Object src, Object dst) {
            if (src instanceof IBasicBlock) {
                if (dst instanceof IBasicBlock) {
                    return PartiallyCollapsedSupergraph.this.partialIPFG.hasEdge((BasicBlockInContext)src, (BasicBlockInContext)dst);
                }
                return this.getSuccNodeNumbers(src).contains(PartiallyCollapsedSupergraph.this.getNumber(dst));
            }
            return this.getSuccNodeNumbers(src).contains(PartiallyCollapsedSupergraph.this.getNumber(dst));
        }

        @Override
        public int getSuccNodeCount(Object N) {
            Collection c = Iterator2Collection.toCollection(this.getSuccNodes(N));
            return c.size();
        }

        @Override
        public void addEdge(Object src, Object dst) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeEdge(Object src, Object dst) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeAllIncidentEdges(Object node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(Object node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(Object node) {
            Assertions.UNREACHABLE();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeManager
    implements NumberedNodeManager<Object> {
        private final Map<CGNode, Integer> node2EntryIndex = HashMapFactory.make();
        private final ArrayList<CollapsedNode> collapsedNodes = new ArrayList();

        NodeManager() {
            int firstNumber;
            int nextNumber = firstNumber = PartiallyCollapsedSupergraph.this.partialIPFG.getMaxNumber() + 1;
            for (CGNode n : PartiallyCollapsedSupergraph.this.cg) {
                if (PartiallyCollapsedSupergraph.this.noCollapse.contains(n)) continue;
                this.node2EntryIndex.put(n, new Integer(nextNumber - firstNumber));
                this.collapsedNodes.add(new CollapsedNode(n, true, nextNumber++));
                this.collapsedNodes.add(new CollapsedNode(n, false, nextNumber++));
            }
        }

        public boolean isCollapsedEntry(Object object) {
            CollapsedNode n = (CollapsedNode)object;
            return n.isEntry;
        }

        public boolean isCollapsedExit(Object object) {
            CollapsedNode n = (CollapsedNode)object;
            return !n.isEntry;
        }

        public CGNode getProcOfCollapsedNode(Object object) {
            CollapsedNode n = (CollapsedNode)object;
            return n.node;
        }

        public CollapsedNode getCollapsedEntry(CGNode n) {
            Integer index = this.node2EntryIndex.get(n);
            if (index == null) {
                Assertions.UNREACHABLE("null index for " + n);
            }
            return this.collapsedNodes.get(index);
        }

        public CollapsedNode getCollapsedExit(CGNode n) {
            Integer index = this.node2EntryIndex.get(n);
            return this.collapsedNodes.get(index + 1);
        }

        @Override
        public Iterator<Object> iterator() {
            return new CompoundIterator<Object>(PartiallyCollapsedSupergraph.this.partialIPFG.iterator(), this.collapsedNodes.iterator());
        }

        @Override
        public int getNumberOfNodes() {
            return PartiallyCollapsedSupergraph.this.partialIPFG.getNumberOfNodes() + this.collapsedNodes.size();
        }

        @Override
        public void addNode(Object n) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeNode(Object n) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean containsNode(Object N) {
            if (N instanceof BasicBlockInContext) {
                return PartiallyCollapsedSupergraph.this.partialIPFG.containsNode((BasicBlockInContext)N);
            }
            return this.collapsedNodes.contains(N);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Uncollapsed nodes:\n");
            Iterator it = this.iterateUncollapsedNodes();
            while (it.hasNext()) {
                result.append(it.next()).append("\n");
            }
            result.append("Collapsed nodes:\n");
            it = this.iterateCollapsedNodes();
            while (it.hasNext()) {
                result.append(it.next()).append("\n");
            }
            return result.toString();
        }

        private Iterator iterateCollapsedNodes() {
            return this.collapsedNodes.iterator();
        }

        private Iterator iterateUncollapsedNodes() {
            return PartiallyCollapsedSupergraph.this.partialIPFG.iterator();
        }

        @Override
        public int getNumber(Object N) throws IllegalArgumentException {
            if (!(N instanceof BasicBlockInContext) && !(N instanceof CollapsedNode)) {
                throw new IllegalArgumentException("(not ( N instanceof com.ibm.wala.ipa.cfg.BasicBlockInContext ) ) and (not ( N instanceof com.ibm.wala.dataflow.IFDS.PartiallyCollapsedSupergraph$CollapsedNode ) )");
            }
            if (N instanceof CollapsedNode) {
                return ((CollapsedNode)N).number;
            }
            return PartiallyCollapsedSupergraph.this.partialIPFG.getNumber((BasicBlockInContext)N);
        }

        @Override
        public Object getNode(int number) {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public int getMaxNumber() {
            return PartiallyCollapsedSupergraph.this.partialIPFG.getMaxNumber() + this.collapsedNodes.size();
        }

        @Override
        public Iterator<Object> iterateNodes(IntSet s) {
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

