/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.dataflow.IFDS.CallFlowEdges;
import com.ibm.wala.dataflow.IFDS.IBinaryReturnFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IFlowFunctionMap;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IReversibleFlowFunction;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.LocalPathEdges;
import com.ibm.wala.dataflow.IFDS.LocalSummaryEdges;
import com.ibm.wala.dataflow.IFDS.TabulationCancelException;
import com.ibm.wala.dataflow.IFDS.TabulationProblem;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.eclipse.util.CancelException;
import com.ibm.wala.eclipse.util.MonitorUtil;
import com.ibm.wala.util.ReferenceCleanser;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Heap;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.ToStringComparator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabulationSolver<T, P> {
    protected static final int DEBUG_LEVEL = 0;
    protected static final boolean verbose = "true".equals(System.getProperty("com.ibm.wala.fixedpoint.impl.verbose"));
    static final int VERBOSE_INTERVAL = 100000;
    static final boolean VERBOSE_TRACE_MEMORY = false;
    private static int verboseCounter = 0;
    protected static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 1000000;
    private static int wipeCount = 1000000;
    protected final ISupergraph<T, P> supergraph;
    protected final IFlowFunctionMap<T> flowFunctionMap;
    private final TabulationProblem<T, P> problem;
    private final Map<T, LocalPathEdges> pathEdges = HashMapFactory.make();
    private final Map<T, CallFlowEdges> callFlowEdges = HashMapFactory.make();
    protected final Map<Object, LocalSummaryEdges> summaryEdges = HashMapFactory.make();
    protected final Worklist worklist = new Worklist();
    private final IProgressMonitor progressMonitor;

    protected TabulationSolver(TabulationProblem<T, P> p, IProgressMonitor monitor) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.supergraph = p.getSupergraph();
        this.flowFunctionMap = p.getFunctionMap();
        this.problem = p;
        this.progressMonitor = monitor;
    }

    public static <T, P> TabulationSolver<T, P> make(TabulationProblem<T, P> p) {
        return new TabulationSolver<T, P>(p, null);
    }

    public TabulationResult<T, P> solve() throws CancelException {
        try {
            this.initialize();
            this.forwardTabulateSLRPs();
            Result r = new Result();
            return r;
        }
        catch (CancelException e) {
            Result r = new Result();
            throw new TabulationCancelException(e, r);
        }
    }

    protected void initialize() {
        T mainEntry = this.supergraph.getMainEntry();
        this.propagate(mainEntry, 0, mainEntry, 0);
        IntIterator it = this.problem.getReachableOnEntry().intIterator();
        while (it.hasNext()) {
            int i = it.next();
            this.propagate(mainEntry, 0, mainEntry, i);
        }
    }

    private void forwardTabulateSLRPs() throws CancelException {
        while (this.worklist.size() > 0) {
            MonitorUtil.throwExceptionIfCanceled(this.progressMonitor);
            if (verbose) {
                this.performVerboseAction();
            }
            this.tendToSoftCaches();
            PathEdge edge = this.popFromWorkList();
            int j = this.merge(edge.s_p, edge.d1, edge.n, edge.d2);
            if (j == -1) continue;
            if (j != edge.d2) {
                this.propagate(edge.s_p, edge.d1, edge.n, j);
                continue;
            }
            if (this.supergraph.isCall(edge.n)) {
                this.processCall(edge);
                continue;
            }
            if (this.supergraph.isExit(edge.n)) {
                this.processExit(edge);
                continue;
            }
            this.processNormal(edge);
        }
    }

    protected void tendToSoftCaches() {
        if (++wipeCount > 1000000) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
    }

    protected final void performVerboseAction() {
        if (++verboseCounter % 100000 == 0) {
            System.err.println("Tabulation Solver " + verboseCounter);
            System.err.println("  " + this.peekFromWorkList());
        }
    }

    private void processNormal(final PathEdge edge) {
        Iterator it = this.supergraph.getSuccNodes(edge.n);
        while (it.hasNext()) {
            final Object m = it.next();
            IUnaryFlowFunction f = this.flowFunctionMap.getNormalFlowFunction(edge.n, m);
            IntSet D3 = this.computeFlow(edge.d2, f);
            if (D3 == null) continue;
            D3.foreach(new IntSetAction(){

                public void act(int d3) {
                    TabulationSolver.this.propagate(edge.s_p, edge.d1, m, d3);
                }
            });
        }
    }

    protected void processExit(PathEdge edge) {
        int x;
        int s_p_n;
        IntSet succ = this.supergraph.getSuccNodeNumbers(edge.n);
        if (succ == null) {
            return;
        }
        LocalSummaryEdges summaries = this.findOrCreateLocalSummaryEdges(this.supergraph.getProcOf(edge.n));
        if (!summaries.contains(s_p_n = this.supergraph.getLocalBlockNumber(edge.s_p), x = this.supergraph.getLocalBlockNumber(edge.n), edge.d1, edge.d2)) {
            summaries.insertSummaryEdge(s_p_n, x, edge.d1, edge.d2);
        }
        CallFlowEdges callFlow = this.findOrCreateCallFlowEdges(edge.s_p);
        Iterator it = this.supergraph.getPredNodes(edge.s_p);
        while (it.hasNext()) {
            Object c = it.next();
            int cNum = this.supergraph.getLocalBlockNumber(c);
            int globalC = this.supergraph.getNumber(c);
            IntSet D4 = callFlow.getCallFlowSources(globalC, edge.d1);
            if (D4 == null) continue;
            this.propagateToReturnSites(edge, succ, c, D4);
        }
    }

    private void propagateToReturnSites(PathEdge edge, IntSet succ, final T c, IntSet D4) {
        P proc = this.supergraph.getProcOf(c);
        final Object[] entries = this.supergraph.getEntriesForProcedure(proc);
        Iterator<T> retSites = this.supergraph.getReturnSites(c);
        while (retSites.hasNext()) {
            final T retSite = retSites.next();
            if (!succ.contains(this.supergraph.getNumber(retSite))) continue;
            IFlowFunction retf = this.flowFunctionMap.getReturnFlowFunction(c, edge.n, retSite);
            if (retf instanceof IBinaryReturnFlowFunction) {
                this.propagateToReturnSiteWithBinaryFlowFunction(edge, c, D4, entries, retSite, retf);
                continue;
            }
            final IntSet D5 = this.computeFlow(edge.d2, (IUnaryFlowFunction)retf);
            IntSetAction action = new IntSetAction(){

                public void act(final int d4) {
                    if (D5 != null) {
                        D5.foreach(new IntSetAction(){

                            public void act(final int d5) {
                                int i = 0;
                                while (i < entries.length) {
                                    final Object s_p = entries[i];
                                    IntSet D3 = TabulationSolver.this.getInversePathEdges(s_p, c, d4);
                                    if (D3 != null) {
                                        D3.foreach(new IntSetAction(){

                                            public void act(int d3) {
                                                TabulationSolver.this.propagate(s_p, d3, retSite, d5);
                                            }
                                        });
                                    }
                                    ++i;
                                }
                            }
                        });
                    }
                }
            };
            D4.foreach(action);
        }
    }

    private void propagateToReturnSiteWithBinaryFlowFunction(final PathEdge edge, final T c, IntSet D4, final T[] entries, final T retSite, final IFlowFunction retf) {
        D4.foreach(new IntSetAction(){

            public void act(final int d4) {
                IntSet D5 = TabulationSolver.this.computeBinaryFlow(d4, edge.d2, (IBinaryReturnFlowFunction)retf);
                if (D5 != null) {
                    D5.foreach(new IntSetAction(){

                        public void act(final int d5) {
                            int i = 0;
                            while (i < entries.length) {
                                final Object s_p = entries[i];
                                IntSet D3 = TabulationSolver.this.getInversePathEdges(s_p, c, d4);
                                if (D3 != null) {
                                    D3.foreach(new IntSetAction(){

                                        public void act(int d3) {
                                            TabulationSolver.this.propagate(s_p, d3, retSite, d5);
                                        }
                                    });
                                }
                                ++i;
                            }
                        }
                    });
                }
            }
        });
    }

    protected IntSet getInversePathEdges(T s_p, T n, int d2) {
        int number = this.supergraph.getLocalBlockNumber(n);
        LocalPathEdges lp = this.pathEdges.get(s_p);
        if (lp == null) {
            return null;
        }
        return lp.getInverse(number, d2);
    }

    protected void processCall(final PathEdge edge) {
        IntSet reached;
        IUnaryFlowFunction f;
        final int c = this.supergraph.getNumber(edge.n);
        final Collection returnSites = Iterator2Collection.toCollection(this.supergraph.getReturnSites(edge.n));
        Iterator<T> it = this.supergraph.getCalledNodes(edge.n);
        while (it.hasNext()) {
            final T callee = it.next();
            f = this.flowFunctionMap.getCallFlowFunction(edge.n, callee);
            reached = this.computeFlow(edge.d2, f);
            if (reached == null) continue;
            final LocalSummaryEdges summaries = this.summaryEdges.get(this.supergraph.getProcOf(callee));
            final CallFlowEdges callFlow = this.findOrCreateCallFlowEdges(callee);
            final int s_p_num = this.supergraph.getLocalBlockNumber(callee);
            reached.foreach(new IntSetAction(){

                public void act(int d1) {
                    TabulationSolver.this.propagate(callee, d1, callee, d1);
                    callFlow.addCallEdge(c, edge.d2, d1);
                    if (summaries != null) {
                        Object p = TabulationSolver.this.supergraph.getProcOf(callee);
                        T[] exits = TabulationSolver.this.supergraph.getExitsForProcedure(p);
                        int e = 0;
                        while (e < exits.length) {
                            Object exit = exits[e];
                            Iterator succ = TabulationSolver.this.supergraph.getSuccNodes(exit);
                            while (succ.hasNext()) {
                                int x_num;
                                IntSet reachedBySummary;
                                final Object returnSite = succ.next();
                                if (!returnSites.contains(returnSite) || (reachedBySummary = summaries.getSummaryEdges(s_p_num, x_num = TabulationSolver.this.supergraph.getLocalBlockNumber(exit), d1)) == null) continue;
                                final IFlowFunction retf = TabulationSolver.this.flowFunctionMap.getReturnFlowFunction(edge.n, exit, returnSite);
                                reachedBySummary.foreach(new IntSetAction(){

                                    public void act(int d2) {
                                        if (retf instanceof IBinaryReturnFlowFunction) {
                                            IntSet D5 = TabulationSolver.this.computeBinaryFlow(edge.d2, d2, (IBinaryReturnFlowFunction)retf);
                                            if (D5 != null) {
                                                D5.foreach(new IntSetAction(){

                                                    public void act(int d5) {
                                                        TabulationSolver.this.propagate(edge.s_p, edge.d1, returnSite, d5);
                                                    }
                                                });
                                            }
                                        } else {
                                            IntSet D5 = TabulationSolver.this.computeFlow(d2, (IUnaryFlowFunction)retf);
                                            if (D5 != null) {
                                                D5.foreach(new IntSetAction(){

                                                    public void act(int d5) {
                                                        TabulationSolver.this.propagate(edge.s_p, edge.d1, returnSite, d5);
                                                    }
                                                });
                                            }
                                        }
                                    }
                                });
                            }
                            ++e;
                        }
                    }
                }
            });
        }
        it = this.supergraph.getNormalSuccessors(edge.n);
        while (it.hasNext()) {
            final T m = it.next();
            f = this.flowFunctionMap.getNormalFlowFunction(edge.n, m);
            IntSet D3 = this.computeFlow(edge.d2, f);
            if (D3 == null) continue;
            D3.foreach(new IntSetAction(){

                public void act(int d3) {
                    TabulationSolver.this.propagate(edge.s_p, edge.d1, m, d3);
                }
            });
        }
        for (final Object returnSite : returnSites) {
            f = null;
            f = this.hasCallee(returnSite) ? this.flowFunctionMap.getCallToReturnFlowFunction(edge.n, returnSite) : this.flowFunctionMap.getCallNoneToReturnFlowFunction(edge.n, returnSite);
            reached = this.computeFlow(edge.d2, f);
            if (reached == null) continue;
            reached.foreach(new IntSetAction(){

                public void act(int x) {
                    Assertions._assert(x >= 0);
                    Assertions._assert(edge.d1 >= 0);
                    TabulationSolver.this.propagate(edge.s_p, edge.d1, returnSite, x);
                }
            });
        }
    }

    private boolean hasCallee(T returnSite) {
        Iterator<T> it = this.supergraph.getPredNodes(returnSite);
        while (it.hasNext()) {
            T pred = it.next();
            if (this.supergraph.getProcOf(pred).equals(this.supergraph.getProcOf(returnSite))) continue;
            return true;
        }
        return false;
    }

    protected IntSet computeBinaryFlow(int call_d, int exit_d, IBinaryReturnFlowFunction f) {
        SparseIntSet result = f.getTargets(call_d, exit_d);
        return result;
    }

    protected IntSet computeFlow(int d1, IUnaryFlowFunction f) {
        IntSet result = f.getTargets(d1);
        if (result == null) {
            return null;
        }
        return result;
    }

    protected IntSet computeInverseFlow(int d2, IReversibleFlowFunction f) {
        return f.getSources(d2);
    }

    protected PathEdge popFromWorkList() {
        return (PathEdge)this.worklist.take();
    }

    private PathEdge peekFromWorkList() {
        PathEdge result = (PathEdge)this.worklist.take();
        this.worklist.insert(result);
        return result;
    }

    protected void propagate(T s_p, int i, T n, int j) {
        int number = this.supergraph.getLocalBlockNumber(n);
        if (number < 0) {
            System.err.println("BOOM " + n);
            this.supergraph.getLocalBlockNumber(n);
        }
        Assertions._assert(number >= 0);
        LocalPathEdges pLocal = this.findOrCreateLocalPathEdges(s_p);
        Assertions._assert(j >= 0);
        if (!pLocal.contains(i, number, j)) {
            pLocal.addPathEdge(i, number, j);
            this.addToWorkList(s_p, i, n, j);
        }
    }

    private int merge(T s_p, int i, T n, int j) {
        Assertions._assert(j >= 0);
        IMergeFunction alpha = this.problem.getMergeFunction();
        if (alpha != null) {
            LocalPathEdges lp = this.pathEdges.get(s_p);
            IntSet preExistFacts = lp.getReachable(this.supergraph.getLocalBlockNumber(n), i);
            if (preExistFacts == null) {
                return j;
            }
            int size = preExistFacts.size();
            if (size == 0 || size == 1 && preExistFacts.contains(j)) {
                return j;
            }
            int result = alpha.merge(preExistFacts, j);
            return result;
        }
        return j;
    }

    protected void addToWorkList(T s_p, int i, T n, int j) {
        this.worklist.insert(new PathEdge(s_p, i, n, j));
    }

    private LocalPathEdges findOrCreateLocalPathEdges(T s_p) {
        LocalPathEdges result = this.pathEdges.get(s_p);
        if (result == null) {
            result = this.makeLocalPathEdges();
            this.pathEdges.put(s_p, result);
        }
        return result;
    }

    private LocalPathEdges makeLocalPathEdges() {
        return this.problem.getMergeFunction() == null ? new LocalPathEdges(false) : new LocalPathEdges(true);
    }

    protected LocalSummaryEdges findOrCreateLocalSummaryEdges(Object proc) {
        LocalSummaryEdges result = this.summaryEdges.get(proc);
        if (result == null) {
            result = new LocalSummaryEdges();
            this.summaryEdges.put(proc, result);
        }
        return result;
    }

    private CallFlowEdges findOrCreateCallFlowEdges(T s_p) {
        CallFlowEdges result = this.callFlowEdges.get(s_p);
        if (result == null) {
            result = new CallFlowEdges();
            this.callFlowEdges.put(s_p, result);
        }
        return result;
    }

    public ISupergraph<T, P> getSupergraph() {
        return this.supergraph;
    }

    public IntSet getSummarySources(T n2, int d2, T n1) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not currently supported.  be careful");
    }

    public TabulationProblem<T, P> getProblem() {
        return this.problem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PathEdge {
        final T s_p;
        final int d1;
        final T n;
        final int d2;

        PathEdge(T s_p, int d1, T n, int d2) {
            this.s_p = s_p;
            this.d1 = d1;
            this.n = n;
            this.d2 = d2;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("<");
            result.append(this.s_p.toString());
            result.append(",");
            result.append(this.d1);
            result.append("> -> <");
            result.append(this.n.toString());
            result.append(",");
            result.append(this.d2);
            result.append(">");
            return result.toString();
        }

        public int hashCode() {
            return this.s_p.hashCode() + this.d1 * 401 + this.n.hashCode() * 409 + this.d2 * 419;
        }

        public boolean equals(Object arg0) {
            if (this.getClass().equals(arg0.getClass())) {
                PathEdge that = (PathEdge)arg0;
                return this.d1 == that.d1 && this.d2 == that.d2 && this.s_p.equals(that.s_p) && this.n.equals(that.n);
            }
            return false;
        }

        public int getD1() {
            return this.d1;
        }

        public int getD2() {
            return this.d2;
        }

        public Object getSp() {
            return this.s_p;
        }

        public Object getN() {
            return this.n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result
    implements TabulationResult<T, P> {
        @Override
        public IntSet getResult(T node) {
            Assertions._assert(node != null);
            Object proc = TabulationSolver.this.supergraph.getProcOf(node);
            if (proc == null) {
                Assertions.UNREACHABLE("no proc for node " + node);
            }
            int n = TabulationSolver.this.supergraph.getLocalBlockNumber(node);
            T[] entries = TabulationSolver.this.supergraph.getEntriesForProcedure(proc);
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            int i = 0;
            while (i < entries.length) {
                Object s_p = entries[i];
                LocalPathEdges lp = (LocalPathEdges)TabulationSolver.this.pathEdges.get(s_p);
                if (lp != null) {
                    result.addAll(lp.getReachable(n));
                }
                ++i;
            }
            return result;
        }

        public String toString() {
            Collection reachableNodes = DFS.getReachableNodes(TabulationSolver.this.supergraph, Collections.singleton(TabulationSolver.this.supergraph.getMainEntry()));
            StringBuffer result = new StringBuffer();
            TreeMap map = new TreeMap(ToStringComparator.instance());
            Comparator<Object> c = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (!(o1 instanceof IBasicBlock)) {
                        return -1;
                    }
                    IBasicBlock bb1 = (IBasicBlock)o1;
                    IBasicBlock bb2 = (IBasicBlock)o2;
                    return bb1.getNumber() - bb2.getNumber();
                }
            };
            for (Object t : TabulationSolver.this.supergraph) {
                if (!reachableNodes.contains(t)) continue;
                Object proc = TabulationSolver.this.supergraph.getProcOf(t);
                TreeSet<Object> s = (TreeSet<Object>)map.get(proc);
                if (s == null) {
                    s = new TreeSet<Object>(c);
                    map.put(proc, s);
                }
                s.add(t);
            }
            for (Map.Entry entry : map.entrySet()) {
                Set s = (Set)entry.getValue();
                for (Object o : s) {
                    result.append(o + " : " + this.getResult(o) + "\n");
                }
            }
            return result.toString();
        }

        @Override
        public TabulationProblem<T, P> getProblem() {
            return TabulationSolver.this.problem;
        }

        @Override
        public Collection<T> getSupergraphNodesReached() {
            Collection result = HashSetFactory.make();
            for (Map.Entry e : TabulationSolver.this.pathEdges.entrySet()) {
                Object key = e.getKey();
                Object proc = TabulationSolver.this.supergraph.getProcOf(key);
                IntSet reached = ((LocalPathEdges)e.getValue()).getReachedNodeNumbers();
                IntIterator ii = reached.intIterator();
                while (ii.hasNext()) {
                    result.add(TabulationSolver.this.supergraph.getLocalBlock(proc, ii.next()));
                }
            }
            return result;
        }

        @Override
        public IntSet getSummaryTargets(T n1, int d1, T n2) {
            LocalSummaryEdges summaries = TabulationSolver.this.summaryEdges.get(TabulationSolver.this.supergraph.getProcOf(n1));
            if (summaries == null) {
                return null;
            }
            int num1 = TabulationSolver.this.supergraph.getLocalBlockNumber(n1);
            int num2 = TabulationSolver.this.supergraph.getLocalBlockNumber(n2);
            return summaries.getSummaryEdges(num1, num2, d1);
        }
    }

    protected class Worklist
    extends Heap {
        Worklist() {
            super(100);
        }

        protected boolean compareElements(Object elt1, Object elt2) {
            PathEdge p1 = (PathEdge)elt1;
            PathEdge p2 = (PathEdge)elt2;
            return p1.d2 != p2.d2 && TabulationSolver.this.problem.getDomain().isWeakerThan(p1.d2, p2.d2);
        }
    }
}

