/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.ssa;

import com.ibm.wala.fixedpoint.impl.AbstractOperator;
import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSAInference<T extends IVariable>
extends DefaultFixedPointSolver<T> {
    static final boolean DEBUG = false;
    private IR ir;
    private SymbolTable symbolTable;
    private IVariable[] vars;

    protected void init(IR ir, VariableFactory varFactory, OperatorFactory<T> opFactory) {
        this.ir = ir;
        this.symbolTable = ir.getSymbolTable();
        this.createVariables(varFactory);
        this.createEquations(opFactory);
    }

    private void createEquations(OperatorFactory<T> opFactory) {
        SSAInstruction s;
        SSAInstruction[] instructions = this.ir.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            s = instructions[i];
            this.makeEquationForInstruction(opFactory, s);
            ++i;
        }
        Iterator<? extends SSAInstruction> it = this.ir.iteratePhis();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
        it = this.ir.iteratePis();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
        it = this.ir.iterateCatchInstructions();
        while (it.hasNext()) {
            s = it.next();
            this.makeEquationForInstruction(opFactory, s);
        }
    }

    private void makeEquationForInstruction(OperatorFactory<T> opFactory, SSAInstruction s) {
        AbstractOperator<T> op;
        if (s != null && s.hasDef() && (op = opFactory.get(s)) != null) {
            T def = this.getVariable(s.getDef());
            if (op instanceof NullaryOperator) {
                this.newStatement(def, (NullaryOperator)op, false, false);
            } else {
                int n = s.getNumberOfUses();
                IVariable[] uses = new IVariable[n];
                int j = 0;
                while (j < n) {
                    if (s.getUse(j) > -1) {
                        uses[j] = this.getVariable(s.getUse(j));
                        Assertions._assert(uses[j] != null);
                    }
                    ++j;
                }
                this.newStatement(def, op, uses, false, false);
            }
        }
    }

    private void createVariables(VariableFactory factory) {
        this.vars = new IVariable[this.symbolTable.getMaxValueNumber() + 1];
        int i = 1;
        while (i < this.vars.length) {
            this.vars[i] = factory.makeVariable(i);
            ++i;
        }
    }

    protected T getVariable(int valueNumber) {
        if (valueNumber < 0) {
            throw new IllegalArgumentException("Illegal valueNumber " + valueNumber);
        }
        if (this.vars == null) {
            Assertions._assert(this.vars != null, "null vars array");
        }
        return (T)this.vars[valueNumber];
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("Type inference : \n");
        int i = 0;
        while (i < this.vars.length) {
            result.append("v").append(i).append("  ").append(this.vars[i]).append("\n");
            ++i;
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OperatorFactory<T extends IVariable> {
        public AbstractOperator<T> get(SSAInstruction var1);
    }

    public static interface VariableFactory {
        public IVariable makeVariable(int var1);
    }
}

