/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.CallStack;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldBarLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewBarLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldBarLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.demandpa.util.CallSiteAndCGNode;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSensitiveStateMachine
implements StateMachine<IFlowLabel> {
    private static final boolean DEBUG = false;
    private final CallStack emptyStack = CallStack.emptyCallStack();
    private final HashSet<CallSiteAndCGNode> recursiveCallSites = HashSetFactory.make();

    @Override
    public CallStack getStartState() {
        return this.emptyStack;
    }

    @Override
    public StateMachine.State transition(StateMachine.State prevState, IFlowLabel label) throws IllegalArgumentException, IllegalArgumentException {
        if (prevState == null) {
            throw new IllegalArgumentException("prevState == null");
        }
        if (!(prevState instanceof CallStack)) {
            throw new IllegalArgumentException("not ( prevState instanceof com.ibm.wala.demandpa.alg.CallStack ) ");
        }
        CallStack prevStack = (CallStack)prevState;
        if (!prevStack.isEmpty() && this.recursiveCallSites.contains(prevStack.peek())) {
            return this.transition((StateMachine.State)prevStack.pop(), label);
        }
        CSLabelVisitor v = new CSLabelVisitor(prevStack);
        label.visit(v, null);
        return v.nextState;
    }

    private ContextSensitiveStateMachine() {
    }

    /* synthetic */ ContextSensitiveStateMachine(ContextSensitiveStateMachine contextSensitiveStateMachine) {
        this();
    }

    private class CSLabelVisitor
    implements IFlowLabel.IFlowLabelVisitor {
        final CallStack prevStack;
        StateMachine.State nextState = null;

        CSLabelVisitor(CallStack prevStack) {
            this.prevStack = prevStack;
        }

        public void visitAssign(AssignLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitAssignBar(AssignBarLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitAssignGlobalBar(AssignGlobalBarLabel label, Object dst) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitGetField(GetFieldLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitGetFieldBar(GetFieldBarLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitMatch(MatchLabel label, Object dst) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitMatchBar(MatchBarLabel label, Object dst) {
            this.nextState = ContextSensitiveStateMachine.this.emptyStack;
        }

        public void visitNew(NewLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitNewBar(NewBarLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitParam(ParamLabel label, Object dst) {
            this.handleMethodExit(label.getCallSite());
        }

        private void handleMethodExit(CallSiteAndCGNode callSite) {
            this.nextState = ContextSensitiveStateMachine.this.recursiveCallSites.contains(callSite) ? this.prevStack : (this.prevStack.isEmpty() ? this.prevStack : (((CallSiteAndCGNode)this.prevStack.peek()).equals(callSite) ? this.prevStack.pop() : ERROR));
        }

        public void visitParamBar(ParamBarLabel label, Object dst) {
            this.handleMethodEntry(label.getCallSite());
        }

        private void handleMethodEntry(CallSiteAndCGNode callSite) {
            if (ContextSensitiveStateMachine.this.recursiveCallSites.contains(callSite)) {
                this.nextState = this.prevStack;
            } else {
                if (this.prevStack.contains(callSite)) {
                    CallSiteAndCGNode topCallSite = null;
                    CallStack tmpStack = this.prevStack;
                    do {
                        topCallSite = (CallSiteAndCGNode)tmpStack.peek();
                        ContextSensitiveStateMachine.this.recursiveCallSites.add(topCallSite);
                        tmpStack = tmpStack.pop();
                    } while (!topCallSite.equals(callSite) && !tmpStack.isEmpty());
                    throw new StatesMergedException();
                }
                this.nextState = this.prevStack.push(callSite);
            }
        }

        public void visitPutField(PutFieldLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitPutFieldBar(PutFieldBarLabel label, Object dst) {
            this.nextState = this.prevStack;
        }

        public void visitReturn(ReturnLabel label, Object dst) {
            this.handleMethodEntry(label.getCallSite());
        }

        public void visitReturnBar(ReturnBarLabel label, Object dst) {
            this.handleMethodExit(label.getCallSite());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements StateMachineFactory<IFlowLabel> {
        @Override
        public StateMachine<IFlowLabel> make() {
            return new ContextSensitiveStateMachine(null);
        }
    }
}

