/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.alg.AbstractDemandPointsTo;
import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.InstanceFieldKeyAndState;
import com.ibm.wala.demandpa.alg.InstanceKeyAndState;
import com.ibm.wala.demandpa.alg.PointerKeyAndState;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.NeverRefineFieldsPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.demandpa.alg.refinepolicy.SinglePassRefinementPolicy;
import com.ibm.wala.demandpa.alg.statemachine.StateMachine;
import com.ibm.wala.demandpa.alg.statemachine.StateMachineFactory;
import com.ibm.wala.demandpa.alg.statemachine.StatesMergedException;
import com.ibm.wala.demandpa.flowgraph.AbstractFlowLabelVisitor;
import com.ibm.wala.demandpa.flowgraph.AssignBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalBarLabel;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandPointerFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.IFlowLabel;
import com.ibm.wala.demandpa.flowgraph.MatchBarLabel;
import com.ibm.wala.demandpa.flowgraph.MatchLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.ParamBarLabel;
import com.ibm.wala.demandpa.flowgraph.ParamLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnBarLabel;
import com.ibm.wala.demandpa.flowgraph.ReturnLabel;
import com.ibm.wala.demandpa.genericutil.ArraySet;
import com.ibm.wala.demandpa.genericutil.ArraySetMultiMap;
import com.ibm.wala.demandpa.genericutil.HashSetMultiMap;
import com.ibm.wala.demandpa.genericutil.MultiMap;
import com.ibm.wala.demandpa.genericutil.Predicate;
import com.ibm.wala.demandpa.util.CallSiteAndCGNode;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Function;
import com.ibm.wala.util.MapIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemandRefinementPointsTo
extends AbstractDemandPointsTo {
    private static final boolean DEBUG = false;
    private final DemandPointerFlowGraph g;
    private StateMachineFactory<IFlowLabel> stateMachineFactory;
    private StateMachine<IFlowLabel> stateMachine;
    private RefinementPolicy refinementPolicy;
    private RefinementPolicyFactory refinementPolicyFactory;

    public RefinementPolicy getRefinementPolicy() {
        return this.refinementPolicy;
    }

    public DemandRefinementPointsTo(CallGraph cg, HeapModel model, MemoryAccessMap fam, ClassHierarchy cha, AnalysisOptions options, StateMachineFactory<IFlowLabel> stateMachineFactory) {
        super(cg, new FilteringHeapModel(model, cha), fam, cha, options);
        this.stateMachineFactory = stateMachineFactory;
        this.g = new DemandPointerFlowGraph(cg, this.heapModel, fam, cha);
        this.refinementPolicyFactory = new SinglePassRefinementPolicy.Factory(new NeverRefineFieldsPolicy(), new NeverRefineCGPolicy());
    }

    private void startNewQuery() {
        this.refinementPolicy = this.refinementPolicyFactory.make();
        this.stateMachine = this.stateMachineFactory.make();
    }

    public Pair<PointsToResult, Collection<InstanceKey>> getPointsTo(PointerKey pk, Predicate<Collection<InstanceKey>> p2setPred) throws IllegalArgumentException {
        if (!(pk instanceof LocalPointerKey)) {
            throw new IllegalArgumentException("only locals for now");
        }
        LocalPointerKey queriedPk = (LocalPointerKey)pk;
        Collection<InstanceKey> lastP2Set = null;
        boolean succeeded = false;
        this.startNewQuery();
        int numPasses = this.refinementPolicy.getNumPasses();
        int passNum = 0;
        while (passNum < numPasses) {
            this.setNumNodesTraversed(0);
            this.setTraversalBudget(this.refinementPolicy.getBudgetForPass(passNum));
            Collection<InstanceKey> curP2Set = null;
            try {
                while (true) {
                    try {
                        PointsToComputer computer = new PointsToComputer(queriedPk);
                        computer.compute();
                        curP2Set = computer.getP2Set(queriedPk);
                    }
                    catch (StatesMergedException statesMergedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (BudgetExceededException budgetExceededException) {
                // empty catch block
            }
            if (curP2Set != null) {
                lastP2Set = curP2Set;
                if (p2setPred.test(curP2Set)) {
                    succeeded = true;
                    break;
                }
            }
            if (!this.refinementPolicy.nextPass()) break;
            ++passNum;
        }
        PointsToResult result = null;
        result = succeeded ? PointsToResult.SUCCESS : (passNum == numPasses ? PointsToResult.BUDGETEXCEEDED : PointsToResult.NOMOREREFINE);
        return Pair.make(result, lastP2Set);
    }

    @Override
    public Collection<InstanceKey> getPointsTo(PointerKey pk) {
        return (Collection)this.getPointsTo((PointerKey)pk, Predicate.<Collection<InstanceKey>>falsePred()).snd;
    }

    private IR getIR(CGNode node) {
        return node.getIR();
    }

    private Object doTransition(StateMachine.State curState, IFlowLabel label, Function<StateMachine.State, Object> func) {
        StateMachine.State nextState = this.stateMachine.transition(curState, label);
        Object ret = null;
        if (nextState != StateMachine.ERROR) {
            ret = func.apply(nextState);
        }
        return ret;
    }

    public StateMachineFactory<IFlowLabel> getStateMachineFactory() {
        return this.stateMachineFactory;
    }

    public void setStateMachineFactory(StateMachineFactory<IFlowLabel> stateMachineFactory) {
        this.stateMachineFactory = stateMachineFactory;
    }

    public RefinementPolicyFactory getRefinementPolicyFactory() {
        return this.refinementPolicyFactory;
    }

    public void setRefinementPolicyFactory(RefinementPolicyFactory refinementPolicyFactory) {
        this.refinementPolicyFactory = refinementPolicyFactory;
    }

    private static abstract class CopyHandler {
        private CopyHandler() {
        }

        abstract void handle(PointerKeyAndState var1, PointerKey var2, IFlowLabel var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringHeapModel
    implements HeapModel {
        private final HeapModel delegate;
        private final ClassHierarchy cha;

        @Override
        public IClassHierarchy getClassHierarchy() {
            return this.delegate.getClassHierarchy();
        }

        @Override
        public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
            return this.delegate.getFilteredPointerKeyForLocal(node, valueNumber, filter);
        }

        @Override
        public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
            return this.delegate.getInstanceKeyForAllocation(node, allocation);
        }

        @Override
        public InstanceKey getInstanceKeyForClassObject(TypeReference type) {
            return this.delegate.getInstanceKeyForClassObject(type);
        }

        public InstanceKey getInstanceKeyForConstant(TypeReference type, Object S) {
            return this.delegate.getInstanceKeyForConstant(type, S);
        }

        @Override
        public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
            return this.delegate.getInstanceKeyForMultiNewArray(node, allocation, dim);
        }

        @Override
        public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
            return this.delegate.getInstanceKeyForPEI(node, instr, type);
        }

        @Override
        public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
            return this.delegate.getPointerKeyForArrayContents(I);
        }

        @Override
        public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
            return this.delegate.getPointerKeyForExceptionalReturnValue(node);
        }

        @Override
        public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField field) {
            return this.delegate.getPointerKeyForInstanceField(I, field);
        }

        @Override
        public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
            if (!node.getMethod().isStatic() && valueNumber == 1) {
                return this.delegate.getFilteredPointerKeyForLocal(node, valueNumber, this.getFilter(node));
            }
            return this.delegate.getPointerKeyForLocal(node, valueNumber);
        }

        private FilteredPointerKey.TypeFilter getFilter(CGNode target) {
            FilteredPointerKey.TypeFilter filter = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.FILTER);
            if (filter != null) {
                return filter;
            }
            IClass C = this.getReceiverClass(target.getMethod());
            return new FilteredPointerKey.SingleClassFilter(C);
        }

        private IClass getReceiverClass(IMethod method) {
            TypeReference formalType = method.getParameterType(0);
            IClass C = this.cha.lookupClass(formalType);
            if (method.isStatic()) {
                Assertions.UNREACHABLE("asked for receiver of static method " + method);
            }
            if (C == null) {
                Assertions.UNREACHABLE("no class found for " + formalType + " recv of " + method);
            }
            return C;
        }

        @Override
        public PointerKey getPointerKeyForReturnValue(CGNode node) {
            return this.delegate.getPointerKeyForReturnValue(node);
        }

        @Override
        public PointerKey getPointerKeyForStaticField(IField f) {
            return this.delegate.getPointerKeyForStaticField(f);
        }

        @Override
        public Iterator<PointerKey> iteratePointerKeys() {
            return this.delegate.iteratePointerKeys();
        }

        public FilteringHeapModel(HeapModel delegate, ClassHierarchy cha) {
            this.delegate = delegate;
            this.cha = cha;
        }
    }

    private static final class LoadEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public String toString() {
            return this.val + " := " + this.base + ", field " + this.field;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoadEdge other = (LoadEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public LoadEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PointsToComputer {
        private final PointerKeyAndState queriedPkAndState;
        private final MultiMap<PointerKey, StateMachine.State> pointsToQueried = HashSetMultiMap.make();
        private final Collection<PointerKeyAndState> initWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> pointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final Collection<PointerKeyAndState> trackedPointsToWorklist = new LinkedHashSet<PointerKeyAndState>();
        private final MultiMap<PointerKeyAndState, CallSiteAndCGNode> pkToOTFCalls = HashSetMultiMap.make();
        private final MultiMap<CallSiteAndCGNode, IMethod> callToOTFTargets = ArraySetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> forwInstKeyToFields = HashSetMultiMap.make();
        private final MultiMap<InstanceKeyAndState, IField> backInstKeyToFields = HashSetMultiMap.make();
        private final Map<PointerKeyAndState, MutableIntSet> pkToP2Set = HashMapFactory.make();
        private final Map<PointerKeyAndState, MutableIntSet> pkToTrackedSet = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToP2Set = HashMapFactory.make();
        private final Map<InstanceFieldKeyAndState, MutableIntSet> instFieldKeyToTrackedSet = HashMapFactory.make();
        private final OrdinalSetMapping<InstanceKeyAndState> ikAndStates = MutableMapping.make();
        private final MutableIntSetFactory intSetFactory = new MutableSparseIntSetFactory();
        private final HashSet<StoreEdge> encounteredStores = HashSetFactory.make();
        private final HashSet<LoadEdge> encounteredLoads = HashSetFactory.make();
        private final MutableIntSet emptySet = this.intSetFactory.make();

        PointsToComputer(LocalPointerKey pk) {
            this.queriedPkAndState = new PointerKeyAndState(pk, DemandRefinementPointsTo.this.stateMachine.getStartState());
        }

        private OrdinalSet<InstanceKeyAndState> makeOrdinalSet(IntSet intSet) {
            return new OrdinalSet<InstanceKeyAndState>(this.intSetFactory.makeCopy(intSet), this.ikAndStates);
        }

        public Collection<InstanceKey> getP2Set(LocalPointerKey queriedPk) {
            return Iterator2Collection.toCollection(new MapIterator<InstanceKeyAndState, InstanceKey>(this.makeOrdinalSet(this.find(this.pkToP2Set, new PointerKeyAndState(queriedPk, DemandRefinementPointsTo.this.stateMachine.getStartState()))).iterator(), new Function<InstanceKeyAndState, InstanceKey>(){

                @Override
                public InstanceKey apply(InstanceKeyAndState object) {
                    return object.getInstanceKey();
                }
            }));
        }

        private boolean addAllToP2Set(Map<PointerKeyAndState, MutableIntSet> p2setMap, PointerKeyAndState pkAndState, IntSet vals) {
            PointerKey pk = pkAndState.getPointerKey();
            if (pk instanceof FilteredPointerKey) {
                FilteredPointerKey.TypeFilter typeFilter = ((FilteredPointerKey)pk).getTypeFilter();
                if (typeFilter instanceof FilteredPointerKey.SingleClassFilter) {
                    final IClass concreteType = ((FilteredPointerKey.SingleClassFilter)typeFilter).getConcreteType();
                    final MutableIntSet tmp = this.intSetFactory.make();
                    vals.foreach(new IntSetAction(){

                        public void act(int x) {
                            InstanceKeyAndState ikAndState = (InstanceKeyAndState)PointsToComputer.this.ikAndStates.getMappedObject(x);
                            if (((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cha.isAssignableFrom(concreteType, ikAndState.getInstanceKey().getConcreteType())) {
                                tmp.add(x);
                            }
                        }
                    });
                    vals = tmp;
                } else if (typeFilter instanceof FilteredPointerKey.SingleInstanceFilter) {
                    final InstanceKey theOnlyInstanceKey = ((FilteredPointerKey.SingleInstanceFilter)typeFilter).getInstance();
                    final MutableIntSet tmp = this.intSetFactory.make();
                    vals.foreach(new IntSetAction(){

                        public void act(int x) {
                            InstanceKeyAndState ikAndState = (InstanceKeyAndState)PointsToComputer.this.ikAndStates.getMappedObject(x);
                            if (ikAndState.getInstanceKey().equals(theOnlyInstanceKey)) {
                                tmp.add(x);
                            }
                        }
                    });
                    vals = tmp;
                } else {
                    Assertions.UNREACHABLE();
                }
            }
            boolean added = this.findOrCreate(p2setMap, pkAndState).addAll(vals);
            return added;
        }

        void compute() {
            CGNode node = ((LocalPointerKey)this.queriedPkAndState.getPointerKey()).getNode();
            if (node.getIR() == null) {
                return;
            }
            DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
            this.addToInitWorklist(this.queriedPkAndState);
            while (true) {
                if (!(this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty())) {
                    this.handleInitWorklist();
                    this.handlePointsToWorklist();
                    this.handleTrackedPointsToWorklist();
                    continue;
                }
                this.makePassOverFieldStmts();
                if (this.initWorklist.isEmpty() && this.pointsToWorklist.isEmpty() && this.trackedPointsToWorklist.isEmpty()) break;
            }
        }

        void handleCopy(final PointerKeyAndState curPkAndState, final PointerKey succPk, IFlowLabel label) {
            Assertions._assert(!label.isBarred());
            StateMachine.State curState = curPkAndState.getState();
            DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                @Override
                public Object apply(StateMachine.State nextState) {
                    PointerKeyAndState succPkAndState = new PointerKeyAndState(succPk, nextState);
                    PointsToComputer.this.handleCopy(curPkAndState, succPkAndState);
                    return null;
                }
            });
        }

        void handleCopy(PointerKeyAndState curPkAndState, PointerKeyAndState succPkAndState) {
            if (!this.addToInitWorklist(succPkAndState) && this.addAllToP2Set(this.pkToP2Set, curPkAndState, this.find(this.pkToP2Set, succPkAndState))) {
                this.addToPToWorklist(curPkAndState);
            }
        }

        void handleAllCopies(PointerKeyAndState curPk, Iterator<? extends Object> succNodes, IFlowLabel label) {
            while (succNodes.hasNext()) {
                this.handleCopy(curPk, (PointerKey)succNodes.next(), label);
            }
        }

        Collection<PointerKeyAndState> matchingPToQueried(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            Collection ret = ArraySet.make();
            Assertions._assert(label.isBarred());
            IFlowLabel unbarredLabel = label.bar();
            StateMachine.State curState = curPkAndState.getState();
            Set<StateMachine.State> predPkStates = this.pointsToQueried.get(predPk);
            for (StateMachine.State predState : predPkStates) {
                StateMachine.State transState = DemandRefinementPointsTo.this.stateMachine.transition(predState, unbarredLabel);
                if (!transState.equals(curState)) continue;
                ret.add(new PointerKeyAndState(predPk, predState));
            }
            return ret;
        }

        void handleBackCopy(PointerKeyAndState curPkAndState, PointerKey predPk, IFlowLabel label) {
            for (PointerKeyAndState predPkAndState : this.matchingPToQueried(curPkAndState, predPk, label)) {
                if (!this.addAllToP2Set(this.pkToP2Set, predPkAndState, this.find(this.pkToP2Set, curPkAndState))) continue;
                this.addToPToWorklist(predPkAndState);
            }
        }

        void handleAllBackCopies(PointerKeyAndState curPkAndState, Iterator<? extends Object> predNodes, IFlowLabel label) {
            while (predNodes.hasNext()) {
                this.handleBackCopy(curPkAndState, (PointerKey)predNodes.next(), label);
            }
        }

        void addToPToWorklist(PointerKeyAndState pkAndState) {
            this.pointsToWorklist.add(pkAndState);
            Set<CallSiteAndCGNode> otfCalls = this.pkToOTFCalls.get(pkAndState);
            for (CallSiteAndCGNode callSiteAndCGNode : otfCalls) {
                this.propTargets(pkAndState, callSiteAndCGNode);
            }
        }

        boolean addToInitWorklist(PointerKeyAndState pkAndState) {
            if (this.pointsToQueried.put(pkAndState.getPointerKey(), pkAndState.getState())) {
                if (pkAndState.getPointerKey() instanceof LocalPointerKey) {
                    CGNode node = ((LocalPointerKey)pkAndState.getPointerKey()).getNode();
                    Assertions._assert(DemandRefinementPointsTo.this.g.hasSubgraphForNode(node), "missing constraints for node of var " + pkAndState);
                }
                this.initWorklist.add(pkAndState);
                return true;
            }
            return false;
        }

        void addToTrackedPToWorklist(PointerKeyAndState pkAndState) {
            if (pkAndState.getPointerKey() instanceof LocalPointerKey) {
                CGNode node = ((LocalPointerKey)pkAndState.getPointerKey()).getNode();
                Assertions._assert(DemandRefinementPointsTo.this.g.hasSubgraphForNode(node), "missing constraints for " + node);
            }
            this.trackedPointsToWorklist.add(pkAndState);
        }

        void propTargets(PointerKeyAndState receiverAndState, CallSiteAndCGNode callSiteAndCGNode) {
            final CGNode caller = callSiteAndCGNode.getCGNode();
            CallSiteReference call = callSiteAndCGNode.getCallSiteReference();
            final StateMachine.State receiverState = receiverAndState.getState();
            OrdinalSet<InstanceKeyAndState> p2set = this.makeOrdinalSet(this.find(this.pkToP2Set, receiverAndState));
            for (InstanceKeyAndState ikAndState : p2set) {
                InstanceKey ik = ikAndState.getInstanceKey();
                IMethod targetMethod = DemandRefinementPointsTo.this.options.getMethodTargetSelector().getCalleeTarget(caller, call, ik.getConcreteType());
                if (targetMethod == null || this.callToOTFTargets.get(callSiteAndCGNode).contains(targetMethod)) continue;
                this.callToOTFTargets.put(callSiteAndCGNode, targetMethod);
                Set<CGNode> targetCGNodes = DemandRefinementPointsTo.this.cg.getNodes(targetMethod.getReference());
                for (final CGNode targetForCall : targetCGNodes) {
                    SSAAbstractInvokeInstruction[] calls;
                    if (targetForCall.getIR() == null) continue;
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(targetForCall);
                    SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = calls = DemandRefinementPointsTo.this.getIR(caller).getCalls(call);
                    int n = calls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final SSAAbstractInvokeInstruction invokeInstr = sSAAbstractInvokeInstructionArray[n2];
                        final ReturnLabel returnLabel = ReturnLabel.make(new CallSiteAndCGNode(call, caller));
                        if (invokeInstr.hasDef()) {
                            final PointerKeyAndState defAndState = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getDef()), receiverState);
                            final PointerKey ret = DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(targetForCall);
                            DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State retState) {
                                    PointsToComputer.this.repropCallArg(defAndState, new PointerKeyAndState(ret, retState), returnLabel.bar());
                                    return null;
                                }
                            });
                        }
                        final PointerKeyAndState exc = new PointerKeyAndState(DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getException()), receiverState);
                        final PointerKey excRet = DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(targetForCall);
                        DemandRefinementPointsTo.this.doTransition(receiverState, returnLabel, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State excRetState) {
                                PointsToComputer.this.repropCallArg(exc, new PointerKeyAndState(excRet, excRetState), returnLabel.bar());
                                return null;
                            }
                        });
                        Iterator<Integer> iter = DemandRefinementPointsTo.this.g.pointerParamValueNums(targetForCall);
                        while (iter.hasNext()) {
                            final int formalNum = iter.next();
                            final int actualNum = formalNum - 1;
                            final ParamBarLabel paramBarLabel = ParamBarLabel.make(new CallSiteAndCGNode(call, caller));
                            DemandRefinementPointsTo.this.doTransition(receiverState, paramBarLabel, new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State formalState) {
                                    PointsToComputer.this.repropCallArg(new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(targetForCall, formalNum), formalState), new PointerKeyAndState(((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, invokeInstr.getUse(actualNum)), receiverState), paramBarLabel);
                                    return null;
                                }
                            });
                        }
                        ++n2;
                    }
                }
            }
        }

        private void repropCallArg(PointerKeyAndState src, PointerKeyAndState dst, IFlowLabel dstToSrcLabel) {
            for (PointerKeyAndState srcToHandle : this.matchingPToQueried(dst, src.getPointerKey(), dstToSrcLabel)) {
                this.handleCopy(srcToHandle, dst);
            }
            MutableIntSet trackedSet = this.find(this.pkToTrackedSet, dst);
            if (!trackedSet.isEmpty() && this.findOrCreate(this.pkToTrackedSet, src).addAll(trackedSet)) {
                this.addToTrackedPToWorklist(src);
            }
        }

        void handleInitWorklist() {
            while (!this.initWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.initWorklist.iterator().next();
                this.initWorklist.remove(curPkAndState);
                PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                if (curPk instanceof LocalPointerKey) {
                    Assertions._assert(DemandRefinementPointsTo.this.g.hasSubgraphForNode(((LocalPointerKey)curPk).getNode()));
                }
                AbstractFlowLabelVisitor v = new AbstractFlowLabelVisitor(){

                    public void visitNew(NewLabel label, Object dst) {
                        final InstanceKey ik = (InstanceKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State newState) {
                                InstanceKeyAndState ikAndState = new InstanceKeyAndState(ik, newState);
                                int n = PointsToComputer.this.ikAndStates.add(ikAndState);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToP2Set, curPkAndState).add(n);
                                PointsToComputer.this.addToPToWorklist(curPkAndState);
                                return null;
                            }
                        });
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            PointerKey loadBase = (PointerKey)dst;
                            PointerKeyAndState loadBaseAndState = new PointerKeyAndState(loadBase, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(loadBaseAndState, field, curPkAndState));
                            if (!PointsToComputer.this.addToInitWorklist(loadBaseAndState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, loadBaseAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        } else {
                            PointsToComputer.this.handleAllCopies(curPkAndState, DemandRefinementPointsTo.this.g.getWritesToInstanceField(field), MatchLabel.v());
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllCopies(curPkAndState, DemandRefinementPointsTo.this.g.getWritesToStaticField((StaticFieldKey)dst), AssignGlobalLabel.v());
                    }

                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleCopy(curPkAndState, (PointerKey)dst, AssignLabel.v());
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, v);
                this.handleForwInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleCopy(src, dst, label);
                    }
                });
            }
        }

        private void handleForwInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler) {
            PointerKey curPk = curPkAndState.getPointerKey();
            if (curPk instanceof LocalPointerKey) {
                SSAInvokeInstruction callInstr;
                final LocalPointerKey localPk = (LocalPointerKey)curPk;
                if (DemandRefinementPointsTo.this.g.isParam(localPk)) {
                    final CGNode callee = localPk.getNode();
                    final int paramPos = localPk.getValueNumber() - 1;
                    Iterator<CGNode> iter = DemandRefinementPointsTo.this.cg.getPredNodes(callee);
                    while (iter.hasNext()) {
                        final CGNode caller = iter.next();
                        final IR ir = DemandRefinementPointsTo.this.getIR(caller);
                        Iterator<CallSiteReference> iterator = DemandRefinementPointsTo.this.cg.getPossibleSites(caller, callee);
                        while (iterator.hasNext()) {
                            final CallSiteReference call = iterator.next();
                            final CallSiteAndCGNode callSiteAndCGNode = new CallSiteAndCGNode(call, caller);
                            final ParamLabel paramLabel = ParamLabel.make(callSiteAndCGNode);
                            DemandRefinementPointsTo.this.doTransition(curPkAndState.getState(), paramLabel, new Function<StateMachine.State, Object>(){

                                private void propagateToCallee() {
                                    if (caller.getIR() == null) {
                                        return;
                                    }
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                    SSAAbstractInvokeInstruction[] callInstrs = ir.getCalls(call);
                                    int i = 0;
                                    while (i < callInstrs.length) {
                                        SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                                        PointerKey actualPk = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                                        Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(actualPk));
                                        Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(localPk));
                                        handler.handle(curPkAndState, actualPk, paramLabel);
                                        ++i;
                                    }
                                }

                                @Override
                                public Object apply(StateMachine.State callerState) {
                                    Set<CGNode> possibleTargets = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cg.getPossibleTargets(caller, call);
                                    if (PointsToComputer.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                        this.propagateToCallee();
                                    } else if (PointsToComputer.this.callToOTFTargets.get(callSiteAndCGNode).contains(callee.getMethod())) {
                                        this.propagateToCallee();
                                    } else {
                                        PointsToComputer.this.queryCallTargets(callSiteAndCGNode, ir, callerState);
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                }
                if ((callInstr = DemandRefinementPointsTo.this.g.getInstrReturningTo(localPk)) != null) {
                    Set<CGNode> possibleCallees;
                    CGNode caller = localPk.getNode();
                    boolean isExceptional = localPk.getValueNumber() == callInstr.getException();
                    CallSiteReference callSiteRef = callInstr.getCallSite();
                    CallSiteAndCGNode callSiteAndCGNode = new CallSiteAndCGNode(callSiteRef, caller);
                    if (this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.cg.getPossibleTargets(caller, callSiteRef))) {
                        for (CGNode callee : possibleCallees) {
                            if (callee.getIR() == null) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else if (this.callToOTFTargets.containsKey(callSiteAndCGNode)) {
                        Set<IMethod> targetMethods = this.callToOTFTargets.get(callSiteAndCGNode);
                        for (CGNode callee : possibleCallees) {
                            if (!targetMethods.contains(callee.getMethod()) || callee.getIR() == null) continue;
                            DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                            PointerKey retVal = isExceptional ? DemandRefinementPointsTo.this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : DemandRefinementPointsTo.this.heapModel.getPointerKeyForReturnValue(callee);
                            Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(retVal));
                            handler.handle(curPkAndState, retVal, ReturnLabel.make(callSiteAndCGNode));
                        }
                    } else {
                        this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.this.getIR(caller), curPkAndState.getState());
                    }
                }
            }
        }

        private void trackInstanceField(InstanceKeyAndState ikAndState, IField field, MultiMap<InstanceKeyAndState, IField> ikToFields) {
            StateMachine.State state = ikAndState.getState();
            Assertions._assert(this.refineFieldAccesses(field));
            ikToFields.put(ikAndState, field);
            Iterator<InstanceKey> iter = DemandRefinementPointsTo.this.g.getPredNodes(ikAndState.getInstanceKey(), NewLabel.v());
            while (iter.hasNext()) {
                PointerKey ikPred = (PointerKey)((Object)iter.next());
                PointerKeyAndState ikPredAndState = new PointerKeyAndState(ikPred, state);
                int mappedIndex = this.ikAndStates.getMappedIndex(ikAndState);
                Assertions._assert(mappedIndex != -1);
                if (!this.findOrCreate(this.pkToTrackedSet, ikPredAndState).add(mappedIndex)) continue;
                this.addToTrackedPToWorklist(ikPredAndState);
            }
        }

        private boolean refineFieldAccesses(IField field) {
            return DemandRefinementPointsTo.this.refinementPolicy.getFieldRefinePolicy().shouldRefine(field);
        }

        private void queryCallTargets(CallSiteAndCGNode callSiteAndCGNode, IR ir, StateMachine.State callerState) {
            CallSiteReference call = callSiteAndCGNode.getCallSiteReference();
            CGNode caller = callSiteAndCGNode.getCGNode();
            SSAAbstractInvokeInstruction[] sSAAbstractInvokeInstructionArray = ir.getCalls(call);
            int n = sSAAbstractInvokeInstructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SSAAbstractInvokeInstruction callInstr = sSAAbstractInvokeInstructionArray[n2];
                PointerKey thisArg = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(0));
                PointerKeyAndState thisArgAndState = new PointerKeyAndState(thisArg, callerState);
                if (this.pkToOTFCalls.put(thisArgAndState, callSiteAndCGNode)) {
                    CGNode node = ((LocalPointerKey)thisArg).getNode();
                    if (node.getIR() == null) {
                        return;
                    }
                    DemandRefinementPointsTo.this.g.addSubgraphForNode(node);
                    if (!this.addToInitWorklist(thisArgAndState)) {
                        this.propTargets(thisArgAndState, callSiteAndCGNode);
                    }
                } else {
                    this.propTargets(thisArgAndState, callSiteAndCGNode);
                }
                ++n2;
            }
        }

        private boolean noOnTheFlyNeeded(CallSiteAndCGNode call, Set<CGNode> possibleTargets) {
            return !DemandRefinementPointsTo.this.refinementPolicy.getCallGraphRefinePolicy().shouldRefine(call) || possibleTargets.size() <= 1;
        }

        void handlePointsToWorklist() {
            while (!this.pointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.pointsToWorklist.iterator().next();
                this.pointsToWorklist.remove(curPkAndState);
                PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            PointerKeyAndState storeBaseAndState = new PointerKeyAndState((PointerKey)dst, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBaseAndState, field, curPkAndState));
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeBaseAndState))) {
                                if (!PointsToComputer.this.forwInstKeyToFields.get(ikAndState).contains(field)) continue;
                                InstanceFieldKeyAndState ifKeyAndState = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifKeyAndState).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState));
                            }
                        } else {
                            PointsToComputer.this.handleAllBackCopies(curPkAndState, DemandRefinementPointsTo.this.g.getReadsOfInstanceField(field), MatchBarLabel.v());
                        }
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            PointerKey dstPtrKey = (PointerKey)dst;
                            PointerKeyAndState loadDefAndState = new PointerKeyAndState(dstPtrKey, curState);
                            PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadDefAndState));
                            if (PointsToComputer.this.pointsToQueried.get(dstPtrKey).contains(curState)) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.forwInstKeyToFields);
                                }
                            }
                        }
                    }

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        PointsToComputer.this.handleAllBackCopies(curPkAndState, DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst), label.bar());
                    }

                    public void visitAssign(AssignLabel label, Object dst) {
                        PointsToComputer.this.handleBackCopy(curPkAndState, (PointerKey)dst, label.bar());
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            PointerKeyAndState storeDst = new PointerKeyAndState((PointerKey)dst, curState);
                            PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                            MutableIntSet trackedSet = PointsToComputer.this.find(PointsToComputer.this.pkToTrackedSet, storeDst);
                            if (!trackedSet.isEmpty()) {
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, curPkAndState))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll(trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.backInstKeyToFields);
                                }
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, PointerKey dst, IFlowLabel label) {
                        PointsToComputer.this.handleBackCopy(src, dst, label);
                    }
                }, false);
            }
        }

        private void handleBackInterproc(final PointerKeyAndState curPkAndState, final CopyHandler handler, boolean addGraphs) {
            PointerKey curPk = curPkAndState.getPointerKey();
            StateMachine.State curState = curPkAndState.getState();
            if (curPk instanceof ReturnValueKey) {
                final ReturnValueKey returnKey = (ReturnValueKey)curPk;
                final CGNode callee = returnKey.getNode();
                final boolean isExceptional = returnKey instanceof ExceptionReturnValueKey;
                Iterator<CGNode> iter = DemandRefinementPointsTo.this.cg.getPredNodes(callee);
                while (iter.hasNext()) {
                    final CGNode caller = iter.next();
                    if (!addGraphs && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(caller)) continue;
                    final IR ir = DemandRefinementPointsTo.this.getIR(caller);
                    Iterator<CallSiteReference> iterator = DemandRefinementPointsTo.this.cg.getPossibleSites(caller, callee);
                    while (iterator.hasNext()) {
                        final CallSiteReference call = iterator.next();
                        final CallSiteAndCGNode callSiteAndCGNode = new CallSiteAndCGNode(call, caller);
                        final ReturnBarLabel returnBarLabel = ReturnBarLabel.make(callSiteAndCGNode);
                        DemandRefinementPointsTo.this.doTransition(curState, returnBarLabel, new Function<StateMachine.State, Object>(){

                            private void propagateToCaller() {
                                if (caller.getIR() == null) {
                                    return;
                                }
                                DemandRefinementPointsTo.this.g.addSubgraphForNode(caller);
                                SSAAbstractInvokeInstruction[] callInstrs = ir.getCalls(call);
                                int i = 0;
                                while (i < callInstrs.length) {
                                    SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                                    PointerKey returnAtCallerKey = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                                    Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(returnAtCallerKey));
                                    Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(returnKey));
                                    handler.handle(curPkAndState, returnAtCallerKey, returnBarLabel);
                                    ++i;
                                }
                            }

                            @Override
                            public Object apply(StateMachine.State callerState) {
                                Set<CGNode> possibleTargets = ((PointsToComputer)PointsToComputer.this).DemandRefinementPointsTo.this.cg.getPossibleTargets(caller, call);
                                if (PointsToComputer.this.noOnTheFlyNeeded(callSiteAndCGNode, possibleTargets)) {
                                    this.propagateToCaller();
                                } else if (PointsToComputer.this.callToOTFTargets.get(callSiteAndCGNode).contains(callee.getMethod())) {
                                    this.propagateToCaller();
                                } else {
                                    PointsToComputer.this.queryCallTargets(callSiteAndCGNode, ir, callerState);
                                }
                                return null;
                            }
                        });
                    }
                }
            }
            if (curPk instanceof LocalPointerKey) {
                LocalPointerKey localPk = (LocalPointerKey)curPk;
                CGNode caller = localPk.getNode();
                Iterator<SSAInvokeInstruction> iter = DemandRefinementPointsTo.this.g.getInstrsPassingParam(localPk);
                while (iter.hasNext()) {
                    SSAInvokeInstruction callInstr = iter.next();
                    int i = 0;
                    while (i < callInstr.getNumberOfUses()) {
                        if (localPk.getValueNumber() == callInstr.getUse(i)) {
                            Set<CGNode> possibleCallees;
                            CallSiteReference callSiteRef = callInstr.getCallSite();
                            CallSiteAndCGNode callSiteAndCGNode = new CallSiteAndCGNode(callSiteRef, caller);
                            if (this.noOnTheFlyNeeded(callSiteAndCGNode, possibleCallees = DemandRefinementPointsTo.this.cg.getPossibleTargets(caller, callSiteRef))) {
                                for (CGNode callee : possibleCallees) {
                                    if (!addGraphs && !DemandRefinementPointsTo.this.g.hasSubgraphForNode(callee) || callee.getIR() == null) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                    PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                    Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                    handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                                }
                            } else if (this.callToOTFTargets.containsKey(callSiteAndCGNode)) {
                                Set<IMethod> targetMethods = this.callToOTFTargets.get(callSiteAndCGNode);
                                for (CGNode callee : possibleCallees) {
                                    if (!targetMethods.contains(callee.getMethod()) || caller.getIR() == null) continue;
                                    DemandRefinementPointsTo.this.g.addSubgraphForNode(callee);
                                    PointerKey paramVal = DemandRefinementPointsTo.this.heapModel.getPointerKeyForLocal(callee, i + 1);
                                    Assertions._assert(DemandRefinementPointsTo.this.g.containsNode(paramVal));
                                    handler.handle(curPkAndState, paramVal, ParamBarLabel.make(callSiteAndCGNode));
                                }
                            } else {
                                this.queryCallTargets(callSiteAndCGNode, DemandRefinementPointsTo.this.getIR(caller), curState);
                            }
                        }
                        ++i;
                    }
                }
            }
        }

        public void handleTrackedPointsToWorklist() {
            while (!this.trackedPointsToWorklist.isEmpty()) {
                DemandRefinementPointsTo.this.incrementNumNodesTraversed();
                final PointerKeyAndState curPkAndState = this.trackedPointsToWorklist.iterator().next();
                this.trackedPointsToWorklist.remove(curPkAndState);
                PointerKey curPk = curPkAndState.getPointerKey();
                final StateMachine.State curState = curPkAndState.getState();
                final MutableIntSet trackedSet = this.find(this.pkToTrackedSet, curPkAndState);
                AbstractFlowLabelVisitor succVisitor = new AbstractFlowLabelVisitor(){

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(trackedSet)) {
                                boolean needField = PointsToComputer.this.forwInstKeyToFields.get(ikAndState).contains(field);
                                PointerKeyAndState storeDst = new PointerKeyAndState((PointerKey)dst, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(curPkAndState, field, storeDst));
                                if (!needField || PointsToComputer.this.addToInitWorklist(storeDst)) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToP2Set, ifk).addAll(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeDst));
                            }
                        }
                    }
                };
                DemandRefinementPointsTo.this.g.visitSuccs(curPk, succVisitor);
                AbstractFlowLabelVisitor predVisitor = new AbstractFlowLabelVisitor(){

                    public void visitAssignGlobal(AssignGlobalLabel label, Object dst) {
                        Iterator<? extends Object> readIter = DemandRefinementPointsTo.this.g.getReadsOfStaticField((StaticFieldKey)dst);
                        while (readIter.hasNext()) {
                            final PointerKey predPk = (PointerKey)readIter.next();
                            DemandRefinementPointsTo.this.doTransition(curState, AssignGlobalBarLabel.v(), new Function<StateMachine.State, Object>(){

                                @Override
                                public Object apply(StateMachine.State predPkState) {
                                    PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                    if (PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToTrackedSet, predPkAndState).addAll(trackedSet)) {
                                        PointsToComputer.this.addToTrackedPToWorklist(predPkAndState);
                                    }
                                    return null;
                                }
                            });
                        }
                    }

                    public void visitPutField(PutFieldLabel label, Object dst) {
                        block3: {
                            IField field;
                            block2: {
                                field = label.getField();
                                if (!PointsToComputer.this.refineFieldAccesses(field)) break block2;
                                PointerKeyAndState storeBase = new PointerKeyAndState((PointerKey)dst, curState);
                                PointsToComputer.this.encounteredStores.add(new StoreEdge(storeBase, field, curPkAndState));
                                if (PointsToComputer.this.addToInitWorklist(storeBase)) break block3;
                                for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(PointsToComputer.this.find(PointsToComputer.this.pkToP2Set, storeBase))) {
                                    InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                    PointsToComputer.this.findOrCreate(PointsToComputer.this.instFieldKeyToTrackedSet, ifk).addAll(trackedSet);
                                    PointsToComputer.this.trackInstanceField(ikAndState, field, PointsToComputer.this.backInstKeyToFields);
                                }
                                break block3;
                            }
                            Iterator<PointerKey> readIter = DemandRefinementPointsTo.this.g.getReadsOfInstanceField(field);
                            while (readIter.hasNext()) {
                                final PointerKey predPk = readIter.next();
                                DemandRefinementPointsTo.this.doTransition(curState, MatchBarLabel.v(), new Function<StateMachine.State, Object>(){

                                    @Override
                                    public Object apply(StateMachine.State predPkState) {
                                        PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                        if (PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToTrackedSet, predPkAndState).addAll(trackedSet)) {
                                            PointsToComputer.this.addToTrackedPToWorklist(predPkAndState);
                                        }
                                        return null;
                                    }
                                });
                            }
                        }
                    }

                    public void visitGetField(GetFieldLabel label, Object dst) {
                        IField field = label.getField();
                        if (PointsToComputer.this.refineFieldAccesses(field)) {
                            for (InstanceKeyAndState ikAndState : PointsToComputer.this.makeOrdinalSet(trackedSet)) {
                                boolean needField = PointsToComputer.this.backInstKeyToFields.get(ikAndState).contains(field);
                                PointerKeyAndState loadedVal = new PointerKeyAndState((PointerKey)dst, curState);
                                PointsToComputer.this.addEncounteredLoad(new LoadEdge(curPkAndState, field, loadedVal));
                                if (!needField) continue;
                                InstanceFieldKeyAndState ifk = PointsToComputer.this.getInstFieldKey(ikAndState, field);
                                if (!PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToTrackedSet, loadedVal).addAll(PointsToComputer.this.find(PointsToComputer.this.instFieldKeyToTrackedSet, ifk))) continue;
                                PointsToComputer.this.addToTrackedPToWorklist(loadedVal);
                            }
                        }
                    }

                    public void visitAssign(AssignLabel label, Object dst) {
                        final PointerKey predPk = (PointerKey)dst;
                        DemandRefinementPointsTo.this.doTransition(curState, AssignBarLabel.v(), new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State predPkState) {
                                PointerKeyAndState predPkAndState = new PointerKeyAndState(predPk, predPkState);
                                if (PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToTrackedSet, predPkAndState).addAll(trackedSet)) {
                                    PointsToComputer.this.addToTrackedPToWorklist(predPkAndState);
                                }
                                return null;
                            }
                        });
                    }
                };
                DemandRefinementPointsTo.this.g.visitPreds(curPk, predVisitor);
                this.handleBackInterproc(curPkAndState, new CopyHandler(){

                    void handle(PointerKeyAndState src, final PointerKey dst, IFlowLabel label) {
                        Assertions._assert(src == curPkAndState);
                        DemandRefinementPointsTo.this.doTransition(curState, label, new Function<StateMachine.State, Object>(){

                            @Override
                            public Object apply(StateMachine.State dstState) {
                                PointerKeyAndState dstAndState = new PointerKeyAndState(dst, dstState);
                                if (PointsToComputer.this.findOrCreate(PointsToComputer.this.pkToTrackedSet, dstAndState).addAll(trackedSet)) {
                                    PointsToComputer.this.addToTrackedPToWorklist(dstAndState);
                                }
                                return null;
                            }
                        });
                    }
                }, true);
            }
        }

        private void addEncounteredLoad(LoadEdge loadEdge) {
            this.encounteredLoads.add(loadEdge);
        }

        public void makePassOverFieldStmts() {
            IField field;
            for (StoreEdge storeEdge : this.encounteredStores) {
                PointerKeyAndState storedValAndState = storeEdge.val;
                field = storeEdge.field;
                PointerKeyAndState baseAndState = storeEdge.base;
                MutableIntSet trackedSet = this.find(this.pkToTrackedSet, baseAndState);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(trackedSet)) {
                    if (!this.forwInstKeyToFields.get(ikAndState).contains(field) || this.addToInitWorklist(storedValAndState)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    this.findOrCreate(this.instFieldKeyToP2Set, ifk).addAll(this.find(this.pkToP2Set, storedValAndState));
                }
            }
            for (LoadEdge loadEdge : this.encounteredLoads) {
                PointerKeyAndState loadedValAndState = loadEdge.val;
                field = loadEdge.field;
                PointerKey basePointerKey = loadEdge.base.getPointerKey();
                StateMachine.State loadDstState = loadedValAndState.getState();
                PointerKeyAndState baseAndStateToHandle = new PointerKeyAndState(basePointerKey, loadDstState);
                boolean basePointerOkay = this.pointsToQueried.get(basePointerKey).contains(loadDstState) || !this.pointsToQueried.get(loadedValAndState.getPointerKey()).contains(loadDstState) || this.initWorklist.contains(loadedValAndState);
                Assertions._assert(basePointerOkay, "queried " + loadedValAndState + " but not " + baseAndStateToHandle);
                MutableIntSet curP2Set = this.find(this.pkToP2Set, baseAndStateToHandle);
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(curP2Set)) {
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.addAllToP2Set(this.pkToP2Set, loadedValAndState, this.find(this.instFieldKeyToP2Set, ifk))) continue;
                    this.addToPToWorklist(loadedValAndState);
                }
                PointerKeyAndState baseAndState = loadEdge.base;
                for (InstanceKeyAndState ikAndState : this.makeOrdinalSet(this.find(this.pkToTrackedSet, baseAndState))) {
                    if (!this.backInstKeyToFields.get(ikAndState).contains(field)) continue;
                    InstanceFieldKeyAndState ifk = this.getInstFieldKey(ikAndState, field);
                    if (!this.findOrCreate(this.pkToTrackedSet, loadedValAndState).addAll(this.find(this.instFieldKeyToTrackedSet, ifk))) continue;
                    this.addToTrackedPToWorklist(loadedValAndState);
                }
            }
        }

        private InstanceFieldKeyAndState getInstFieldKey(InstanceKeyAndState ikAndState, IField field) {
            return new InstanceFieldKeyAndState(new InstanceFieldKey(ikAndState.getInstanceKey(), field), ikAndState.getState());
        }

        private <K> MutableIntSet findOrCreate(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.intSetFactory.make();
                M.put(key, result);
            }
            return result;
        }

        private <K> MutableIntSet find(Map<K, MutableIntSet> M, K key) {
            MutableIntSet result = M.get(key);
            if (result == null) {
                result = this.emptySet;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PointsToResult {
        SUCCESS,
        NOMOREREFINE,
        BUDGETEXCEEDED;

    }

    private static final class StoreEdge {
        final PointerKeyAndState base;
        final IField field;
        final PointerKeyAndState val;

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.val.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + this.base.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoreEdge other = (StoreEdge)obj;
            if (!this.val.equals(other.val)) {
                return false;
            }
            if (!this.field.equals(other.field)) {
                return false;
            }
            return this.base.equals(other.base);
        }

        public StoreEdge(PointerKeyAndState base, IField field, PointerKeyAndState val) {
            this.base = base;
            this.field = field;
            this.val = val;
        }
    }
}

