/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManualFieldPolicy
implements FieldRefinePolicy {
    private static final Pattern refinePattern = Pattern.compile("Lca/mcgill/sable/util|Ljava/util|Lpolyglot/util/TypedList");
    private static final int NUM_DECISIONS_TO_TRACK = 10;
    private final boolean[] decisions = new boolean[10];
    private int curDecision;
    private final IClass[] encounteredClasses = new IClass[10];
    private final ClassHierarchy cha;

    public boolean shouldRefine(IField field) {
        if (field == ArrayContents.v()) {
            return true;
        }
        IClass declaringClass = field.getDeclaringClass();
        Matcher m = refinePattern.matcher(declaringClass.toString());
        boolean foundPattern = m.find();
        this.recordDecision(declaringClass, foundPattern);
        return foundPattern;
    }

    private void recordDecision(IClass declaringClass, boolean foundPattern) {
        IClass topMostClass;
        if (this.curDecision < 10 && this.notSuperOfAnyEncountered(topMostClass = this.removeInner(declaringClass))) {
            this.encounteredClasses[this.curDecision] = topMostClass;
            this.decisions[this.curDecision] = foundPattern;
            ++this.curDecision;
        }
    }

    private boolean notSuperOfAnyEncountered(IClass klass) {
        int i = 0;
        while (i < this.curDecision) {
            if (this.cha.isAssignableFrom(klass, this.encounteredClasses[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IClass removeInner(IClass klass) {
        ClassLoaderReference cl = klass.getClassLoader().getReference();
        String klassStr = klass.getName().toString();
        int dollarIndex = klassStr.indexOf(36);
        if (dollarIndex == -1) {
            return klass;
        }
        String topMostName = klassStr.substring(0, dollarIndex);
        IClass topMostClass = this.cha.lookupClass(TypeReference.findOrCreate(cl, topMostName));
        Assertions._assert(topMostClass != null);
        return topMostClass;
    }

    public ManualFieldPolicy(ClassHierarchy cha) {
        this.cha = cha;
    }

    public boolean nextPass() {
        return false;
    }

    public String getHistory() {
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < this.curDecision) {
            if (this.decisions[i]) {
                ret.append("refined ");
            } else {
                ret.append("skipped ");
            }
            ret.append(this.encounteredClasses[i]);
            if (i + 1 < this.curDecision) {
                ret.append(", ");
            }
            ++i;
        }
        return ret.toString();
    }
}

