/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.CallGraphRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.ManualFieldPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.ipa.cha.ClassHierarchy;

public class ManualRefinementPolicy
implements RefinementPolicy {
    private static final int PASS_BUDGET = 12000;
    private static final int NUM_PASSES = 1;
    private final FieldRefinePolicy fieldRefinePolicy;
    private final CallGraphRefinePolicy callGraphRefinePolicy;

    private ManualRefinementPolicy(ClassHierarchy cha) {
        this.fieldRefinePolicy = new ManualFieldPolicy(cha);
        this.callGraphRefinePolicy = new AlwaysRefineCGPolicy();
    }

    public int getBudgetForPass(int passNum) {
        return 12000;
    }

    public CallGraphRefinePolicy getCallGraphRefinePolicy() {
        return this.callGraphRefinePolicy;
    }

    public FieldRefinePolicy getFieldRefinePolicy() {
        return this.fieldRefinePolicy;
    }

    public int getNumPasses() {
        return 1;
    }

    public boolean nextPass() {
        boolean moreFieldRefine = this.fieldRefinePolicy.nextPass();
        boolean moreCallRefine = this.callGraphRefinePolicy.startNewPass();
        return moreFieldRefine || moreCallRefine;
    }

    /* synthetic */ ManualRefinementPolicy(ClassHierarchy classHierarchy, ManualRefinementPolicy manualRefinementPolicy) {
        this(classHierarchy);
    }

    public static class Factory
    implements RefinementPolicyFactory {
        private final ClassHierarchy cha;

        public Factory(ClassHierarchy cha) {
            this.cha = cha;
        }

        public RefinementPolicy make() {
            return new ManualRefinementPolicy(this.cha, null);
        }
    }
}

