/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg.refinepolicy;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.alg.refinepolicy.AlwaysRefineCGPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.CallGraphRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.FieldRefinePolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicy;
import com.ibm.wala.demandpa.alg.refinepolicy.RefinementPolicyFactory;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;

public class TunedRefinementPolicy
implements RefinementPolicy {
    private final ClassHierarchy cha;
    private final CallGraphRefinePolicy cgRefinePolicy = new AlwaysRefineCGPolicy();
    private final FieldRefinePolicy fieldRefinePolicy = new TunedFieldRefinementPolicy();
    private static final int NUM_PASSES = 3;
    private static final int[] BUDGET_PER_PASS = new int[]{1000, 12000, 12000};

    public TunedRefinementPolicy(ClassHierarchy cha) {
        this.cha = cha;
    }

    public int getBudgetForPass(int passNum) {
        return BUDGET_PER_PASS[passNum];
    }

    public CallGraphRefinePolicy getCallGraphRefinePolicy() {
        return this.cgRefinePolicy;
    }

    public FieldRefinePolicy getFieldRefinePolicy() {
        return this.fieldRefinePolicy;
    }

    public int getNumPasses() {
        return 3;
    }

    public boolean nextPass() {
        return this.fieldRefinePolicy.nextPass();
    }

    public static class Factory
    implements RefinementPolicyFactory {
        private final ClassHierarchy cha;

        public Factory(ClassHierarchy cha) {
            this.cha = cha;
        }

        public RefinementPolicy make() {
            return new TunedRefinementPolicy(this.cha);
        }
    }

    private class TunedFieldRefinementPolicy
    implements FieldRefinePolicy {
        private final Collection<IClass> typesToRefine = HashSetFactory.make();
        private IClass firstSkippedClass = null;

        private TunedFieldRefinementPolicy() {
        }

        public boolean nextPass() {
            if (this.firstSkippedClass != null) {
                this.typesToRefine.add(this.firstSkippedClass);
                this.firstSkippedClass = null;
                return true;
            }
            return false;
        }

        public boolean shouldRefine(IField field) {
            if (field == ArrayContents.v()) {
                return true;
            }
            IClass classToCheck = this.removeInner(field.getDeclaringClass());
            if (this.superOfAnyEncountered(classToCheck)) {
                return true;
            }
            if (this.firstSkippedClass == null) {
                this.firstSkippedClass = classToCheck;
            }
            return false;
        }

        private boolean superOfAnyEncountered(IClass klass) {
            for (IClass toRefine : this.typesToRefine) {
                if (!TunedRefinementPolicy.this.cha.isAssignableFrom(klass, toRefine)) continue;
                return true;
            }
            return false;
        }

        private IClass removeInner(IClass klass) {
            ClassLoaderReference cl = klass.getClassLoader().getReference();
            String klassStr = klass.getName().toString();
            int dollarIndex = klassStr.indexOf(36);
            if (dollarIndex == -1) {
                return klass;
            }
            String topMostName = klassStr.substring(0, dollarIndex);
            IClass topMostClass = TunedRefinementPolicy.this.cha.lookupClass(TypeReference.findOrCreate(cl, topMostName));
            return topMostClass != null ? topMostClass : klass;
        }
    }
}

