/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.FlowLabelGraph;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PointerKeyAndCallSite;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.demandpa.util.PointerParamValueNumIterator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.StaticFieldKey;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ReferenceCleanser;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVectorIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DemandFlowGraph
extends FlowLabelGraph {
    private static final boolean DEBUG = false;
    private static int wipeCount = 0;
    protected final CallGraph cg;
    protected final HeapModel heapModel;
    protected final MemoryAccessMap mam;
    protected final ClassHierarchy cha;
    final Map<PointerKey, SSAInvokeInstruction> callDefs = HashMapFactory.make();
    final Map<PointerKey, Set<SSAInvokeInstruction>> callParams = HashMapFactory.make();
    final Map<PointerKey, CGNode> params = HashMapFactory.make();
    final Map<PointerKey, CGNode> returns = HashMapFactory.make();
    final BitVectorIntSet cgNodesVisited = new BitVectorIntSet();

    public void addSubgraphForNode(CGNode node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        if (node.getIR() == null) {
            throw new IllegalArgumentException("no ir for node " + node);
        }
        int n = this.cg.getNumber(node);
        if (!this.cgNodesVisited.contains(n)) {
            this.cgNodesVisited.add(n);
            this.unconditionallyAddConstraintsFromNode(node);
            this.addNodesForParameters(node);
        }
    }

    public boolean hasSubgraphForNode(CGNode node) {
        return this.cgNodesVisited.contains(this.cg.getNumber(node));
    }

    public boolean isParam(LocalPointerKey pk) {
        return this.params.get(pk) != null;
    }

    public Iterator<PointerKeyAndCallSite> getParamSuccs(LocalPointerKey pk) {
        CGNode cgNode = this.params.get(pk);
        if (cgNode == null) {
            return EmptyIterator.instance();
        }
        int paramPos = pk.getValueNumber() - 1;
        ArrayList<PointerKeyAndCallSite> paramSuccs = new ArrayList<PointerKeyAndCallSite>();
        for (CGNode caller : this.cg) {
            this.addSubgraphForNode(caller);
            IR ir = caller.getIR();
            Iterator<CallSiteReference> iterator = ir.iterateCallSites();
            while (iterator.hasNext()) {
                CallSiteReference call = iterator.next();
                if (!this.cg.getPossibleTargets(caller, call).contains(cgNode)) continue;
                SSAAbstractInvokeInstruction[] callInstrs = ir.getCalls(call);
                int i = 0;
                while (i < callInstrs.length) {
                    SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                    PointerKey actualPk = this.heapModel.getPointerKeyForLocal(caller, callInstr.getUse(paramPos));
                    Assertions._assert(this.containsNode(actualPk));
                    Assertions._assert(this.containsNode(pk));
                    paramSuccs.add(new PointerKeyAndCallSite(actualPk, call));
                    ++i;
                }
            }
        }
        return paramSuccs.iterator();
    }

    public Iterator<SSAInvokeInstruction> getInstrsPassingParam(LocalPointerKey pk) {
        Set<SSAInvokeInstruction> instrs = this.callParams.get(pk);
        if (instrs == null) {
            return EmptyIterator.instance();
        }
        return instrs.iterator();
    }

    public Iterator<PointerKeyAndCallSite> getParamPreds(LocalPointerKey pk) {
        Set<SSAInvokeInstruction> instrs = this.callParams.get(pk);
        if (instrs == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> paramPreds = new ArrayList<PointerKeyAndCallSite>();
        for (SSAInvokeInstruction callInstr : instrs) {
            int i = 0;
            while (i < callInstr.getNumberOfUses()) {
                if (pk.getValueNumber() == callInstr.getUse(i)) {
                    CallSiteReference callSiteRef = callInstr.getCallSite();
                    Set<CGNode> possibleCallees = this.cg.getPossibleTargets(pk.getNode(), callSiteRef);
                    for (CGNode callee : possibleCallees) {
                        this.addSubgraphForNode(callee);
                        PointerKey paramVal = this.heapModel.getPointerKeyForLocal(callee, i + 1);
                        Assertions._assert(this.containsNode(paramVal));
                        paramPreds.add(new PointerKeyAndCallSite(paramVal, callSiteRef));
                    }
                }
                ++i;
            }
        }
        return paramPreds.iterator();
    }

    public SSAInvokeInstruction getInstrReturningTo(LocalPointerKey pk) {
        return this.callDefs.get(pk);
    }

    public Iterator<PointerKeyAndCallSite> getReturnSuccs(LocalPointerKey pk) {
        SSAInvokeInstruction callInstr = this.callDefs.get(pk);
        if (callInstr == null) {
            return EmptyIterator.instance();
        }
        ArrayList<PointerKeyAndCallSite> returnSuccs = new ArrayList<PointerKeyAndCallSite>();
        boolean isExceptional = pk.getValueNumber() == callInstr.getException();
        CallSiteReference callSiteRef = callInstr.getCallSite();
        Set<CGNode> possibleCallees = this.cg.getPossibleTargets(pk.getNode(), callSiteRef);
        for (CGNode callee : possibleCallees) {
            this.addSubgraphForNode(callee);
            PointerKey retVal = isExceptional ? this.heapModel.getPointerKeyForExceptionalReturnValue(callee) : this.heapModel.getPointerKeyForReturnValue(callee);
            Assertions._assert(this.containsNode(retVal));
            returnSuccs.add(new PointerKeyAndCallSite(retVal, callSiteRef));
        }
        return returnSuccs.iterator();
    }

    public boolean isReturnVal(LocalPointerKey pk) {
        return this.returns.get(pk) != null;
    }

    public Iterator<PointerKeyAndCallSite> getReturnPreds(LocalPointerKey pk) {
        CGNode cgNode = this.returns.get(pk);
        if (cgNode == null) {
            return EmptyIterator.instance();
        }
        boolean isExceptional = pk == this.heapModel.getPointerKeyForExceptionalReturnValue(cgNode);
        ArrayList<PointerKeyAndCallSite> returnPreds = new ArrayList<PointerKeyAndCallSite>();
        for (CGNode caller : this.cg) {
            this.addSubgraphForNode(caller);
            IR ir = caller.getIR();
            Iterator<CallSiteReference> iterator = ir.iterateCallSites();
            while (iterator.hasNext()) {
                CallSiteReference call = iterator.next();
                if (!this.cg.getPossibleTargets(caller, call).contains(cgNode)) continue;
                SSAAbstractInvokeInstruction[] callInstrs = ir.getCalls(call);
                int i = 0;
                while (i < callInstrs.length) {
                    SSAAbstractInvokeInstruction callInstr = callInstrs[i];
                    PointerKey returnPk = this.heapModel.getPointerKeyForLocal(caller, isExceptional ? callInstr.getException() : callInstr.getDef());
                    Assertions._assert(this.containsNode(returnPk));
                    Assertions._assert(this.containsNode(pk));
                    returnPreds.add(new PointerKeyAndCallSite(returnPk, call));
                    ++i;
                }
            }
        }
        return returnPreds.iterator();
    }

    public Iterator<? extends Object> getWritesToStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldWrites = this.mam.getFieldWrites(sfk.getField());
        for (MemoryAccess a : fieldWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getSuccNodes(sfk, AssignGlobalLabel.v());
    }

    public Iterator<? extends Object> getReadsOfStaticField(StaticFieldKey sfk) throws IllegalArgumentException {
        if (sfk == null) {
            throw new IllegalArgumentException("sfk == null");
        }
        Collection<MemoryAccess> fieldReads = this.mam.getFieldReads(sfk.getField());
        for (MemoryAccess a : fieldReads) {
            this.addSubgraphForNode(a.getNode());
        }
        return this.getPredNodes(sfk, AssignGlobalLabel.v());
    }

    public Iterator<PointerKey> getWritesToInstanceField(IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayWrites();
        }
        Collection<MemoryAccess> writes = this.mam.getFieldWrites(f);
        for (MemoryAccess a : writes) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : writes) {
            IR ir = a.getNode().getIR();
            SSAPutInstruction s = (SSAPutInstruction)ir.getInstructions()[a.getInstructionIndex()];
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getVal());
            Assertions._assert(this.containsNode(r));
            written.add(r);
        }
        return written.iterator();
    }

    public Iterator<PointerKey> getReadsOfInstanceField(IField f) {
        if (f == ArrayContents.v()) {
            return this.getArrayReads();
        }
        Collection<MemoryAccess> reads = this.mam.getFieldReads(f);
        for (MemoryAccess a : reads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> readInto = new ArrayList<PointerKey>();
        for (MemoryAccess a : reads) {
            IR ir = a.getNode().getIR();
            SSAGetInstruction s = (SSAGetInstruction)ir.getInstructions()[a.getInstructionIndex()];
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            Assertions._assert(this.containsNode(r));
            readInto.add(r);
        }
        return readInto.iterator();
    }

    private Iterator<PointerKey> getArrayWrites() {
        Collection<MemoryAccess> arrayWrites = this.mam.getArrayWrites();
        for (MemoryAccess a : arrayWrites) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> written = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayWrites) {
            CGNode node = a.getNode();
            IR ir = node.getIR();
            SSAInstruction instruction = ir.getInstructions()[a.getInstructionIndex()];
            if (instruction instanceof SSAArrayStoreInstruction) {
                SSAArrayStoreInstruction s = (SSAArrayStoreInstruction)instruction;
                PointerKey r = this.heapModel.getPointerKeyForLocal(node, s.getValue());
                Assertions._assert(this.containsNode(r), "missing node for " + r);
                written.add(r);
                continue;
            }
            if (instruction instanceof SSANewInstruction) {
                SSANewInstruction n = (SSANewInstruction)instruction;
                InstanceKey iKey = this.heapModel.getInstanceKeyForAllocation(node, n.getNewSite());
                IClass klass = iKey.getConcreteType();
                Assertions._assert(klass.isArrayClass() && ((ArrayClass)klass).getElementClass().isArrayClass());
                int dim = 0;
                InstanceKey lastInstance = iKey;
                while (klass != null && klass.isArrayClass()) {
                    if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                    InstanceKey ik = this.heapModel.getInstanceKeyForMultiNewArray(node, n.getNewSite(), dim);
                    PointerKey pk = this.heapModel.getPointerKeyForArrayContents(lastInstance);
                    written.add(pk);
                    lastInstance = ik;
                    ++dim;
                }
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return written.iterator();
    }

    private Iterator<PointerKey> getArrayReads() {
        Collection<MemoryAccess> arrayReads = this.mam.getArrayReads();
        for (MemoryAccess a : arrayReads) {
            this.addSubgraphForNode(a.getNode());
        }
        ArrayList<PointerKey> read = new ArrayList<PointerKey>();
        for (MemoryAccess a : arrayReads) {
            IR ir = a.getNode().getIR();
            SSAArrayLoadInstruction s = (SSAArrayLoadInstruction)ir.getInstructions()[a.getInstructionIndex()];
            PointerKey r = this.heapModel.getPointerKeyForLocal(a.getNode(), s.getDef());
            Assertions._assert(this.containsNode(r));
            read.add(r);
        }
        return read.iterator();
    }

    protected abstract void addNodesForParameters(CGNode var1);

    public Iterator<Integer> pointerParamValueNums(CGNode node) {
        return new PointerParamValueNumIterator(node);
    }

    protected void unconditionallyAddConstraintsFromNode(CGNode node) {
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        IR ir = node.getIR();
        this.debugPrintIR(ir);
        if (ir == null) {
            return;
        }
        DefUse du = node.getDU();
        this.addNodeInstructionConstraints(node, ir, du);
        this.addNodePassthruExceptionConstraints(node, ir);
        this.addNodeConstantConstraints(node, ir);
    }

    private void addNodeConstantConstraints(CGNode node, IR ir) {
        SymbolTable symbolTable = ir.getSymbolTable();
        int i = 1;
        while (i <= symbolTable.getMaxValueNumber()) {
            Object v;
            if (symbolTable.isConstant(i) && !((v = symbolTable.getConstantValue(i)) instanceof Number)) {
                InstanceKey ik;
                Object S = symbolTable.getConstantValue(i);
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
                if (type != null && (ik = this.heapModel.getInstanceKeyForConstant(type, S)) != null) {
                    PointerKey pk = this.heapModel.getPointerKeyForLocal(node, i);
                    this.addNode(pk);
                    this.addNode(ik);
                    this.addEdge(pk, ik, NewLabel.v());
                }
            }
            ++i;
        }
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        this.addExceptionDefConstraints(ir, node, peis, exception, PropagationCallGraphBuilder.THROWABLE_SET);
    }

    protected void addExceptionDefConstraints(IR ir, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<TypeReference> catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.v());
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.heapModel.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                this.addNode(exceptionVar);
                this.addNode(e);
                this.addEdge(exceptionVar, e, AssignLabel.v());
            }
            Collection<TypeReference> types = pei.getExceptionTypes();
            if (types == null) continue;
            for (TypeReference type : types) {
                ConcreteTypeKey ck;
                IClass klass;
                if (type == null) continue;
                InstanceKey ik = this.heapModel.getInstanceKeyForPEI(node, peiLoc, type);
                if (!(ik instanceof ConcreteTypeKey)) {
                    Assertions._assert(ik instanceof ConcreteTypeKey, "uh oh: need to implement getCaughtException constraints for instance " + ik);
                }
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass = (ck = (ConcreteTypeKey)ik).getType(), this.cha)) continue;
                this.addNode(exceptionVar);
                this.addNode(ik);
                this.addEdge(exceptionVar, ik, NewLabel.v());
            }
        }
    }

    protected void addNodeInstructionConstraints(CGNode node, IR ir, DefUse du) {
        FlowStatementVisitor v = this.makeVisitor((ExplicitCallGraph.ExplicitNode)node, ir, du);
        SSACFG cfg = ir.getControlFlowGraph();
        for (ISSABasicBlock b : cfg) {
            this.addBlockInstructionConstraints(node, cfg, b, v);
        }
    }

    protected void addBlockInstructionConstraints(CGNode node, ControlFlowGraph<ISSABasicBlock> cfg, ISSABasicBlock b, FlowStatementVisitor v) {
        v.setBasicBlock(b);
        for (SSAInstruction s : b) {
            if (s == null) continue;
            s.visit(v);
        }
        this.addPhiConstraints(node, cfg, b);
    }

    private void addPhiConstraints(CGNode node, ControlFlowGraph<ISSABasicBlock> cfg, ISSABasicBlock b) {
        Iterator<ISSABasicBlock> iter = cfg.getSuccNodes(b);
        while (iter.hasNext()) {
            ISSABasicBlock sb = iter.next();
            if (sb.isExitBlock()) continue;
            int n = 0;
            Iterator<ISSABasicBlock> back = cfg.getPredNodes(sb);
            while (back.hasNext()) {
                if (back.next() == b) break;
                ++n;
            }
            Iterator<SSAPhiInstruction> phis = sb.iteratePhis();
            while (phis.hasNext()) {
                SSAPhiInstruction phi = phis.next();
                if (phi == null) continue;
                PointerKey def = this.heapModel.getPointerKeyForLocal(node, phi.getDef());
                if (phi.getUse(n) <= 0) continue;
                PointerKey use = this.heapModel.getPointerKeyForLocal(node, phi.getUse(n));
                this.addNode(def);
                this.addNode(use);
                this.addEdge(def, use, AssignLabel.v());
            }
        }
    }

    protected abstract FlowStatementVisitor makeVisitor(ExplicitCallGraph.ExplicitNode var1, IR var2, DefUse var3);

    private void debugPrintIR(IR ir) {
    }

    public DemandFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, ClassHierarchy cha) {
        this.cg = cg;
        this.heapModel = heapModel;
        this.mam = mam;
        this.cha = cha;
    }

    protected static interface FlowStatementVisitor
    extends SSAInstruction.IVisitor {
        public void setBasicBlock(ISSABasicBlock var1);
    }
}

