/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadClassInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warnings;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DemandPointerFlowGraph
extends DemandFlowGraph {
    public DemandPointerFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, ClassHierarchy cha) {
        super(cg, heapModel, mam, cha);
    }

    protected void addNodesForParameters(CGNode node) {
        Iterator<Integer> iter = this.pointerParamValueNums(node);
        while (iter.hasNext()) {
            int parameter = iter.next();
            PointerKey paramPk = this.heapModel.getPointerKeyForLocal(node, parameter);
            this.addNode(paramPk);
            this.params.put(paramPk, node);
        }
        PointerKey returnKey = this.heapModel.getPointerKeyForReturnValue(node);
        this.addNode(returnKey);
        this.returns.put(returnKey, node);
        PointerKey exceptionReturnKey = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        this.addNode(exceptionReturnKey);
        this.returns.put(exceptionReturnKey, node);
    }

    protected DemandFlowGraph.FlowStatementVisitor makeVisitor(ExplicitCallGraph.ExplicitNode node, IR ir, DefUse du) {
        return new StatementVisitor(node, ir, du);
    }

    protected class StatementVisitor
    extends SSAInstruction.Visitor
    implements DemandFlowGraph.FlowStatementVisitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public StatementVisitor(CGNode node, IR ir, DefUse du) {
            this.node = node;
            this.ir = ir;
            this.symbolTable = ir.getSymbolTable();
            Assertions._assert(this.symbolTable != null);
            this.du = du;
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey result = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey arrayRef = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandPointerFlowGraph.this.addNode(result);
            DemandPointerFlowGraph.this.addNode(arrayRef);
            DemandPointerFlowGraph.this.addEdge(result, arrayRef, GetFieldLabel.make(ArrayContents.v()));
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            PointerKey value = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getValue());
            PointerKey arrayRef = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandPointerFlowGraph.this.addNode(value);
            DemandPointerFlowGraph.this.addNode(arrayRef);
            DemandPointerFlowGraph.this.addEdge(arrayRef, value, PutFieldLabel.make(ArrayContents.v()));
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            IClass cls = DemandPointerFlowGraph.this.cha.lookupClass(instruction.getDeclaredResultType());
            FilteredPointerKey result = null;
            if (cls == null) {
                return;
            }
            result = DemandPointerFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, instruction.getResult(), new FilteredPointerKey.SingleClassFilter(cls));
            PointerKey value = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            DemandPointerFlowGraph.this.addNode(result);
            DemandPointerFlowGraph.this.addNode(value);
            DemandPointerFlowGraph.this.addEdge(result, value, AssignLabel.v());
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            DemandPointerFlowGraph.this.addNode(def);
            PointerKey returnValue = DemandPointerFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            DemandPointerFlowGraph.this.addNode(returnValue);
            DemandPointerFlowGraph.this.addEdge(returnValue, def, AssignLabel.v());
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = DemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(ResolutionFailure.create(this.node, field));
                return;
            }
            PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, lval);
            Assertions._assert(def != null);
            if (isStatic) {
                PointerKey fKey = DemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandPointerFlowGraph.this.addNode(def);
                DemandPointerFlowGraph.this.addNode(fKey);
                DemandPointerFlowGraph.this.addEdge(def, fKey, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandPointerFlowGraph.this.addNode(def);
                DemandPointerFlowGraph.this.addNode(refKey);
                DemandPointerFlowGraph.this.addEdge(def, refKey, GetFieldLabel.make(f));
            }
        }

        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = DemandPointerFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(ResolutionFailure.create(this.node, field));
                return;
            }
            PointerKey use = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, rval);
            Assertions._assert(use != null);
            if (isStatic) {
                PointerKey fKey = DemandPointerFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandPointerFlowGraph.this.addNode(use);
                DemandPointerFlowGraph.this.addNode(fKey);
                DemandPointerFlowGraph.this.addEdge(fKey, use, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandPointerFlowGraph.this.addNode(use);
                DemandPointerFlowGraph.this.addNode(refKey);
                DemandPointerFlowGraph.this.addEdge(refKey, use, PutFieldLabel.make(f));
            }
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            int i = 0;
            while (i < instruction.getNumberOfUses()) {
                PointerKey use = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getUse(i));
                DemandPointerFlowGraph.this.addNode(use);
                Set s = MapUtil.findOrCreateSet(DemandPointerFlowGraph.this.callParams, use);
                s.add(instruction);
                ++i;
            }
            if (instruction.hasDef()) {
                PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
                DemandPointerFlowGraph.this.addNode(def);
                DemandPointerFlowGraph.this.callDefs.put(def, instruction);
            }
            PointerKey exc = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getException());
            DemandPointerFlowGraph.this.addNode(exc);
            DemandPointerFlowGraph.this.callDefs.put(exc, instruction);
        }

        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = DemandPointerFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            DemandPointerFlowGraph.this.addNode(iKey);
            DemandPointerFlowGraph.this.addNode(def);
            DemandPointerFlowGraph.this.addEdge(def, iKey, NewLabel.v());
            IClass klass = iKey.getConcreteType();
            int dim = 0;
            InstanceKey lastInstance = iKey;
            PointerKey lastVar = def;
            while (klass != null && klass.isArrayClass()) {
                if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                InstanceKey ik = DemandPointerFlowGraph.this.heapModel.getInstanceKeyForMultiNewArray(this.node, instruction.getNewSite(), dim);
                PointerKey pk = DemandPointerFlowGraph.this.heapModel.getPointerKeyForArrayContents(lastInstance);
                DemandPointerFlowGraph.this.addNode(ik);
                DemandPointerFlowGraph.this.addNode(pk);
                DemandPointerFlowGraph.this.addEdge(pk, ik, NewLabel.v());
                DemandPointerFlowGraph.this.addEdge(lastVar, pk, PutFieldLabel.make(ArrayContents.v()));
                lastInstance = ik;
                lastVar = pk;
                ++dim;
            }
        }

        public void visitThrow(SSAThrowInstruction instruction) {
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            Set<TypeReference> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            DemandPointerFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, peis, def, types);
        }

        public void visitPi(SSAPiInstruction instruction) {
            Assertions.UNREACHABLE();
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        public void visitLoadClass(SSALoadClassInstruction instruction) {
            PointerKey def = DemandPointerFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            InstanceKey iKey = DemandPointerFlowGraph.this.heapModel.getInstanceKeyForClassObject(instruction.getLoadedClass());
            DemandPointerFlowGraph.this.addNode(iKey);
            DemandPointerFlowGraph.this.addNode(def);
            DemandPointerFlowGraph.this.addEdge(def, iKey, NewLabel.v());
        }
    }
}

