/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.DemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadClassInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.ResolutionFailure;
import com.ibm.wala.util.warnings.Warnings;
import java.util.List;
import java.util.Set;

public class DemandValueFlowGraph
extends DemandFlowGraph {
    public DemandValueFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, ClassHierarchy cha) {
        super(cg, heapModel, mam, cha);
    }

    protected void addNodesForParameters(CGNode node) {
        IR ir = node.getIR();
        SymbolTable symbolTable = ir.getSymbolTable();
        int numParams = symbolTable.getNumberOfParameters();
        int i = 0;
        while (i < numParams) {
            int parameter = symbolTable.getParameter(i);
            PointerKey paramPk = this.heapModel.getPointerKeyForLocal(node, parameter);
            this.addNode(paramPk);
            this.params.put(paramPk, node);
            ++i;
        }
        PointerKey returnKey = this.heapModel.getPointerKeyForReturnValue(node);
        this.addNode(returnKey);
        this.returns.put(returnKey, node);
        PointerKey exceptionReturnKey = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        this.addNode(exceptionReturnKey);
        this.returns.put(exceptionReturnKey, node);
    }

    protected DemandFlowGraph.FlowStatementVisitor makeVisitor(ExplicitCallGraph.ExplicitNode node, IR ir, DefUse du) {
        return new AllValsStatementVisitor(node, ir, du);
    }

    private class AllValsStatementVisitor
    extends SSAInstruction.Visitor
    implements DemandFlowGraph.FlowStatementVisitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public AllValsStatementVisitor(CGNode node, IR ir, DefUse du) {
            this.node = node;
            this.ir = ir;
            this.symbolTable = ir.getSymbolTable();
            Assertions._assert(this.symbolTable != null);
            this.du = du;
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            PointerKey result = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey arrayRef = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(result);
            DemandValueFlowGraph.this.addNode(arrayRef);
            DemandValueFlowGraph.this.addEdge(result, arrayRef, GetFieldLabel.make(ArrayContents.v()));
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            PointerKey value = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getValue());
            PointerKey arrayRef = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(value);
            DemandValueFlowGraph.this.addNode(arrayRef);
            DemandValueFlowGraph.this.addEdge(arrayRef, value, PutFieldLabel.make(ArrayContents.v()));
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            IClass cls = DemandValueFlowGraph.this.cha.lookupClass(instruction.getDeclaredResultType());
            FilteredPointerKey result = null;
            if (cls == null) {
                return;
            }
            result = DemandValueFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, instruction.getResult(), new FilteredPointerKey.SingleClassFilter(cls));
            PointerKey value = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            DemandValueFlowGraph.this.addNode(result);
            DemandValueFlowGraph.this.addNode(value);
            DemandValueFlowGraph.this.addEdge(result, value, AssignLabel.v());
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsVoid()) {
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            DemandValueFlowGraph.this.addNode(def);
            PointerKey returnValue = DemandValueFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            DemandValueFlowGraph.this.addNode(returnValue);
            DemandValueFlowGraph.this.addEdge(returnValue, def, AssignLabel.v());
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            IField f = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(ResolutionFailure.create(this.node, field));
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, lval);
            Assertions._assert(def != null);
            if (isStatic) {
                PointerKey fKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.addNode(fKey);
                DemandValueFlowGraph.this.addEdge(def, fKey, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.addNode(refKey);
                DemandValueFlowGraph.this.addEdge(def, refKey, GetFieldLabel.make(f));
            }
        }

        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            IField f = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(ResolutionFailure.create(this.node, field));
                return;
            }
            PointerKey use = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, rval);
            Assertions._assert(use != null);
            if (isStatic) {
                PointerKey fKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandValueFlowGraph.this.addNode(use);
                DemandValueFlowGraph.this.addNode(fKey);
                DemandValueFlowGraph.this.addEdge(fKey, use, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandValueFlowGraph.this.addNode(use);
                DemandValueFlowGraph.this.addNode(refKey);
                DemandValueFlowGraph.this.addEdge(refKey, use, PutFieldLabel.make(f));
            }
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            int i = 0;
            while (i < instruction.getNumberOfUses()) {
                PointerKey use = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getUse(i));
                DemandValueFlowGraph.this.addNode(use);
                Set s = MapUtil.findOrCreateSet(DemandValueFlowGraph.this.callParams, use);
                s.add(instruction);
                ++i;
            }
            if (instruction.hasDef()) {
                PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.callDefs.put(def, instruction);
            }
            PointerKey exc = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getException());
            DemandValueFlowGraph.this.addNode(exc);
            DemandValueFlowGraph.this.callDefs.put(exc, instruction);
        }

        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = DemandValueFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            DemandValueFlowGraph.this.addNode(iKey);
            DemandValueFlowGraph.this.addNode(def);
            DemandValueFlowGraph.this.addEdge(def, iKey, NewLabel.v());
            IClass klass = iKey.getConcreteType();
            int dim = 0;
            InstanceKey lastInstance = iKey;
            PointerKey lastVar = def;
            while (klass != null && klass.isArrayClass()) {
                if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                InstanceKey ik = DemandValueFlowGraph.this.heapModel.getInstanceKeyForMultiNewArray(this.node, instruction.getNewSite(), dim);
                PointerKey pk = DemandValueFlowGraph.this.heapModel.getPointerKeyForArrayContents(lastInstance);
                DemandValueFlowGraph.this.addNode(ik);
                DemandValueFlowGraph.this.addNode(pk);
                DemandValueFlowGraph.this.addEdge(pk, ik, NewLabel.v());
                DemandValueFlowGraph.this.addEdge(lastVar, pk, PutFieldLabel.make(ArrayContents.v()));
                lastInstance = ik;
                lastVar = pk;
                ++dim;
            }
        }

        public void visitThrow(SSAThrowInstruction instruction) {
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            Set<TypeReference> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            DemandValueFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, peis, def, types);
        }

        public void visitPi(SSAPiInstruction instruction) {
            PointerKey src = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey dst = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            DemandValueFlowGraph.this.addNode(src);
            DemandValueFlowGraph.this.addNode(dst);
            DemandValueFlowGraph.this.addEdge(src, dst, AssignLabel.v());
        }

        private void handleNonHeapInstruction(SSAInstruction instruction) {
            int i = 0;
            while (i < instruction.getNumberOfDefs()) {
                int def = instruction.getDef(i);
                PointerKey defPk = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, def);
                DemandValueFlowGraph.this.addNode(defPk);
                int j = 0;
                while (j < instruction.getNumberOfUses()) {
                    int use = instruction.getUse(j);
                    PointerKey usePk = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, use);
                    DemandValueFlowGraph.this.addNode(usePk);
                    DemandValueFlowGraph.this.addEdge(defPk, usePk, AssignLabel.v());
                    ++j;
                }
                ++i;
            }
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public void visitComparison(SSAComparisonInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public void visitConversion(SSAConversionInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        public void visitLoadClass(SSALoadClassInstruction instruction) {
            Assertions.UNREACHABLE();
        }
    }
}

