/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.genericutil;

import com.ibm.wala.demandpa.genericutil.ObjectVisitor;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySet<T>
extends AbstractSet<T> {
    private static final ArraySet EMPTY = new ArraySet<Object>(0, true){

        @Override
        public boolean add(Object obj_) {
            throw new RuntimeException();
        }
    };
    private T[] _elems;
    private int _curIndex = 0;
    private final boolean checkDupes;

    public static final <T> ArraySet<T> empty() {
        return EMPTY;
    }

    public ArraySet(int numElems_, boolean checkDupes) {
        this._elems = new Object[numElems_];
        this.checkDupes = checkDupes;
    }

    public ArraySet() {
        this(1, true);
    }

    public ArraySet(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        int size = other._curIndex;
        this._elems = new Object[size];
        this.checkDupes = other.checkDupes;
        this._curIndex = size;
        System.arraycopy(other._elems, 0, this._elems, 0, size);
    }

    private ArraySet(Collection<T> other) {
        this(other.size(), true);
        ((AbstractCollection)this).addAll(other);
    }

    @Override
    public boolean add(T obj_) {
        assert (obj_ != null);
        if (this.checkDupes && this.contains(obj_)) {
            return false;
        }
        if (this._curIndex == this._elems.length) {
            T[] tmp = this._elems;
            this._elems = new Object[tmp.length * 2];
            System.arraycopy(tmp, 0, this._elems, 0, tmp.length);
        }
        this._elems[this._curIndex] = obj_;
        ++this._curIndex;
        return true;
    }

    @Override
    public boolean addAll(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        boolean ret = false;
        int i = 0;
        while (i < other.size()) {
            boolean added = this.add(other.get(i));
            ret = ret || added;
            ++i;
        }
        return ret;
    }

    @Override
    public boolean contains(Object obj_) {
        int i = 0;
        while (i < this._curIndex) {
            if (this._elems[i].equals(obj_)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean intersects(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        int i = 0;
        while (i < other.size()) {
            if (this.contains(other.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void forall(ObjectVisitor<T> visitor_) {
        int i = 0;
        while (i < this._curIndex) {
            visitor_.visit(this._elems[i]);
            ++i;
        }
    }

    @Override
    public int size() {
        return this._curIndex;
    }

    public T get(int i) {
        return this._elems[i];
    }

    @Override
    public boolean remove(Object obj_) {
        int ind = 0;
        while (ind < this._curIndex && !this._elems[ind].equals(obj_)) {
            ++ind;
        }
        if (ind == this._curIndex) {
            return false;
        }
        return this.remove(ind);
    }

    public boolean remove(int ind) {
        System.arraycopy(this._elems, ind + 1, this._elems, ind, this._curIndex - (ind + 1));
        --this._curIndex;
        return true;
    }

    @Override
    public void clear() {
        this._curIndex = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArraySetIterator();
    }

    public static <T> ArraySet<T> make() {
        return new ArraySet<T>();
    }

    public static <T> ArraySet<T> make(Collection<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        return new ArraySet<T>(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArraySetIterator
    implements Iterator<T> {
        int ind = 0;
        final int setSize;

        public ArraySetIterator() {
            this.setSize = ArraySet.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.ind < this.setSize;
        }

        @Override
        public T next() {
            if (this.ind >= this.setSize) {
                throw new NoSuchElementException();
            }
            return ArraySet.this.get(this.ind++);
        }
    }
}

